/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBuf;
import io.netty.channel.unix.Buffer;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringBufferRingAllocator;
import io.netty.channel.uring.IoUringBufferRingExhaustedEvent;
import io.netty.channel.uring.Native;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.function.Consumer;

final class IoUringBufferRing {
    private static final VarHandle SHORT_HANDLE = MethodHandles.byteBufferViewVarHandle(short[].class, ByteOrder.nativeOrder());
    private final ByteBuffer ioUringBufRing;
    private final int tailFieldPosition;
    private final short entries;
    private final short mask;
    private final short bufferGroupId;
    private final int ringFd;
    private final ByteBuf[] buffers;
    private final IoUringBufferRingAllocator allocator;
    private final boolean batchAllocation;
    private final IoUringBufferRingExhaustedEvent exhaustedEvent;
    private final RingConsumer ringConsumer;
    private final boolean incremental;
    private final int batchSize;
    private boolean corrupted;
    private boolean closed;
    private int usableBuffers;
    private int allocatedBuffers;
    private boolean needExpand;
    private short lastGeneratedBid;

    IoUringBufferRing(int ringFd, ByteBuffer ioUringBufRing, short entries, int batchSize, short bufferGroupId, boolean incremental, IoUringBufferRingAllocator allocator, boolean batchAllocation) {
        assert (entries % 2 == 0);
        assert (batchSize % 2 == 0);
        this.batchSize = batchSize;
        this.ioUringBufRing = ioUringBufRing;
        this.tailFieldPosition = Native.IO_URING_BUFFER_RING_TAIL;
        this.entries = entries;
        this.mask = (short)(entries - 1);
        this.bufferGroupId = bufferGroupId;
        this.ringFd = ringFd;
        this.buffers = new ByteBuf[entries];
        this.incremental = incremental;
        this.allocator = allocator;
        this.batchAllocation = batchAllocation;
        this.ringConsumer = new RingConsumer();
        this.exhaustedEvent = new IoUringBufferRingExhaustedEvent(bufferGroupId);
    }

    boolean isUsable() {
        return !this.closed && !this.corrupted;
    }

    void initialize() {
        this.fill((short)0, this.batchSize);
        this.allocatedBuffers = this.batchSize;
    }

    boolean expand() {
        this.needExpand = true;
        return this.allocatedBuffers < this.buffers.length;
    }

    private void fill(short startBid, int buffers) {
        if (this.corrupted || this.closed) {
            return;
        }
        assert (buffers % 2 == 0);
        this.lastGeneratedBid = this.ringConsumer.fill(startBid, buffers);
        this.usableBuffers += buffers;
    }

    private void fill(short bid) {
        if (this.corrupted || this.closed) {
            return;
        }
        this.ringConsumer.fill(bid);
        ++this.usableBuffers;
    }

    IoUringBufferRingExhaustedEvent getExhaustedEvent() {
        return this.exhaustedEvent;
    }

    int attemptedBytesRead(short bid) {
        return this.buffers[bid].writableBytes();
    }

    private int calculateNextBufferBatch() {
        return Math.min(this.batchSize, this.entries - this.allocatedBuffers);
    }

    ByteBuf useBuffer(short bid, int read, boolean more) {
        assert (read > 0);
        ByteBuf byteBuf = this.buffers[bid];
        this.allocator.lastBytesRead(byteBuf.writableBytes(), read);
        ByteBuf buffer = byteBuf.retainedSlice(byteBuf.writerIndex(), read);
        byteBuf.writerIndex(byteBuf.writerIndex() + read);
        if (this.incremental && more && byteBuf.isWritable()) {
            return buffer;
        }
        this.buffers[bid] = null;
        byteBuf.release();
        if (--this.usableBuffers == 0) {
            int numBuffers = this.allocatedBuffers;
            if (this.needExpand) {
                this.needExpand = false;
                numBuffers += this.calculateNextBufferBatch();
            }
            this.fill((short)0, numBuffers);
            this.allocatedBuffers = numBuffers;
            assert (this.allocatedBuffers % 2 == 0);
        } else if (!this.batchAllocation) {
            this.fill(bid);
            if (this.needExpand && this.lastGeneratedBid == bid) {
                this.needExpand = false;
                int numBuffers = this.calculateNextBufferBatch();
                this.fill((short)(bid + 1), numBuffers);
                this.allocatedBuffers += numBuffers;
                assert (this.allocatedBuffers % 2 == 0);
            }
        }
        return buffer;
    }

    short nextBid(short bid) {
        return (short)(bid + 1 & this.allocatedBuffers - 1);
    }

    short bufferGroupId() {
        return this.bufferGroupId;
    }

    void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Native.ioUringUnRegisterBufRing(this.ringFd, Buffer.memoryAddress((ByteBuffer)this.ioUringBufRing), this.entries, this.bufferGroupId);
        for (ByteBuf byteBuf : this.buffers) {
            if (byteBuf == null) continue;
            byteBuf.release();
        }
        Arrays.fill(this.buffers, null);
    }

    private final class RingConsumer
    implements Consumer<ByteBuf> {
        private int expectedBuffers;
        private short num;
        private short bid;
        private short oldTail;

        private RingConsumer() {
        }

        short fill(short startBid, int numBuffers) {
            this.oldTail = SHORT_HANDLE.get(IoUringBufferRing.this.ioUringBufRing, IoUringBufferRing.this.tailFieldPosition);
            this.num = 0;
            this.bid = startBid;
            this.expectedBuffers = numBuffers;
            try {
                if (IoUringBufferRing.this.batchAllocation) {
                    IoUringBufferRing.this.allocator.allocateBatch(this, numBuffers);
                } else {
                    for (int i = 0; i < numBuffers; ++i) {
                        short s = this.bid;
                        this.bid = (short)(s + 1);
                        short s2 = this.num;
                        this.num = (short)(s2 + 1);
                        this.add(this.oldTail, s, s2, IoUringBufferRing.this.allocator.allocate());
                    }
                }
            }
            catch (Throwable t) {
                IoUringBufferRing.this.corrupted = true;
                for (int i = 0; i < IoUringBufferRing.this.buffers.length; ++i) {
                    ByteBuf buffer = IoUringBufferRing.this.buffers[i];
                    if (buffer == null) continue;
                    buffer.release();
                    ((IoUringBufferRing)IoUringBufferRing.this).buffers[i] = null;
                }
                throw t;
            }
            SHORT_HANDLE.setRelease(IoUringBufferRing.this.ioUringBufRing, IoUringBufferRing.this.tailFieldPosition, (short)(this.oldTail + this.num));
            return (short)(this.bid - 1);
        }

        void fill(short bid) {
            short tail = SHORT_HANDLE.get(IoUringBufferRing.this.ioUringBufRing, IoUringBufferRing.this.tailFieldPosition);
            this.add(tail, bid, 0, IoUringBufferRing.this.allocator.allocate());
            SHORT_HANDLE.setRelease(IoUringBufferRing.this.ioUringBufRing, IoUringBufferRing.this.tailFieldPosition, (short)(tail + 1));
        }

        @Override
        public void accept(ByteBuf byteBuf) {
            if (IoUringBufferRing.this.corrupted || IoUringBufferRing.this.closed) {
                byteBuf.release();
                throw new IllegalStateException("Already closed");
            }
            if (this.expectedBuffers == this.num) {
                byteBuf.release();
                throw new IllegalStateException("Produced too many buffers");
            }
            short s = this.bid;
            this.bid = (short)(s + 1);
            short s2 = this.num;
            this.num = (short)(s2 + 1);
            this.add(this.oldTail, s, s2, byteBuf);
        }

        private void add(int tail, short bid, int offset, ByteBuf byteBuf) {
            short ringIndex = (short)(tail + offset & IoUringBufferRing.this.mask);
            assert (IoUringBufferRing.this.buffers[bid] == null);
            long memoryAddress = IoUring.memoryAddress(byteBuf) + (long)byteBuf.writerIndex();
            int writable = byteBuf.writableBytes();
            int position = Native.SIZEOF_IOURING_BUF * ringIndex;
            IoUringBufferRing.this.ioUringBufRing.putLong(position + Native.IOURING_BUFFER_OFFSETOF_ADDR, memoryAddress);
            IoUringBufferRing.this.ioUringBufRing.putInt(position + Native.IOURING_BUFFER_OFFSETOF_LEN, writable);
            IoUringBufferRing.this.ioUringBufRing.putShort(position + Native.IOURING_BUFFER_OFFSETOF_BID, bid);
            ((IoUringBufferRing)IoUringBufferRing.this).buffers[bid] = byteBuf;
        }
    }
}

