/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.util.SparkErrorUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001C\u0006\r!\u0003\r\tA\u0004\u000b\t\u000bm\u0001A\u0011A\u000f\t\u000b\u0005\u0002A\u0011\u0001\u0012\t\u000fq\u0002\u0011\u0013!C\u0001{!9\u0001\nAI\u0001\n\u0003i\u0004\"B%\u0001\t\u0003Q\u0005\"\u00020\u0001\t\u0003y\u0006\"\u00027\u0001\t\u0003iwA\u0002@\r\u0011\u0003qqPB\u0004\f\u0019!\u0005a\"a\u0001\t\u000f\u0005\u001d\u0011\u0002\"\u0001\u0002\n\t\u00012\u000b]1sWN#(/Z1n+RLGn\u001d\u0006\u0003\u001b9\tA!\u001e;jY*\u0011q\u0002E\u0001\u0006gB\f'o\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0005\u0002\u0001+A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$3\u0001\u0001\u000b\u0002=A\u0011acH\u0005\u0003A]\u0011A!\u00168ji\u0006Q1m\u001c9z'R\u0014X-Y7\u0015\u000b\r2\u0003'\u000e\u001e\u0011\u0005Y!\u0013BA\u0013\u0018\u0005\u0011auN\\4\t\u000b\u001d\u0012\u0001\u0019\u0001\u0015\u0002\u0005%t\u0007CA\u0015/\u001b\u0005Q#BA\u0016-\u0003\tIwNC\u0001.\u0003\u0011Q\u0017M^1\n\u0005=R#aC%oaV$8\u000b\u001e:fC6DQ!\r\u0002A\u0002I\n1a\\;u!\tI3'\u0003\u00025U\taq*\u001e;qkR\u001cFO]3b[\"9aG\u0001I\u0001\u0002\u00049\u0014\u0001D2m_N,7\u000b\u001e:fC6\u001c\bC\u0001\f9\u0013\tItCA\u0004C_>dW-\u00198\t\u000fm\u0012\u0001\u0013!a\u0001o\u0005\tBO]1og\u001a,'\u000fV8F]\u0006\u0014G.\u001a3\u0002)\r|\u0007/_*ue\u0016\fW\u000e\n3fM\u0006,H\u000e\u001e\u00134+\u0005q$FA\u001c@W\u0005\u0001\u0005CA!G\u001b\u0005\u0011%BA\"E\u0003%)hn\u00195fG.,GM\u0003\u0002F/\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u001d\u0013%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!2m\u001c9z'R\u0014X-Y7%I\u00164\u0017-\u001e7uIQ\n\u0011cY8qs\u001aKG.Z*ue\u0016\fWNT%P)\u0015q2*\u0016.]\u0011\u0015aU\u00011\u0001N\u0003\u0015Ig\u000e];u!\tq5+D\u0001P\u0015\t\u0001\u0016+\u0001\u0005dQ\u0006tg.\u001a7t\u0015\t\u0011F&A\u0002oS>L!\u0001V(\u0003\u0017\u0019KG.Z\"iC:tW\r\u001c\u0005\u0006-\u0016\u0001\raV\u0001\u0007_V$\b/\u001e;\u0011\u00059C\u0016BA-P\u0005M9&/\u001b;bE2,')\u001f;f\u0007\"\fgN\\3m\u0011\u0015YV\u00011\u0001$\u00035\u0019H/\u0019:u!>\u001c\u0018\u000e^5p]\")Q,\u0002a\u0001G\u0005Y!-\u001f;fgR{7i\u001c9z\u0003!!xn\u0015;sS:<GC\u00011l!\t\t\u0007N\u0004\u0002cMB\u00111mF\u0007\u0002I*\u0011Q\rH\u0001\u0007yI|w\u000e\u001e \n\u0005\u001d<\u0012A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!aZ\f\t\u000b\u001d2\u0001\u0019\u0001\u0015\u0002\u0013I,\u0017\r\u001a$vY2LH#\u0002\u0010o_^d\b\"B\u0014\b\u0001\u0004A\u0003\"\u00029\b\u0001\u0004\t\u0018aA1seB\u0019aC\u001d;\n\u0005M<\"!B!se\u0006L\bC\u0001\fv\u0013\t1xC\u0001\u0003CsR,\u0007\"\u0002=\b\u0001\u0004I\u0018aA8gMB\u0011aC_\u0005\u0003w^\u00111!\u00138u\u0011\u0015ix\u00011\u0001z\u0003\raWM\\\u0001\u0011'B\f'o[*ue\u0016\fW.\u0016;jYN\u00042!!\u0001\n\u001b\u0005a1\u0003B\u0005\u0016\u0003\u000b\u00012!!\u0001\u0001\u0003\u0019a\u0014N\\5u}Q\tq\u0010")
public interface SparkStreamUtils {
    public static /* synthetic */ long copyStream$(SparkStreamUtils $this, InputStream in, OutputStream out, boolean closeStreams, boolean transferToEnabled) {
        return $this.copyStream(in, out, closeStreams, transferToEnabled);
    }

    default public long copyStream(InputStream in, OutputStream out, boolean closeStreams, boolean transferToEnabled) {
        return BoxesRunTime.unboxToLong(SparkErrorUtils$.MODULE$.tryWithSafeFinally((JFunction0.mcJ.sp & Serializable)() -> {
            Tuple2 tuple2 = new Tuple2((Object)in, (Object)out);
            if (tuple2 != null) {
                InputStream input = (InputStream)tuple2._1();
                OutputStream output = (OutputStream)tuple2._2();
                if (input instanceof FileInputStream) {
                    FileInputStream fileInputStream = (FileInputStream)input;
                    if (output instanceof FileOutputStream) {
                        FileOutputStream fileOutputStream = (FileOutputStream)output;
                        if (transferToEnabled) {
                            FileChannel inChannel = fileInputStream.getChannel();
                            FileChannel outChannel = fileOutputStream.getChannel();
                            long size = inChannel.size();
                            this.copyFileStreamNIO(inChannel, outChannel, 0L, size);
                            return size;
                        }
                    }
                }
            }
            if (tuple2 != null) {
                InputStream input = (InputStream)tuple2._1();
                OutputStream output = (OutputStream)tuple2._2();
                long count = 0L;
                byte[] buf = new byte[8192];
                int n = 0;
                while (n != -1) {
                    n = input.read(buf);
                    if (n == -1) continue;
                    output.write(buf, 0, n);
                    count += (long)n;
                }
                return count;
            }
            throw new MatchError((Object)tuple2);
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (closeStreams) {
                try {
                    in.close();
                }
                finally {
                    out.close();
                }
                return;
            }
        }));
    }

    public static /* synthetic */ boolean copyStream$default$3$(SparkStreamUtils $this) {
        return $this.copyStream$default$3();
    }

    default public boolean copyStream$default$3() {
        return false;
    }

    public static /* synthetic */ boolean copyStream$default$4$(SparkStreamUtils $this) {
        return $this.copyStream$default$4();
    }

    default public boolean copyStream$default$4() {
        return false;
    }

    public static /* synthetic */ void copyFileStreamNIO$(SparkStreamUtils $this, FileChannel input, WritableByteChannel output, long startPosition, long bytesToCopy) {
        $this.copyFileStreamNIO(input, output, startPosition, bytesToCopy);
    }

    default public void copyFileStreamNIO(FileChannel input, WritableByteChannel output, long startPosition, long bytesToCopy) {
        None$ none$;
        WritableByteChannel writableByteChannel = output;
        if (writableByteChannel instanceof FileChannel) {
            FileChannel fileChannel = (FileChannel)writableByteChannel;
            none$ = new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)fileChannel.position()), (Object)fileChannel));
        } else {
            none$ = None$.MODULE$;
        }
        None$ outputInitialState = none$;
        LongRef count = LongRef.create((long)0L);
        while (count.elem < bytesToCopy) {
            count.elem += input.transferTo(count.elem + startPosition, bytesToCopy - count.elem, output);
        }
        Predef$.MODULE$.assert(count.elem == bytesToCopy, (Function0 & Serializable)() -> "request to copy " + bytesToCopy + " bytes, but actually copied " + count$1.elem + " bytes.");
        outputInitialState.foreach((Function1 & Serializable)x0$1 -> {
            SparkStreamUtils.$anonfun$copyFileStreamNIO$2(bytesToCopy, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ String toString$(SparkStreamUtils $this, InputStream in) {
        return $this.toString(in);
    }

    default public String toString(InputStream in) {
        return JavaUtils.toString((InputStream)in);
    }

    public static /* synthetic */ void readFully$(SparkStreamUtils $this, InputStream in, byte[] arr, int off, int len) {
        $this.readFully(in, arr, off, len);
    }

    default public void readFully(InputStream in, byte[] arr, int off, int len) {
        JavaUtils.readFully((InputStream)in, (byte[])arr, (int)off, (int)len);
    }

    public static /* synthetic */ void $anonfun$copyFileStreamNIO$2(long bytesToCopy$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long expectedPos;
            long initialPos = tuple2._1$mcJ$sp();
            FileChannel outputFileChannel = (FileChannel)tuple2._2();
            long finalPos = outputFileChannel.position();
            Predef$.MODULE$.assert(finalPos == (expectedPos = initialPos + bytesToCopy$1), (Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |Current position " + finalPos + " do not equal to expected position " + expectedPos + "\n           |after transferTo, please check your kernel version to see if it is 2.6.32,\n           |this is a kernel bug which will lead to unexpected behavior when using transferTo.\n           |You can set spark.file.transferTo = false to disable this NIO feature.\n         ")));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static void $init$(SparkStreamUtils $this) {
    }
}

