/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ToNumber$;
import org.apache.spark.sql.catalyst.expressions.ToNumberBase;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n     _FUNC_(expr, fmt) - Convert string 'expr' to a number based on the string format 'fmt'.\n       Throws an exception if the conversion fails. The format can consist of the following\n       characters, case insensitive:\n         '0' or '9': Specifies an expected digit between 0 and 9. A sequence of 0 or 9 in the format\n           string matches a sequence of digits in the input string. If the 0/9 sequence starts with\n           0 and is before the decimal point, it can only match a digit sequence of the same size.\n           Otherwise, if the sequence starts with 9 or is after the decimal point, it can match a\n           digit sequence that has the same or smaller size.\n         '.' or 'D': Specifies the position of the decimal point (optional, only allowed once).\n         ',' or 'G': Specifies the position of the grouping (thousands) separator (,). There must be\n           a 0 or 9 to the left and right of each grouping separator. 'expr' must match the\n           grouping separator relevant for the size of the number.\n         '$': Specifies the location of the $ currency sign. This character may only be specified\n           once.\n         'S' or 'MI': Specifies the position of a '-' or '+' sign (optional, only allowed once at\n           the beginning or end of the format string). Note that 'S' allows '-' but 'MI' does not.\n         'PR': Only allowed at the end of the format string; specifies that 'expr' indicates a\n           negative number with wrapping angled brackets.\n           ('<1>').\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('454', '999');\n       454\n      > SELECT _FUNC_('454.00', '000.00');\n       454.00\n      > SELECT _FUNC_('12,454', '99,999');\n       12454\n      > SELECT _FUNC_('$78.12', '$99.99');\n       78.12\n      > SELECT _FUNC_('12,454.8-', '99,999.9S');\n       -12454.8\n  ", since="3.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001B\r\u001b\u0001\u001eB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005q\b\u0003\u0005F\u0001\tE\t\u0015!\u0003A\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015)\u0006\u0001\"\u0015W\u0011\u001dY\u0006!!A\u0005\u0002qCqa\u0018\u0001\u0012\u0002\u0013\u0005\u0001\rC\u0004l\u0001E\u0005I\u0011\u00011\t\u000f1\u0004\u0011\u0011!C![\"9Q\u000fAA\u0001\n\u00031\bb\u0002>\u0001\u0003\u0003%\ta\u001f\u0005\n\u0003\u0007\u0001\u0011\u0011!C!\u0003\u000bA\u0011\"a\u0005\u0001\u0003\u0003%\t!!\u0006\t\u0013\u0005}\u0001!!A\u0005B\u0005\u0005\u0002\"CA\u0013\u0001\u0005\u0005I\u0011IA\u0014\u000f%\tYEGA\u0001\u0012\u0003\tiE\u0002\u0005\u001a5\u0005\u0005\t\u0012AA(\u0011\u001915\u0003\"\u0001\u0002h!I\u0011\u0011N\n\u0002\u0002\u0013\u0015\u00131\u000e\u0005\n\u0003[\u001a\u0012\u0011!CA\u0003_B\u0011\"!\u001e\u0014\u0003\u0003%\t)a\u001e\t\u0013\u0005%5#!A\u0005\n\u0005-%\u0001\u0003+p\u001dVl'-\u001a:\u000b\u0005ma\u0012aC3yaJ,7o]5p]NT!!\b\u0010\u0002\u0011\r\fG/\u00197zgRT!a\b\u0011\u0002\u0007M\fHN\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0015-eA\u0011\u0011FK\u0007\u00025%\u00111F\u0007\u0002\r)>tU/\u001c2fe\n\u000b7/\u001a\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\b!J|G-^2u!\t\u00194H\u0004\u00025s9\u0011Q\u0007O\u0007\u0002m)\u0011qGJ\u0001\u0007yI|w\u000e\u001e \n\u0003=J!A\u000f\u0018\u0002\u000fA\f7m[1hK&\u0011A(\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003u9\nA\u0001\\3giV\t\u0001\t\u0005\u0002*\u0003&\u0011!I\u0007\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!\u00027fMR\u0004\u0013!\u0002:jO\"$\u0018A\u0002:jO\"$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u0011&S\u0005CA\u0015\u0001\u0011\u0015qT\u00011\u0001A\u0011\u0015!U\u00011\u0001A\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002\u001bB\u0011aJ\u0015\b\u0003\u001fB\u0003\"!\u000e\u0018\n\u0005Es\u0013A\u0002)sK\u0012,g-\u0003\u0002T)\n11\u000b\u001e:j]\u001eT!!\u0015\u0018\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGc\u0001%X3\")\u0001l\u0002a\u0001\u0001\u00069a.Z<MK\u001a$\b\"\u0002.\b\u0001\u0004\u0001\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0004\u0011vs\u0006b\u0002 \t!\u0003\u0005\r\u0001\u0011\u0005\b\t\"\u0001\n\u00111\u0001A\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u0019\u0016\u0003\u0001\n\\\u0013a\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005!t\u0013AC1o]>$\u0018\r^5p]&\u0011!.\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u00039\u0004\"a\u001c;\u000e\u0003AT!!\u001d:\u0002\t1\fgn\u001a\u0006\u0002g\u0006!!.\u0019<b\u0013\t\u0019\u0006/\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001x!\ti\u00030\u0003\u0002z]\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0011Ap \t\u0003[uL!A \u0018\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u00025\t\t\u00111\u0001x\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0001\t\u0006\u0003\u0013\ty\u0001`\u0007\u0003\u0003\u0017Q1!!\u0004/\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\tYA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\f\u0003;\u00012!LA\r\u0013\r\tYB\f\u0002\b\u0005>|G.Z1o\u0011!\t\taDA\u0001\u0002\u0004a\u0018A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$2A\\A\u0012\u0011!\t\t\u0001EA\u0001\u0002\u00049\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0018\u0005%\u0002\u0002CA\u0001#\u0005\u0005\t\u0019\u0001?)'\u0001\ti#a\r\u00026\u0005e\u00121HA \u0003\u0003\n)%a\u0012\u0011\u0007%\ny#C\u0002\u00022i\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u00028\u0005YYO\u0003\u0011!A\u0001\u0002sLR+O\u0007~CS\r\u001f9sY\u00012W\u000e^\u0015![\u0001\u001auN\u001c<feR\u00043\u000f\u001e:j]\u001e\u0004s%\u001a=qe\u001e\u0002Co\u001c\u0011bA9,XNY3sA\t\f7/\u001a3!_:\u0004C\u000f[3!gR\u0014\u0018N\\4!M>\u0014X.\u0019;!O\u0019lGo\n\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!)\"\u0014xn^:!C:\u0004S\r_2faRLwN\u001c\u0011jM\u0002\"\b.\u001a\u0011d_:4XM]:j_:\u0004c-Y5mg:\u0002C\u000b[3!M>\u0014X.\u0019;!G\u0006t\u0007eY8og&\u001cH\u000fI8gAQDW\r\t4pY2|w/\u001b8h\u0015\u0001\u0002\u0003\u0005\t\u0011!A\rD\u0017M]1di\u0016\u00148\u000f\f\u0011dCN,\u0007%\u001b8tK:\u001c\u0018\u000e^5wKjR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u00141O\u0001z'\u000fI\u0014:Oi\u00023\u000b]3dS\u001aLWm\u001d\u0011b]\u0002*\u0007\u0010]3di\u0016$\u0007\u0005Z5hSR\u0004#-\u001a;xK\u0016t\u0007\u0005\r\u0011b]\u0012\u0004\u0013H\f\u0011BAM,\u0017/^3oG\u0016\u0004sN\u001a\u00111A=\u0014\b%\u000f\u0011j]\u0002\"\b.\u001a\u0011g_Jl\u0017\r\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u00023\u000f\u001e:j]\u001e\u0004S.\u0019;dQ\u0016\u001c\b%\u0019\u0011tKF,XM\\2fA=4\u0007\u0005Z5hSR\u001c\b%\u001b8!i\",\u0007%\u001b8qkR\u00043\u000f\u001e:j]\u001et\u0003%\u00134!i\",\u0007\u0005M\u0018:AM,\u0017/^3oG\u0016\u00043\u000f^1siN\u0004s/\u001b;i\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0019!C:$\u0007%[:!E\u00164wN]3!i\",\u0007\u0005Z3dS6\fG\u000e\t9pS:$H\u0006I5uA\r\fg\u000eI8oYf\u0004S.\u0019;dQ\u0002\n\u0007\u0005Z5hSR\u00043/Z9vK:\u001cW\rI8gAQDW\rI:b[\u0016\u00043/\u001b>f])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011Pi\",'o^5tK2\u0002\u0013N\u001a\u0011uQ\u0016\u00043/Z9vK:\u001cW\rI:uCJ$8\u000fI<ji\"\u0004\u0013\bI8sA%\u001c\b%\u00194uKJ\u0004C\u000f[3!I\u0016\u001c\u0017.\\1mAA|\u0017N\u001c;-A%$\beY1oA5\fGo\u00195!C*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011eS\u001eLG\u000fI:fcV,gnY3!i\"\fG\u000f\t5bg\u0002\"\b.\u001a\u0011tC6,\u0007e\u001c:!g6\fG\u000e\\3sAML'0\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001:cf\n\u0011pe\u0002:Ci\n\u001e!'B,7-\u001b4jKN\u0004C\u000f[3!a>\u001c\u0018\u000e^5p]\u0002zg\r\t;iK\u0002\"WmY5nC2\u0004\u0003o\\5oi\u0002Bs\u000e\u001d;j_:\fG\u000e\f\u0011p]2L\b%\u00197m_^,G\rI8oG\u0016LcF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!O1:\u0003e\u001c:!O\u001d;#\bI*qK\u000eLg-[3tAQDW\r\t9pg&$\u0018n\u001c8!_\u001a\u0004C\u000f[3!OJ|W\u000f]5oO\u0002BC\u000f[8vg\u0006tGm]\u0015!g\u0016\u0004\u0018M]1u_J\u0004\u0003\u0006L\u0015/AQCWM]3![V\u001cH\u000f\t2f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I1!a\u0001z'\u000fI\u001d!i>\u0004C\u000f[3!Y\u00164G\u000fI1oI\u0002\u0012\u0018n\u001a5uA=4\u0007%Z1dQ\u0002:'o\\;qS:<\u0007e]3qCJ\fGo\u001c:/A\u001d*\u0007\u0010\u001d:(A5,8\u000f\u001e\u0011nCR\u001c\u0007\u000e\t;iK*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011he>,\b/\u001b8hAM,\u0007/\u0019:bi>\u0014\bE]3mKZ\fg\u000e\u001e\u0011g_J\u0004C\u000f[3!g&TX\rI8gAQDW\r\t8v[\n,'O\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u001d\"sE\u000f\u0011Ta\u0016\u001c\u0017NZ5fg\u0002\"\b.\u001a\u0011m_\u000e\fG/[8oA=4\u0007\u0005\u001e5fA\u0011\u00023-\u001e:sK:\u001c\u0017\u0010I:jO:t\u0003\u0005\u00165jg\u0002\u001a\u0007.\u0019:bGR,'\u000fI7bs\u0002zg\u000e\\=!E\u0016\u00043\u000f]3dS\u001aLW\r\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002sN\\2f])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003eJ*(A=\u0014\beJ'JOi\u00023\u000b]3dS\u001aLWm\u001d\u0011uQ\u0016\u0004\u0003o\\:ji&|g\u000eI8gA\u0005\u0004s%L\u0014!_J\u0004seK\u0014!g&<g\u000e\t\u0015paRLwN\\1mY\u0001zg\u000e\\=!C2dwn^3eA=t7-\u001a\u0011bi*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011uQ\u0016\u0004#-Z4j]:Lgn\u001a\u0011pe\u0002*g\u000e\u001a\u0011pM\u0002\"\b.\u001a\u0011g_Jl\u0017\r\u001e\u0011tiJLgnZ\u0015/A9{G/\u001a\u0011uQ\u0006$\beJ*(A\u0005dGn\\<tA\u001djs\u0005\t2vi\u0002:S*S\u0014!I>,7\u000f\t8pi:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0014Q%\u001eR\u0004e\u00148ms\u0002\nG\u000e\\8xK\u0012\u0004\u0013\r\u001e\u0011uQ\u0016\u0004SM\u001c3!_\u001a\u0004C\u000f[3!M>\u0014X.\u0019;!gR\u0014\u0018N\\4<AM\u0004XmY5gS\u0016\u001c\b\u0005\u001e5bi\u0002:S\r\u001f9sO\u0001Jg\u000eZ5dCR,7\u000fI1\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003E\\3hCRLg/\u001a\u0011ok6\u0014WM\u001d\u0011xSRD\u0007e\u001e:baBLgn\u001a\u0011b]\u001edW\r\u001a\u0011ce\u0006\u001c7.\u001a;t])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011)Oq\ndhJ\u0015/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0012Aa\u0016\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\"T\u0007N\u0014-A\u001dJ\u0014(O\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\"T\u0007\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OQ*DG\f\u00191O1\u0002s\u0005\r\u00191]A\u0002t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iU\"d\u0006\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n$\u0007\f\u001b6i\u001db\u0003eJ\u001d:YeJ\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\u0012D'\u000e\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\"s\u0007\u000f\u00182e\u001db\u0003e\n\u0013:s9J\u0014hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A]Bd&\r\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n$\u0007\f\u001b6i9BTf\n\u0017!OeJD&O\u001d:]e\u001av%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011![E\u0012D'\u000e\u001b/q)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002D\u0005)1GL\u001a/a\u0005)qM]8va\u0006\u0012\u0011\u0011J\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\t)>tU/\u001c2feB\u0011\u0011fE\n\u0006'\u0005E\u0013Q\f\t\b\u0003'\nI\u0006\u0011!I\u001b\t\t)FC\u0002\u0002X9\nqA];oi&lW-\u0003\u0003\u0002\\\u0005U#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011qLA3\u001b\t\t\tGC\u0002\u0002dI\f!![8\n\u0007q\n\t\u0007\u0006\u0002\u0002N\u0005AAo\\*ue&tw\rF\u0001o\u0003\u0015\t\u0007\u000f\u001d7z)\u0015A\u0015\u0011OA:\u0011\u0015qd\u00031\u0001A\u0011\u0015!e\u00031\u0001A\u0003\u001d)h.\u00199qYf$B!!\u001f\u0002\u0006B)Q&a\u001f\u0002\u0000%\u0019\u0011Q\u0010\u0018\u0003\r=\u0003H/[8o!\u0015i\u0013\u0011\u0011!A\u0013\r\t\u0019I\f\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005\u001du#!AA\u0002!\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\ti\tE\u0002p\u0003\u001fK1!!%q\u0005\u0019y%M[3di\u0002")
public class ToNumber
extends ToNumberBase {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(ToNumber x$0) {
        return ToNumber$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ToNumber> tupled() {
        return ToNumber$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ToNumber>> curried() {
        return ToNumber$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String prettyName() {
        return "to_number";
    }

    @Override
    public ToNumber withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ToNumber copy(Expression left, Expression right) {
        return new ToNumber(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ToNumber";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToNumber;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToNumber)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToNumber toNumber = (ToNumber)x$1;
        Expression expression = this.left();
        Expression expression2 = toNumber.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = toNumber.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!toNumber.canEqual(this)) return false;
        return true;
    }

    public ToNumber(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        super(left, right, true);
    }
}

