/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.OpenedParquetFooter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.execution.vectorized.ConstantColumnVector;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.internal.SessionStateHelper;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.SerializableConfiguration$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r\rc\u0001\u0002\u0011\"\u0001ABQ\u0001\u0017\u0001\u0005\u0002eCQ\u0001\u0018\u0001\u0005BuCQA\u001a\u0001\u0005BuCQa\u001a\u0001\u0005B!DQ\u0001\u001c\u0001\u0005B5DQA\u001e\u0001\u0005B]Dq!!\r\u0001\t\u0003\n\u0019\u0004C\u0004\u0002X\u0001!\t%!\u0017\t\u000f\u0005\u0005\u0004\u0001\"\u0011\u0002d!9\u00111\u0010\u0001\u0005B\u0005u\u0004bBAG\u0001\u0011%\u0011q\u0012\u0005\b\u0003W\u0003A\u0011IAW\u0011\u001d\t)\u000f\u0001C\u0005\u0003ODqA!\u001c\u0001\t\u0013\u0011y\u0007C\u0004\u00030\u0002!\tE!-\t\u000f\tu\u0006\u0001\"\u0011\u0003@\u001e9!\u0011Z\u0011\t\u0002\t-gA\u0002\u0011\"\u0011\u0003\u0011i\r\u0003\u0004Y%\u0011\u0005!1\u001b\u0005\n\u0005+\u0014\"\u0019!C\u0001\u0005/D\u0001Ba9\u0013A\u0003%!\u0011\u001c\u0005\n\u0005K\u0014\"\u0019!C\u0001\u0005/D\u0001Ba:\u0013A\u0003%!\u0011\u001c\u0005\n\u0005S\u0014\"\u0019!C\u0001\u0005WD\u0001B!<\u0013A\u0003%!1\u0019\u0005\t\u0005_\u0014B\u0011A\u0011\u0003r\"A1Q\u0001\n\u0005\u0002\u0005\u001a9\u0001C\u0004\u0004\u0014I!\ta!\u0006\t\u000f\r}!\u0003\"\u0001\u0004\"!91\u0011\u0007\n\u0005\n\rM\u0002\"CB\u001d%\u0005\u0005I\u0011BB\u001e\u0005E\u0001\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u0003E\r\nq\u0001]1scV,GO\u0003\u0002%K\u0005YA-\u0019;bg>,(oY3t\u0015\t1s%A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0001&K\u0001\u0004gFd'B\u0001\u0016,\u0003\u0015\u0019\b/\u0019:l\u0015\taS&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002]\u0005\u0019qN]4\u0004\u0001M9\u0001!M\u001c<\u0003\u001ec\u0005C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$AB!osJ+g\r\u0005\u00029s5\t1%\u0003\u0002;G\tQa)\u001b7f\r>\u0014X.\u0019;\u0011\u0005qzT\"A\u001f\u000b\u0005y:\u0013aB:pkJ\u001cWm]\u0005\u0003\u0001v\u0012!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u0011!)R\u0007\u0002\u0007*\u0011AiJ\u0001\tS:$XM\u001d8bY&\u0011ai\u0011\u0002\u0013'\u0016\u001c8/[8o'R\fG/\u001a%fYB,'\u000f\u0005\u0002I\u00156\t\u0011J\u0003\u0002ES%\u00111*\u0013\u0002\b\u0019><w-\u001b8h!\tiUK\u0004\u0002O':\u0011qJU\u0007\u0002!*\u0011\u0011kL\u0001\u0007yI|w\u000e\u001e \n\u0003QJ!\u0001V\u001a\u0002\u000fA\f7m[1hK&\u0011ak\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003)N\na\u0001P5oSRtD#\u0001.\u0011\u0005m\u0003Q\"A\u0011\u0002\u0013MDwN\u001d;OC6,G#\u00010\u0011\u0005}\u001bgB\u00011b!\ty5'\u0003\u0002cg\u00051\u0001K]3eK\u001aL!\u0001Z3\u0003\rM#(/\u001b8h\u0015\t\u00117'\u0001\u0005u_N#(/\u001b8h\u0003!A\u0017m\u001d5D_\u0012,G#A5\u0011\u0005IR\u0017BA64\u0005\rIe\u000e^\u0001\u0007KF,\u0018\r\\:\u0015\u00059\f\bC\u0001\u001ap\u0013\t\u00018GA\u0004C_>dW-\u00198\t\u000bI,\u0001\u0019A:\u0002\u000b=$\b.\u001a:\u0011\u0005I\"\u0018BA;4\u0005\r\te._\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\tqn\f\u0019!a\u0006\u0002\"A\u0011\u0001(_\u0005\u0003u\u000e\u00121cT;uaV$xK]5uKJ4\u0015m\u0019;pefDQ\u0001 \u0004A\u0002u\fAb\u001d9be.\u001cVm]:j_:\u0004\"A`@\u000e\u0003\u001dJ1!!\u0001(\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u001d\t)A\u0002a\u0001\u0003\u000f\t1A[8c!\u0011\tI!a\u0005\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\t\u0011\"\\1qe\u0016$WoY3\u000b\u0007\u0005E1&\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003+\tYAA\u0002K_\nDq!!\u0007\u0007\u0001\u0004\tY\"A\u0004paRLwN\\:\u0011\u000b}\u000biB\u00180\n\u0007\u0005}QMA\u0002NCBDq!a\t\u0007\u0001\u0004\t)#\u0001\u0006eCR\f7k\u00195f[\u0006\u0004B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003W9\u0013!\u0002;za\u0016\u001c\u0018\u0002BA\u0018\u0003S\u0011!b\u0015;sk\u000e$H+\u001f9f\u0003-IgNZ3s'\u000eDW-\\1\u0015\u0011\u0005U\u00121HA\u001f\u0003\u0003\u0002RAMA\u001c\u0003KI1!!\u000f4\u0005\u0019y\u0005\u000f^5p]\")Ap\u0002a\u0001{\"9\u0011qH\u0004A\u0002\u0005m\u0011A\u00039be\u0006lW\r^3sg\"9\u00111I\u0004A\u0002\u0005\u0015\u0013!\u00024jY\u0016\u001c\b#B'\u0002H\u0005-\u0013bAA%/\n\u00191+Z9\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fRA!!\u0015\u0002\u0010\u0005\u0011am]\u0005\u0005\u0003+\nyE\u0001\u0006GS2,7\u000b^1ukN\fAb];qa>\u0014HOQ1uG\"$RA\\A.\u0003;BQ\u0001 \u0005A\u0002uDq!a\u0018\t\u0001\u0004\t)#\u0001\u0004tG\",W.Y\u0001\fm\u0016\u001cGo\u001c:UsB,7\u000f\u0006\u0005\u0002f\u0005%\u0014QNA9!\u0015\u0011\u0014qGA4!\u0011i\u0015q\t0\t\u000f\u0005-\u0014\u00021\u0001\u0002&\u0005q!/Z9vSJ,GmU2iK6\f\u0007bBA8\u0013\u0001\u0007\u0011QE\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"9\u00111O\u0005A\u0002\u0005U\u0014aB:rY\u000e{gN\u001a\t\u0004\u0005\u0006]\u0014bAA=\u0007\n91+\u0015'D_:4\u0017aC5t'Bd\u0017\u000e^1cY\u0016$rA\\A@\u0003\u0003\u000b\u0019\tC\u0003}\u0015\u0001\u0007Q\u0010C\u0004\u0002\u001a)\u0001\r!a\u0007\t\u000f\u0005\u0015%\u00021\u0001\u0002\b\u0006!\u0001/\u0019;i!\u0011\ti%!#\n\t\u0005-\u0015q\n\u0002\u0005!\u0006$\b.A\btKR,\b\u000fS1e_>\u00048i\u001c8g)!\t\t*a&\u0002(\u0006%\u0006c\u0001\u001a\u0002\u0014&\u0019\u0011QS\u001a\u0003\tUs\u0017\u000e\u001e\u0005\b\u00033[\u0001\u0019AAN\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0005\u0003;\u000b\u0019+\u0004\u0002\u0002 *!\u0011\u0011UA\b\u0003\u0011\u0019wN\u001c4\n\t\u0005\u0015\u0016q\u0014\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005M4\u00021\u0001\u0002v!9\u00111N\u0006A\u0002\u0005\u0015\u0012A\b2vS2$'+Z1eKJ<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]Z\u000bG.^3t)A\ty+!4\u0002P\u0006E\u00171[Ak\u0003C\f\u0019\u000fE\u00043\u0003c\u000b),a/\n\u0007\u0005M6GA\u0005Gk:\u001cG/[8ocA\u0019\u0001(a.\n\u0007\u0005e6EA\bQCJ$\u0018\u000e^5p]\u0016$g)\u001b7f!\u0015i\u0015QXAa\u0013\r\tyl\u0016\u0002\t\u0013R,'/\u0019;peB!\u00111YAe\u001b\t\t)MC\u0002\u0002H\u001e\n\u0001bY1uC2L8\u000f^\u0005\u0005\u0003\u0017\f)MA\u0006J]R,'O\\1m%><\b\"\u0002?\r\u0001\u0004i\bbBA\u0012\u0019\u0001\u0007\u0011Q\u0005\u0005\b\u0003_b\u0001\u0019AA\u0013\u0011\u001d\tY\u0007\u0004a\u0001\u0003KAq!a6\r\u0001\u0004\tI.A\u0004gS2$XM]:\u0011\u000b5\u000b9%a7\u0011\u0007q\ni.C\u0002\u0002`v\u0012aAR5mi\u0016\u0014\bbBA\r\u0019\u0001\u0007\u00111\u0004\u0005\b\u00033c\u0001\u0019AAN\u0003]\u0011W/\u001b7e-\u0016\u001cGo\u001c:ju\u0016$\u0017\n^3sCR|'\u000f\u0006\u000e\u0002<\u0006%\u0018\u0011 B\u0005\u0005\u001b\u0011yA!\n\u0003>\t\u0005#Q\tB%\u0005\u001b\u00129\u0006C\u0004\u0002l6\u0001\r!!<\u0002)!\fGm\\8q\u0003R$X-\u001c9u\u0007>tG/\u001a=u!\u0011\ty/!>\u000e\u0005\u0005E(\u0002BAz\u0003\u0017\tA\u0001^1tW&!\u0011q_Ay\u0005Y!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;J[Bd\u0007bBA~\u001b\u0001\u0007\u0011Q`\u0001\u0006gBd\u0017\u000e\u001e\t\u0005\u0003\u007f\u0014)!\u0004\u0002\u0003\u0002)!!1AA\b\u0003\u0019i\u0017\r\u001d:fI&!!q\u0001B\u0001\u0005%1\u0015\u000e\\3Ta2LG\u000fC\u0004\u0003\f5\u0001\r!!1\u0002\u001fA\f'\u000f^5uS>tg+\u00197vKNDq!a\u001c\u000e\u0001\u0004\t)\u0003C\u0004\u0003\u00125\u0001\rAa\u0005\u0002\u0013\r|gN^3siRS\b#\u0002\u001a\u00028\tU\u0001\u0003\u0002B\f\u0005Ci!A!\u0007\u000b\t\tm!QD\u0001\u0005i&lWM\u0003\u0002\u0003 \u0005!!.\u0019<b\u0013\u0011\u0011\u0019C!\u0007\u0003\ri{g.Z%e\u0011\u001d\u00119#\u0004a\u0001\u0005S\t!\u0003Z1uKRLW.\u001a*fE\u0006\u001cXm\u00159fGB!!1\u0006B\u001c\u001d\u0011\u0011iCa\r\u000e\u0005\t=\"\u0002\u0002B\u0019\u0003\u000b\fA!\u001e;jY&!!Q\u0007B\u0018\u00039\u0011VMY1tK\u0012\u000bG/\u001a+j[\u0016LAA!\u000f\u0003<\tQ!+\u001a2bg\u0016\u001c\u0006/Z2\u000b\t\tU\"q\u0006\u0005\b\u0005\u007fi\u0001\u0019\u0001B\u0015\u0003=Ig\u000e^\u001d7%\u0016\u0014\u0017m]3Ta\u0016\u001c\u0007B\u0002B\"\u001b\u0001\u0007a.A\rf]\u0006\u0014G.Z(gM\"+\u0017\r]\"pYVlgNV3di>\u0014\bB\u0002B$\u001b\u0001\u0007a.\u0001\bsKR,(O\\5oO\n\u000bGo\u00195\t\r\t-S\u00021\u0001j\u0003%\u0011\u0017\r^2i'&TX\rC\u0004\u0003P5\u0001\rA!\u0015\u0002\u0019=\u0004XM\\3e\r>|G/\u001a:\u0011\u0007m\u0013\u0019&C\u0002\u0003V\u0005\u00121c\u00149f]\u0016$\u0007+\u0019:rk\u0016$hi\\8uKJDqA!\u0017\u000e\u0001\u0004\u0011Y&\u0001\ftQ>,H\u000eZ\"m_N,\u0017J\u001c9viN#(/Z1n!\u0011\u0011iF!\u001b\u000e\u0005\t}#\u0002\u0002B1\u0005G\na!\u0019;p[&\u001c'\u0002\u0002B3\u0005O\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\u0011\tD!\b\n\t\t-$q\f\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002+\t,\u0018\u000e\u001c3S_^\u0014\u0015m]3e\u0013R,'/\u0019;peR1\"\u0011\u000fBB\u0005\u000b\u00139I!#\u0003\f\n5%q\u0012BI\u0005'\u0013YK\u0005\u0004\u0003t\u0005m&q\u000f\u0004\u0007\u0005k\u0002\u0001A!\u001d\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\t\te$qP\u0007\u0003\u0005wRAA! \u0003\u001e\u0005\u0011\u0011n\\\u0005\u0005\u0005\u0003\u0013YHA\u0005DY>\u001cX-\u00192mK\"9\u00111\u001e\bA\u0002\u00055\bbBA~\u001d\u0001\u0007\u0011Q \u0005\b\u0005\u0017q\u0001\u0019AAa\u0011\u001d\tyG\u0004a\u0001\u0003KAqA!\u0005\u000f\u0001\u0004\u0011\u0019\u0002C\u0004\u0003(9\u0001\rA!\u000b\t\u000f\t}b\u00021\u0001\u0003*!9\u00111\u000e\bA\u0002\u0005\u0015\u0002b\u0002BK\u001d\u0001\u0007!qS\u0001\u0007aV\u001c\b.\u001a3\u0011\u000bI\n9D!'\u0011\t\tm%qU\u0007\u0003\u0005;SAAa(\u0003\"\u0006I\u0001O]3eS\u000e\fG/\u001a\u0006\u0005\u0005G\u0013)+A\u0004gS2$XM\u001d\u001a\u000b\u0005\tZ\u0013\u0002\u0002BU\u0005;\u0013qBR5mi\u0016\u0014\bK]3eS\u000e\fG/\u001a\u0005\u0007\u0005[s\u0001\u0019\u00018\u0002%\u0015t\u0017M\u00197f%\u0016\u001cwN\u001d3GS2$XM]\u0001\u0010gV\u0004\bo\u001c:u\t\u0006$\u0018\rV=qKR\u0019aNa-\t\u000f\tUv\u00021\u0001\u00038\u0006AA-\u0019;b)f\u0004X\r\u0005\u0003\u0002(\te\u0016\u0002\u0002B^\u0003S\u0011\u0001\u0002R1uCRK\b/Z\u0001\u0015[\u0016$\u0018\rZ1uCN\u001b\u0007.Z7b\r&,G\u000eZ:\u0016\u0005\t\u0005\u0007#B'\u0002H\t\r\u0007\u0003BA\u0014\u0005\u000bLAAa2\u0002*\tY1\u000b\u001e:vGR4\u0015.\u001a7e\u0003E\u0001\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u00037J\u0019RAE\u0019H\u0005\u001f\u0004BA!\u001f\u0003R&\u0019aKa\u001f\u0015\u0005\t-\u0017!\u0003*P/~Ke\nR#Y+\t\u0011I\u000e\u0005\u0003\u0003\\\n\u0005XB\u0001Bo\u0015\u0011\u0011yN!\b\u0002\t1\fgnZ\u0005\u0004I\nu\u0017A\u0003*P/~Ke\nR#YA\u0005y\"kT,`\u0013:#U\tW0U\u000b6\u0003vJU!S3~\u001bu\nT+N\u001d~s\u0015)T#\u0002AI{ukX%O\t\u0016Cv\fV#N!>\u0013\u0016IU-`\u0007>cU+\u0014(`\u001d\u0006kU\tI\u0001\u0010%>;v,\u0013(E\u000bb{f)S#M\tV\u0011!1Y\u0001\u0011%>;v,\u0013(E\u000bb{f)S#M\t\u0002\n!B]3bIN\u001b\u0007.Z7b)\u0019\t)Da=\u0004\u0004!9!Q\u001f\u000eA\u0002\t]\u0018a\u00024p_R,'o\u001d\t\u0006\u001b\u0006\u001d#\u0011 \t\u0005\u0005w\u0014y0\u0004\u0002\u0003~*!\u0011\u0011\u0003BS\u0013\u0011\u0019\tA!@\u0003\r\u0019{w\u000e^3s\u0011\u0015a(\u00041\u0001~\u0003q\u0011X-\u00193QCJ\fX/\u001a;G_>$XM]:J]B\u000b'/\u00197mK2$\u0002Ba>\u0004\n\r-1q\u0002\u0005\b\u0003C[\u0002\u0019AAN\u0011\u001d\u0019ia\u0007a\u0001\u0003\u000b\n\u0011\u0002]1si\u001aKG.Z:\t\r\rE1\u00041\u0001o\u0003IIwM\\8sK\u000e{'O];qi\u001aKG.Z:\u0002-5,'oZ3TG\",W.Y:J]B\u000b'/\u00197mK2$\u0002\"!\u000e\u0004\u0018\re1Q\u0004\u0005\b\u0003\u007fa\u0002\u0019AA\u000e\u0011\u001d\u0019Y\u0002\ba\u0001\u0003\u000b\nABZ5mKN$v\u000eV8vG\"DQ\u0001 \u000fA\u0002u\fAC]3bIN\u001b\u0007.Z7b\rJ|WNR8pi\u0016\u0014HCBA\u0013\u0007G\u00199\u0003C\u0004\u0004&u\u0001\rA!?\u0002\r\u0019|w\u000e^3s\u0011\u001d\u0019I#\ba\u0001\u0007W\t\u0011bY8om\u0016\u0014H/\u001a:\u0011\u0007m\u001bi#C\u0002\u00040\u0005\u0012Q\u0004U1scV,G\u000fV8Ta\u0006\u00148nU2iK6\f7i\u001c8wKJ$XM]\u0001\u0018I\u0016\u001cXM]5bY&TXmU2iK6\f7\u000b\u001e:j]\u001e$B!!\u000e\u00046!11q\u0007\u0010A\u0002y\u000bAb]2iK6\f7\u000b\u001e:j]\u001e\fAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"a!\u0010\u0011\t\tm7qH\u0005\u0005\u0007\u0003\u0012iN\u0001\u0004PE*,7\r\u001e")
public class ParquetFileFormat
implements FileFormat,
DataSourceRegister,
SessionStateHelper,
Logging,
Serializable {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static StructType readSchemaFromFooter(Footer footer, ParquetToSparkSchemaConverter converter) {
        return ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, converter);
    }

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> filesToTouch, SparkSession sparkSession) {
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(parameters, filesToTouch, sparkSession);
    }

    public static StructField ROW_INDEX_FIELD() {
        return ParquetFileFormat$.MODULE$.ROW_INDEX_FIELD();
    }

    public static String ROW_INDEX_TEMPORARY_COLUMN_NAME() {
        return ParquetFileFormat$.MODULE$.ROW_INDEX_TEMPORARY_COLUMN_NAME();
    }

    public static String ROW_INDEX() {
        return ParquetFileFormat$.MODULE$.ROW_INDEX();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public SessionState sessionState(SparkSession sparkSession) {
        return SessionStateHelper.sessionState$(this, sparkSession);
    }

    @Override
    public SparkConf getSparkConf(SparkSession sparkSession) {
        return SessionStateHelper.getSparkConf$(this, sparkSession);
    }

    @Override
    public SQLConf getSqlConf(SparkSession sparkSession) {
        return SessionStateHelper.getSqlConf$(this, sparkSession);
    }

    @Override
    public Configuration getHadoopConf(SparkSession sparkSession, scala.collection.immutable.Map<String, String> options) {
        return SessionStateHelper.getHadoopConf$(this, sparkSession, options);
    }

    @Override
    public Configuration getHadoopConf(SparkSession sparkSession) {
        return SessionStateHelper.getHadoopConf$(this, sparkSession);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public AttributeReference createFileMetadataCol() {
        return FileFormat.createFileMetadataCol$(this);
    }

    @Override
    public boolean supportReadDataType(DataType dataType) {
        return FileFormat.supportReadDataType$(this, dataType);
    }

    @Override
    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$(this, name);
    }

    @Override
    public boolean allowDuplicatedColumnNames() {
        return FileFormat.allowDuplicatedColumnNames$(this);
    }

    @Override
    public scala.collection.immutable.Map<String, Function1<PartitionedFile, Object>> fileConstantMetadataExtractors() {
        return FileFormat.fileConstantMetadataExtractors$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String shortName() {
        return "parquet";
    }

    public String toString() {
        return "Parquet";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ParquetFileFormat;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        SQLConf sqlConf = this.getSqlConf(sparkSession);
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        return ParquetUtils$.MODULE$.prepareWrite(sqlConf, job, dataSchema, parquetOptions);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return ParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        return ParquetUtils$.MODULE$.isBatchReadSupportedForSchema(this.getSqlConf(sparkSession), schema);
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return Option$.MODULE$.apply(((IterableOps)package$.MODULE$.Seq().fill(requiredSchema.fields().length, (Function0 & Serializable)() -> {
            if (!sqlConf.offHeapColumnVectorEnabled()) {
                return OnHeapColumnVector.class.getName();
            }
            return OffHeapColumnVector.class.getName();
        })).$plus$plus((IterableOnce)package$.MODULE$.Seq().fill(partitionSchema.fields().length, (Function0 & Serializable)() -> ConstantColumnVector.class.getName())));
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, scala.collection.immutable.Map<String, String> options, Path path) {
        return true;
    }

    private void setupHadoopConf(Configuration hadoopConf, SQLConf sqlConf, StructType requiredSchema) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sqlConf.sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sqlConf.nestedSchemaPruningEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sqlConf.caseSensitiveAnalysis());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sqlConf.isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sqlConf.isParquetINT96AsTimestamp());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key(), sqlConf.parquetInferTimestampNTZEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), sqlConf.legacyParquetNanosAsLong());
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        boolean returningBatch;
        String int96RebaseModeInRead;
        String datetimeRebaseModeInRead;
        boolean isCaseSensitive;
        int pushDownInFilterThreshold;
        boolean pushDownStringPredicate;
        boolean pushDownDecimal;
        boolean pushDownTimestamp;
        boolean pushDownDate;
        boolean enableParquetFilterPushDown;
        int capacity;
        boolean timestampConversion;
        boolean enableRecordFilter;
        boolean enableVectorizedReader;
        boolean enableOffHeapColumnVector;
        Broadcast broadcastedHadoopConf;
        block0: {
            SQLConf sqlConf = this.getSqlConf(sparkSession);
            this.setupHadoopConf(hadoopConf, sqlConf, requiredSchema);
            broadcastedHadoopConf = SerializableConfiguration$.MODULE$.broadcast(sparkSession.sparkContext(), hadoopConf);
            StructType resultSchema = new StructType((StructField[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()), (Object)requiredSchema.fields(), ClassTag$.MODULE$.apply(StructField.class)));
            enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
            enableVectorizedReader = ParquetUtils$.MODULE$.isBatchReadSupportedForSchema(sqlConf, resultSchema);
            enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
            timestampConversion = sqlConf.isParquetINT96TimestampConversion();
            capacity = sqlConf.parquetVectorizedReaderBatchSize();
            enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
            pushDownDate = sqlConf.parquetFilterPushDownDate();
            pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
            pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
            pushDownStringPredicate = sqlConf.parquetFilterPushDownStringPredicate();
            pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
            isCaseSensitive = sqlConf.caseSensitiveAnalysis();
            ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
            datetimeRebaseModeInRead = parquetOptions.datetimeRebaseModeInRead();
            int96RebaseModeInRead = parquetOptions.int96RebaseModeInRead();
            boolean bl = returningBatch = sqlConf.parquetVectorizedReaderEnabled() && ((String)options.getOrElse((Object)FileFormat$.MODULE$.OPTION_RETURNING_BATCH(), (Function0 & Serializable)() -> {
                throw new IllegalArgumentException("OPTION_RETURNING_BATCH should always be set for ParquetFileFormat. To workaround this issue, set " + SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key() + "=false.");
            })).equals("true");
            if (!returningBatch) break block0;
            Predef$.MODULE$.assert(this.supportBatch(sparkSession, resultSchema));
        }
        return (Function1 & Serializable)file -> {
            Iterator<InternalRow> iterator;
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            FileSplit split = new FileSplit(file.toPath(), file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            OpenedParquetFooter openedFooter = ParquetFooterReader.openFileAndReadFooter(sharedConf, file, enableVectorizedReader);
            Predef$.MODULE$.assert(openedFooter.inputStreamOpt().isPresent() == enableVectorizedReader);
            AtomicBoolean shouldCloseInputStream = new AtomicBoolean(openedFooter.inputStreamOpt().isPresent());
            try {
                None$ none$;
                FileMetaData footerFileMetaData = openedFooter.footer().getFileMetaData();
                Map map = footerFileMetaData.getKeyValueMetaData();
                RebaseDateTime.RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map.get(x$1), datetimeRebaseModeInRead);
                Map map2 = footerFileMetaData.getKeyValueMetaData();
                RebaseDateTime.RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1<String, String>)(Function1 & Serializable)x$1 -> (String)map2.get(x$1), int96RebaseModeInRead);
                if (enableParquetFilterPushDown) {
                    MessageType parquetSchema = footerFileMetaData.getSchema();
                    ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringPredicate, pushDownInFilterThreshold, isCaseSensitive, datetimeRebaseSpec);
                    none$ = ((IterableOnceOps)filters.flatMap((Function1 & Serializable)predicate -> parquetFilters.createFilter((Filter)predicate))).reduceOption((Function2 & Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
                } else {
                    none$ = None$.MODULE$;
                }
                None$ pushed = none$;
                None$ convertTz = timestampConversion && !ParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
                pushed.foreach((Function1 & Serializable)x$1 -> {
                    ParquetFileFormat.$anonfun$buildReaderWithPartitionValues$7(hadoopAttemptContext, x$1);
                    return BoxedUnit.UNIT;
                });
                if (enableVectorizedReader) {
                    iterator = this.buildVectorizedIterator(hadoopAttemptContext, split, file.partitionValues(), partitionSchema, (Option<ZoneId>)convertTz, datetimeRebaseSpec, int96RebaseSpec, enableOffHeapColumnVector, returningBatch, capacity, openedFooter, shouldCloseInputStream);
                } else {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Falling back to parquet-mr");
                    iterator = this.buildRowBasedIterator(hadoopAttemptContext, split, file.partitionValues(), partitionSchema, (Option<ZoneId>)convertTz, datetimeRebaseSpec, int96RebaseSpec, requiredSchema, (Option<FilterPredicate>)pushed, enableRecordFilter);
                }
            }
            finally {
                if (shouldCloseInputStream.get()) {
                    openedFooter.inputStreamOpt().ifPresent(closeable -> Utils$.MODULE$.closeQuietly(closeable));
                }
            }
            return iterator;
        };
    }

    private Iterator<InternalRow> buildVectorizedIterator(TaskAttemptContextImpl hadoopAttemptContext, FileSplit split, InternalRow partitionValues, StructType partitionSchema, Option<ZoneId> convertTz, RebaseDateTime.RebaseSpec datetimeRebaseSpec, RebaseDateTime.RebaseSpec int96RebaseSpec, boolean enableOffHeapColumnVector, boolean returningBatch, int batchSize, OpenedParquetFooter openedFooter, AtomicBoolean shouldCloseInputStream) {
        RecordReaderIterator<Object> recordReaderIterator;
        Predef$.MODULE$.assert(openedFooter.inputStreamOpt().isPresent());
        VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader((ZoneId)convertTz.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), datetimeRebaseSpec.mode().toString(), datetimeRebaseSpec.timeZone(), int96RebaseSpec.mode().toString(), int96RebaseSpec.timeZone(), enableOffHeapColumnVector && TaskContext$.MODULE$.get() != null, batchSize);
        RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(vectorizedReader);
        try {
            vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext, (Option<HadoopInputFile>)new Some((Object)openedFooter.inputFile()), (Option<SeekableInputStream>)new Some((Object)openedFooter.inputStream()), (Option<ParquetMetadata>)new Some((Object)openedFooter.footer()));
            shouldCloseInputStream.set(false);
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Appending " + partitionSchema + " " + partitionValues);
            vectorizedReader.initBatch(partitionSchema, partitionValues);
            if (returningBatch) {
                vectorizedReader.enableReturningBatches();
            }
            recordReaderIterator = iter;
        }
        catch (Throwable e) {
            iter.close();
            throw e;
        }
        return recordReaderIterator;
    }

    private Iterator<InternalRow> buildRowBasedIterator(TaskAttemptContextImpl hadoopAttemptContext, FileSplit split, InternalRow partitionValues, StructType partitionSchema, Option<ZoneId> convertTz, RebaseDateTime.RebaseSpec datetimeRebaseSpec, RebaseDateTime.RebaseSpec int96RebaseSpec, StructType requiredSchema, Option<FilterPredicate> pushed, boolean enableRecordFilter) {
        Iterator iterator;
        ParquetRecordReader parquetRecordReader;
        ParquetReadSupport readSupport = new ParquetReadSupport(convertTz, false, datetimeRebaseSpec, int96RebaseSpec);
        if (pushed.isDefined() && enableRecordFilter) {
            FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
            parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
        } else {
            parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
        }
        ParquetRecordReader reader = parquetRecordReader;
        RecordReader<Void, InternalRow> readerWithRowIndexes = ParquetRowIndexUtil$.MODULE$.addRowIndexToRecordReaderIfNeeded((ParquetRecordReader<InternalRow>)reader, requiredSchema);
        RecordReaderIterator<InternalRow> iter = new RecordReaderIterator<InternalRow>(readerWithRowIndexes);
        try {
            readerWithRowIndexes.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
            Seq fullSchema = (Seq)DataTypeUtils$.MODULE$.toAttributes(requiredSchema).$plus$plus((IterableOnce)DataTypeUtils$.MODULE$.toAttributes(partitionSchema));
            UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
            if (partitionSchema.length() == 0) {
                iterator = iter.map(unsafeProjection);
            } else {
                JoinedRow joinedRow = new JoinedRow();
                iterator = iter.map((Function1 & Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, partitionValues)));
            }
        }
        catch (Throwable e) {
            iter.close();
            throw e;
        }
        return iterator;
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType ? true : dataType2 instanceof NullType) {
            return true;
        }
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            return structType.forall((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            return this.supportDataType(elementType);
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            return this.supportDataType(keyType) && this.supportDataType(valueType);
        }
        if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            return this.supportDataType(userDefinedType.sqlType());
        }
        return false;
    }

    @Override
    public Seq<StructField> metadataSchemaFields() {
        return (Seq)FileFormat.metadataSchemaFields$(this).$colon$plus((Object)ParquetFileFormat$.MODULE$.ROW_INDEX_FIELD());
    }

    private static final boolean isCreatedByParquetMr$1(FileMetaData footerFileMetaData$1) {
        return footerFileMetaData$1.getCreatedBy().startsWith("parquet-mr");
    }

    public static final /* synthetic */ void $anonfun$buildReaderWithPartitionValues$7(TaskAttemptContextImpl hadoopAttemptContext$1, FilterPredicate x$1) {
        ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext$1.getConfiguration(), (FilterPredicate)x$1);
    }

    public ParquetFileFormat() {
        FileFormat.$init$(this);
        SessionStateHelper.$init$(this);
        Logging.$init$((Logging)this);
    }
}

