/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.operators.stateful.StatefulOperatorsUtils$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.StateStoreColumnFamilySchemaUtils$;
import org.apache.spark.sql.execution.streaming.runtime.StreamingCheckpointConstants$;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StatePartitionWriterColumnFamilyInfo;
import org.apache.spark.sql.execution.streaming.state.StateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema$;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.MapView;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001\u0002\u000e\u001c\u0001)B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!y\u0005A!A!\u0002\u0013\u0001\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011E\u0003!\u0011!Q\u0001\nIC\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\t9\u0002\u0011\t\u0011)A\u0005\t\"AQ\f\u0001B\u0001B\u0003%a\f\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003f\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u0015I\b\u0001\"\u0003{\u0011%\t\t\u0001\u0001b\u0001\n\u0013\t\u0019\u0001\u0003\u0005\u0002\f\u0001\u0001\u000b\u0011BA\u0003\u0011%\ti\u0001\u0001b\u0001\n\u0013\ty\u0001C\u0004\u0002\u0012\u0001\u0001\u000b\u0011B>\t\u0013\u0005M\u0001A1A\u0005\n\u0005U\u0001\u0002CA\u0012\u0001\u0001\u0006I!a\u0006\t\u0013\u0005\u0015\u0002A1A\u0005\n\u0005U\u0001\u0002CA\u0014\u0001\u0001\u0006I!a\u0006\t\u0015\u0005%\u0002\u0001#b\u0001\n#\tY\u0003\u0003\u0006\u00024\u0001A)\u0019!C\u0005\u0003kAq!!\u0010\u0001\t\u0003\ty\u0004C\u0004\u0002j\u0001!I!a\u001b\u0003KM#\u0018\r^3QCJ$\u0018\u000e^5p]\u0006cGnQ8mk6tg)Y7jY&,7o\u0016:ji\u0016\u0014(B\u0001\u000f\u001e\u0003\u0015\u0019H/\u0019;f\u0015\tqr$A\u0005tiJ,\u0017-\\5oO*\u0011\u0001%I\u0001\nKb,7-\u001e;j_:T!AI\u0012\u0002\u0007M\fHN\u0003\u0002%K\u0005)1\u000f]1sW*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0016\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\r\u0005s\u0017PU3g\u0003%\u0019Ho\u001c:f\u0007>tg\r\u0005\u00024i5\t1$\u0003\u000267\tq1\u000b^1uKN#xN]3D_:4\u0017A\u00035bI>|\u0007oQ8oMB\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\u0005G>tgM\u0003\u0002=K\u00051\u0001.\u00193p_BL!AP\u001d\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0011\u00051\n\u0015B\u0001\".\u0005\rIe\u000e^\u0001\u0011i\u0006\u0014x-\u001a;Da2{7-\u0019;j_:\u0004\"!\u0012'\u000f\u0005\u0019S\u0005CA$.\u001b\u0005A%BA%*\u0003\u0019a$o\\8u}%\u00111*L\u0001\u0007!J,G-\u001a4\n\u00055s%AB*ue&twM\u0003\u0002L[\u0005Qq\u000e]3sCR|'/\u00133\u0002\u0013M$xN]3OC6,\u0017AD2veJ,g\u000e\u001e\"bi\u000eD\u0017\n\u001a\t\u0003YMK!\u0001V\u0017\u0003\t1{gnZ\u0001\u0019G>dg)Y7jYf$vn\u0016:ji\u0016\u0014\u0018J\u001c4p\u001b\u0006\u0004\b\u0003B#X\tfK!\u0001\u0017(\u0003\u00075\u000b\u0007\u000f\u0005\u000245&\u00111l\u0007\u0002%'R\fG/\u001a)beRLG/[8o/JLG/\u001a:D_2,XN\u001c$b[&d\u00170\u00138g_\u0006aq\u000e]3sCR|'OT1nK\u0006\t2o\u00195f[\u0006\u0004&o\u001c<jI\u0016\u0014x\n\u001d;\u0011\u00071z\u0016-\u0003\u0002a[\t1q\n\u001d;j_:\u0004\"a\r2\n\u0005\r\\\"aE*uCR,7k\u00195f[\u0006\u0004&o\u001c<jI\u0016\u0014\u0018aB:rY\u000e{gN\u001a\t\u0003M&l\u0011a\u001a\u0006\u0003Q\u0006\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003U\u001e\u0014qaU)M\u0007>tg-\u0001\u0004=S:LGO\u0010\u000b\r[:|\u0007/\u001d:tiV4x\u000f\u001f\t\u0003g\u0001AQ!\r\u0007A\u0002IBQA\u000e\u0007A\u0002]BQa\u0010\u0007A\u0002\u0001CQa\u0011\u0007A\u0002\u0011CQa\u0014\u0007A\u0002\u0001CQ\u0001\u0015\u0007A\u0002\u0011CQ!\u0015\u0007A\u0002ICQ!\u0016\u0007A\u0002YCQ\u0001\u0018\u0007A\u0002\u0011CQ!\u0018\u0007A\u0002yCQ\u0001\u001a\u0007A\u0002\u0015\f\u0001#[:K_&tgkM(qKJ\fGo\u001c:\u0015\u0007mtx\u0010\u0005\u0002-y&\u0011Q0\f\u0002\b\u0005>|G.Z1o\u0011\u0015aV\u00021\u0001E\u0011\u0015!W\u00021\u0001f\u00035!WMZ1vYR\u001c6\r[3nCV\u0011\u0011Q\u0001\t\u0004g\u0005\u001d\u0011bAA\u00057\tI2\u000b^1uKN#xN]3D_24\u0015-\\5msN\u001b\u0007.Z7b\u00039!WMZ1vYR\u001c6\r[3nC\u0002\n\u0011#^:f\u0007>dW/\u001c8GC6LG.[3t+\u0005Y\u0018AE;tK\u000e{G.^7o\r\u0006l\u0017\u000e\\5fg\u0002\nQdY8mk6tg)Y7jYf$vnS3z'\u000eDW-\\1MK:l\u0015\r]\u000b\u0003\u0003/\u0001b!!\u0007\u0002 \u0011\u0003UBAA\u000e\u0015\r\ti\"L\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0011\u00037\u0011q!T1q-&,w/\u0001\u0010d_2,XN\u001c$b[&d\u0017\u0010V8LKf\u001c6\r[3nC2+g.T1qA\u0005y2m\u001c7v[:4\u0015-\\5msR{g+\u00197vKN\u001b\u0007.Z7b\u0019\u0016tW*\u00199\u0002A\r|G.^7o\r\u0006l\u0017\u000e\\=U_Z\u000bG.^3TG\",W.\u0019'f]6\u000b\u0007\u000fI\u0001\taJ|g/\u001b3feV\u0011\u0011Q\u0006\t\u0004g\u0005=\u0012bAA\u00197\t\u00112\u000b^1uKN#xN]3Qe>4\u0018\u000eZ3s\u0003)\u0019H/\u0019;f'R|'/Z\u000b\u0003\u0003o\u00012aMA\u001d\u0013\r\tYd\u0007\u0002\u000b'R\fG/Z*u_J,\u0017!B<sSR,G\u0003BA!\u0003\u000f\u00022\u0001LA\"\u0013\r\t)%\f\u0002\u0005+:LG\u000fC\u0004\u0002Ja\u0001\r!a\u0013\u0002\tI|wo\u001d\t\u0007\u0003\u001b\n9&!\u0018\u000f\t\u0005=\u00131\u000b\b\u0004\u000f\u0006E\u0013\"\u0001\u0018\n\u0007\u0005US&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00131\f\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011QK\u0017\u0011\t\u0005}\u0013QM\u0007\u0003\u0003CR1!a\u0019\"\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA4\u0003C\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006AqO]5uKJ{w\u000f\u0006\u0003\u0002B\u00055\u0004bBA83\u0001\u0007\u0011QL\u0001\u0007e\u0016\u001cwN\u001d3")
public class StatePartitionAllColumnFamiliesWriter {
    private StateStoreProvider provider;
    private StateStore stateStore;
    private final StateStoreConf storeConf;
    private final Configuration hadoopConf;
    private final int partitionId;
    private final String targetCpLocation;
    private final int operatorId;
    private final String storeName;
    private final long currentBatchId;
    private final Map<String, StatePartitionWriterColumnFamilyInfo> colFamilyToWriterInfoMap;
    private final String operatorName;
    private final Option<StateSchemaProvider> schemaProviderOpt;
    private final StateStoreColFamilySchema defaultSchema;
    private final boolean useColumnFamilies;
    private final MapView<String, Object> columnFamilyToKeySchemaLenMap;
    private final MapView<String, Object> columnFamilyToValueSchemaLenMap;
    private volatile byte bitmap$0;

    private boolean isJoinV3Operator(String operatorName, SQLConf sqlConf) {
        String string = operatorName;
        String string2 = StatefulOperatorsUtils$.MODULE$.SYMMETRIC_HASH_JOIN_EXEC_OP_NAME();
        return !(string != null ? !string.equals(string2) : string2 != null) && BoxesRunTime.unboxToInt((Object)sqlConf.getConf(SQLConf$.MODULE$.STREAMING_JOIN_STATE_FORMAT_VERSION())) == 3;
    }

    private StateStoreColFamilySchema defaultSchema() {
        return this.defaultSchema;
    }

    private boolean useColumnFamilies() {
        return this.useColumnFamilies;
    }

    private MapView<String, Object> columnFamilyToKeySchemaLenMap() {
        return this.columnFamilyToKeySchemaLenMap;
    }

    private MapView<String, Object> columnFamilyToValueSchemaLenMap() {
        return this.columnFamilyToValueSchemaLenMap;
    }

    private StateStoreProvider provider$lzycompute() {
        StatePartitionAllColumnFamiliesWriter statePartitionAllColumnFamiliesWriter = this;
        synchronized (statePartitionAllColumnFamiliesWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                StateStoreProvider provider;
                String stateCheckpointLocation = new Path(this.targetCpLocation, StreamingCheckpointConstants$.MODULE$.DIR_NAME_STATE()).toString();
                StateStoreId stateStoreId = new StateStoreId(stateCheckpointLocation, this.operatorId, this.partitionId, this.storeName);
                StateStoreProviderId stateStoreProviderId = new StateStoreProviderId(stateStoreId, UUID.randomUUID());
                this.provider = provider = StateStoreProvider$.MODULE$.createAndInit(stateStoreProviderId, this.defaultSchema().keySchema(), this.defaultSchema().valueSchema(), (KeyStateEncoderSpec)this.defaultSchema().keyStateEncoderSpec().get(), this.useColumnFamilies(), this.storeConf, this.hadoopConf, false, this.schemaProviderOpt);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.provider;
    }

    public StateStoreProvider provider() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.provider$lzycompute();
        }
        return this.provider;
    }

    /*
     * WARNING - void declaration
     */
    private StateStore stateStore$lzycompute() {
        StatePartitionAllColumnFamiliesWriter statePartitionAllColumnFamiliesWriter = this;
        synchronized (statePartitionAllColumnFamiliesWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_6;
                long x$1 = this.currentBatchId;
                None$ x$2 = None$.MODULE$;
                boolean x$3 = true;
                boolean x$4 = this.provider().getStore$default$3();
                StateStore store = this.provider().getStore(x$1, (Option<String>)x$2, x$4, true);
                if (this.useColumnFamilies()) {
                    this.colFamilyToWriterInfoMap.foreach((Function1 & Serializable)pair -> {
                        StatePartitionAllColumnFamiliesWriter.$anonfun$stateStore$1(store, pair);
                        return BoxedUnit.UNIT;
                    });
                }
                this.stateStore = var2_6;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.stateStore;
    }

    private StateStore stateStore() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.stateStore$lzycompute();
        }
        return this.stateStore;
    }

    public void write(Iterator<InternalRow> rows) {
        try {
            rows.foreach((Function1 & Serializable)row -> {
                this.writeRow(row);
                return BoxedUnit.UNIT;
            });
            this.stateStore().commit();
        }
        finally {
            if (!this.stateStore().hasCommitted()) {
                this.stateStore().abort();
            }
        }
    }

    private void writeRow(InternalRow record) {
        Predef$.MODULE$.assert(record.numFields() == 4, (Function0 & Serializable)() -> "Invalid record schema: expected 4 fields (partition_key, key_bytes, value_bytes, column_family_name), got " + record.numFields());
        byte[] keyBytes = record.getBinary(1);
        byte[] valueBytes = record.getBinary(2);
        String colFamilyName = record.getString(3);
        UnsafeRow keyRow = new UnsafeRow(BoxesRunTime.unboxToInt((Object)this.columnFamilyToKeySchemaLenMap().apply((Object)colFamilyName)));
        keyRow.pointTo(keyBytes, keyBytes.length);
        UnsafeRow valueRow = new UnsafeRow(BoxesRunTime.unboxToInt((Object)this.columnFamilyToValueSchemaLenMap().apply((Object)colFamilyName)));
        valueRow.pointTo(valueBytes, valueBytes.length);
        if (((StatePartitionWriterColumnFamilyInfo)this.colFamilyToWriterInfoMap.apply((Object)colFamilyName)).useMultipleValuesPerKey() && this.stateStore().keyExists(keyRow, colFamilyName)) {
            this.stateStore().merge(keyRow, valueRow, colFamilyName);
            return;
        }
        this.stateStore().put(keyRow, valueRow, colFamilyName);
    }

    public static final /* synthetic */ int $anonfun$columnFamilyToKeySchemaLenMap$1(StatePartitionWriterColumnFamilyInfo x$1) {
        return x$1.schema().keySchema().length();
    }

    public static final /* synthetic */ int $anonfun$columnFamilyToValueSchemaLenMap$1(StatePartitionWriterColumnFamilyInfo x$2) {
        return x$2.schema().valueSchema().length();
    }

    public static final /* synthetic */ void $anonfun$stateStore$1(StateStore store$1, Tuple2 pair) {
        String colFamilyName = (String)pair._1();
        StateStoreColFamilySchema cfSchema = ((StatePartitionWriterColumnFamilyInfo)pair._2()).schema();
        String string = colFamilyName;
        String string2 = StateStore$.MODULE$.DEFAULT_COL_FAMILY_NAME();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return;
        }
        Predef$.MODULE$.require(cfSchema.keyStateEncoderSpec().isDefined(), (Function0 & Serializable)() -> "keyStateEncoderSpec must be defined for column family " + cfSchema.colFamilyName());
        boolean isInternal = StateStoreColumnFamilySchemaUtils$.MODULE$.isInternalColFamily(colFamilyName);
        store$1.createColFamilyIfAbsent(colFamilyName, cfSchema.keySchema(), cfSchema.valueSchema(), (KeyStateEncoderSpec)cfSchema.keyStateEncoderSpec().get(), ((StatePartitionWriterColumnFamilyInfo)pair._2()).useMultipleValuesPerKey(), isInternal);
    }

    public StatePartitionAllColumnFamiliesWriter(StateStoreConf storeConf, Configuration hadoopConf, int partitionId, String targetCpLocation, int operatorId, String storeName, long currentBatchId, Map<String, StatePartitionWriterColumnFamilyInfo> colFamilyToWriterInfoMap, String operatorName, Option<StateSchemaProvider> schemaProviderOpt, SQLConf sqlConf) {
        StateStoreColFamilySchema stateStoreColFamilySchema;
        this.storeConf = storeConf;
        this.hadoopConf = hadoopConf;
        this.partitionId = partitionId;
        this.targetCpLocation = targetCpLocation;
        this.operatorId = operatorId;
        this.storeName = storeName;
        this.currentBatchId = currentBatchId;
        this.colFamilyToWriterInfoMap = colFamilyToWriterInfoMap;
        this.operatorName = operatorName;
        this.schemaProviderOpt = schemaProviderOpt;
        Option option = colFamilyToWriterInfoMap.get((Object)StateStore$.MODULE$.DEFAULT_COL_FAMILY_NAME());
        if (option instanceof Some) {
            Some some = (Some)option;
            StatePartitionWriterColumnFamilyInfo info = (StatePartitionWriterColumnFamilyInfo)some.value();
            stateStoreColFamilySchema = info.schema();
        } else if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.assert(this.isJoinV3Operator(operatorName, sqlConf), (Function0 & Serializable)() -> "Please provide the schema of 'default' column family in StateStoreColFamilySchemafor operator " + $this.operatorName);
            StateStoreColFamilySchema placeholderSchema = ((StatePartitionWriterColumnFamilyInfo)((Tuple2)colFamilyToWriterInfoMap.head())._2()).schema();
            stateStoreColFamilySchema = new StateStoreColFamilySchema("__dummy__", 0, placeholderSchema.keySchema(), 0, placeholderSchema.valueSchema(), (Option<KeyStateEncoderSpec>)Option$.MODULE$.apply((Object)new NoPrefixKeyStateEncoderSpec(placeholderSchema.keySchema())), StateStoreColFamilySchema$.MODULE$.apply$default$7());
        } else {
            throw new MatchError((Object)option);
        }
        this.defaultSchema = stateStoreColFamilySchema;
        this.useColumnFamilies = colFamilyToWriterInfoMap.size() > 1;
        this.columnFamilyToKeySchemaLenMap = colFamilyToWriterInfoMap.view().mapValues((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)StatePartitionAllColumnFamiliesWriter.$anonfun$columnFamilyToKeySchemaLenMap$1(x$1)));
        this.columnFamilyToValueSchemaLenMap = colFamilyToWriterInfoMap.view().mapValues((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StatePartitionAllColumnFamiliesWriter.$anonfun$columnFamilyToValueSchemaLenMap$1(x$2)));
    }
}

