/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.fpm;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.mllib.fpm.PrefixSpan$;
import org.apache.spark.mllib.fpm.PrefixSpan$Prefix$;
import org.apache.spark.mllib.fpm.PrefixSpanModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.collection.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r%d\u0001B%K\u0001UC\u0001B\u001c\u0001\u0003\u0002\u0004%Ia\u001c\u0005\tg\u0002\u0011\t\u0019!C\u0005i\"A!\u0010\u0001B\u0001B\u0003&\u0001\u000f\u0003\u0005|\u0001\t\u0005\r\u0011\"\u0003}\u0011)\t\t\u0001\u0001BA\u0002\u0013%\u00111\u0001\u0005\n\u0003\u000f\u0001!\u0011!Q!\nuD!\"!\u0003\u0001\u0005\u0003\u0007I\u0011BA\u0006\u0011)\t\u0019\u0002\u0001BA\u0002\u0013%\u0011Q\u0003\u0005\u000b\u00033\u0001!\u0011!Q!\n\u00055\u0001bBA\u000e\u0001\u0011%\u0011Q\u0004\u0005\b\u00037\u0001A\u0011AA\u0015\u0011\u0019\ti\u0004\u0001C\u0001_\"9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003BBA&\u0001\u0011\u0005A\u0010C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005]\u0003\u0001\"\u0001\u0002\f!9\u00111\f\u0001\u0005\u0002\u0005u\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003G\u0002A\u0011AAY\u000f\u001d\t\tP\u0013E\u0001\u0003g4a!\u0013&\t\u0002\u0005U\bbBA\u000e+\u0011\u0005!\u0011\u0001\u0005\t\u0005\u0007)B\u0011\u0001&\u0003\u0006!A!\u0011E\u000b\u0005\u0002)\u0013\u0019\u0003\u0003\u0005\u0003TU!\tA\u0013B+\r\u001d\u00119'\u0006\u0001K\u0005SB!Ba\u001b\u001b\u0005\u000b\u0007I\u0011\u0001B7\u0011)\u0011yG\u0007B\u0001B\u0003%!1\u0006\u0005\n\u0005cR\"Q1A\u0005\u0002qD\u0011Ba\u001d\u001b\u0005\u0003\u0005\u000b\u0011B?\t\u000f\u0005m!\u0004\"\u0003\u0003v!A!q\u0010\u000eC\u0002\u0013\u0005A\u0010C\u0004\u0003\u0002j\u0001\u000b\u0011B?\t\u000f\t\r%\u0004\"\u0001\u0003\u0006\u001eA!1R\u000b\t\u0002)\u0013iI\u0002\u0005\u0003hUA\tA\u0013BH\u0011\u001d\tY\u0002\nC\u0001\u0005#C\u0011Ba%%\u0005\u0004%IA!&\t\u0011\t-F\u0005)A\u0005\u0005/CaA!,%\t\u0013a\b\"\u0003BXI\t\u0007I\u0011\u0001BY\u0011!\u0011\u0019\f\nQ\u0001\n\t]\u0004\"\u0003B[I\u0005\u0005I\u0011\u0002B\\\r\u001d\u0011y,\u0006\u0001K\u0005\u0003D!Ba\u001b-\u0005\u000b\u0007I\u0011\u0001B7\u0011)\u0011y\u0007\fB\u0001B\u0003%!1\u0006\u0005\n\u0005\u0007d#Q1A\u0005\u0002qD\u0011B!2-\u0005\u0003\u0005\u000b\u0011B?\t\u0015\t\u001dGF!b\u0001\n\u0003\u0011i\u0007\u0003\u0006\u0003J2\u0012\t\u0011)A\u0005\u0005WAq!a\u0007-\t\u0003\u0011Y\rC\u0004\u0003V2\u0002K\u0011\u0002?\t\u000f\t]G\u0006\"\u0001\u0003Z\"9!1\u001d\u0017\u0005\u0002\t\u0015\bb\u0002BwY\u0011\u0005!q\u001e\u0005\b\u0005[dC\u0011\u0002B{\u0011\u001d\u0011i\u000f\fC\u0001\u0005sDqA!@-\t\u0003\u0011yp\u0002\u0006\u0004\u0002U\t\t\u0011#\u0001K\u0007\u00071!Ba0\u0016\u0003\u0003E\tASB\u0003\u0011\u001d\tY\u0002\u0010C\u0001\u0007\u000fA\u0011b!\u0003=#\u0003%\taa\u0003\t\u0013\r}A(%A\u0005\u0002\r\u0005\u0002\"\u0003B[y\u0005\u0005I\u0011\u0002B\\\r\u0019\u0019)#\u0006\u0001\u0004(!Q11F!\u0003\u0006\u0004%\ta!\f\t\u0015\re\u0012I!A!\u0002\u0013\u0019y\u0003\u0003\u0006\u0004>\u0005\u0013)\u0019!C\u0001\u0003\u0017A!b!\u0011B\u0005\u0003\u0005\u000b\u0011BA\u0007\u0011\u001d\tY\"\u0011C\u0001\u0007\u000bBqaa\u0015B\t\u0003\u0019)\u0006C\u0005\u00036V\t\t\u0011\"\u0003\u00038\nQ\u0001K]3gSb\u001c\u0006/\u00198\u000b\u0005-c\u0015a\u00014q[*\u0011QJT\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u001fB\u000bQa\u001d9be.T!!\u0015*\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0016aA8sO\u000e\u00011\u0003\u0002\u0001W9\n\u0004\"a\u0016.\u000e\u0003aS\u0011!W\u0001\u0006g\u000e\fG.Y\u0005\u00037b\u0013a!\u00118z%\u00164\u0007CA/a\u001b\u0005q&BA0O\u0003!Ig\u000e^3s]\u0006d\u0017BA1_\u0005\u001daunZ4j]\u001e\u0004\"aY6\u000f\u0005\u0011LgBA3i\u001b\u00051'BA4U\u0003\u0019a$o\\8u}%\t\u0011,\u0003\u0002k1\u00069\u0001/Y2lC\u001e,\u0017B\u00017n\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tQ\u0007,\u0001\u0006nS:\u001cV\u000f\u001d9peR,\u0012\u0001\u001d\t\u0003/FL!A\u001d-\u0003\r\u0011{WO\u00197f\u00039i\u0017N\\*vaB|'\u000f^0%KF$\"!\u001e=\u0011\u0005]3\u0018BA<Y\u0005\u0011)f.\u001b;\t\u000fe\u0014\u0011\u0011!a\u0001a\u0006\u0019\u0001\u0010J\u0019\u0002\u00175LgnU;qa>\u0014H\u000fI\u0001\u0011[\u0006D\b+\u0019;uKJtG*\u001a8hi\",\u0012! \t\u0003/zL!a -\u0003\u0007%sG/\u0001\u000bnCb\u0004\u0016\r\u001e;fe:dUM\\4uQ~#S-\u001d\u000b\u0004k\u0006\u0015\u0001bB=\u0006\u0003\u0003\u0005\r!`\u0001\u0012[\u0006D\b+\u0019;uKJtG*\u001a8hi\"\u0004\u0013AE7bq2{7-\u00197Qe>TGIQ*ju\u0016,\"!!\u0004\u0011\u0007]\u000by!C\u0002\u0002\u0012a\u0013A\u0001T8oO\u00061R.\u0019=M_\u000e\fG\u000e\u0015:pU\u0012\u00135+\u001b>f?\u0012*\u0017\u000fF\u0002v\u0003/A\u0001\"\u001f\u0005\u0002\u0002\u0003\u0007\u0011QB\u0001\u0014[\u0006DHj\\2bYB\u0013xN\u001b#C'&TX\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011\u0005}\u00111EA\u0013\u0003O\u00012!!\t\u0001\u001b\u0005Q\u0005\"\u00028\u000b\u0001\u0004\u0001\b\"B>\u000b\u0001\u0004i\bbBA\u0005\u0015\u0001\u0007\u0011Q\u0002\u000b\u0003\u0003?ASaCA\u0017\u0003s\u0001B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003gq\u0015AC1o]>$\u0018\r^5p]&!\u0011qGA\u0019\u0005\u0015\u0019\u0016N\\2fC\t\tY$A\u00032]Ur\u0003'A\u0007hKRl\u0015N\\*vaB|'\u000f\u001e\u0015\u0006\u0019\u00055\u0012\u0011H\u0001\u000eg\u0016$X*\u001b8TkB\u0004xN\u001d;\u0015\t\u0005\u0015\u0013qI\u0007\u0002\u0001!)a.\u0004a\u0001a\"*Q\"!\f\u0002:\u0005\u0019r-\u001a;NCb\u0004\u0016\r\u001e;fe:dUM\\4uQ\"*a\"!\f\u0002:\u0005\u00192/\u001a;NCb\u0004\u0016\r\u001e;fe:dUM\\4uQR!\u0011QIA*\u0011\u0015Yx\u00021\u0001~Q\u0015y\u0011QFA\u001d\u0003U9W\r^'bq2{7-\u00197Qe>TGIQ*ju\u0016DS\u0001EA\u0017\u0003s\tQc]3u\u001b\u0006DHj\\2bYB\u0013xN\u001b#C'&TX\r\u0006\u0003\u0002F\u0005}\u0003bBA\u0005#\u0001\u0007\u0011Q\u0002\u0015\u0006#\u00055\u0012\u0011H\u0001\u0004eVtW\u0003BA4\u0003k\"B!!\u001b\u0002\u0018R!\u00111NAD!\u0019\t\t#!\u001c\u0002r%\u0019\u0011q\u000e&\u0003\u001fA\u0013XMZ5y'B\fg.T8eK2\u0004B!a\u001d\u0002v1\u0001AaBA<%\t\u0007\u0011\u0011\u0010\u0002\u0005\u0013R,W.\u0005\u0003\u0002|\u0005\u0005\u0005cA,\u0002~%\u0019\u0011q\u0010-\u0003\u000f9{G\u000f[5oOB\u0019q+a!\n\u0007\u0005\u0015\u0005LA\u0002B]fD\u0011\"!#\u0013\u0003\u0003\u0005\u001d!a#\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0004\u0002\u000e\u0006M\u0015\u0011O\u0007\u0003\u0003\u001fS1!!%Y\u0003\u001d\u0011XM\u001a7fGRLA!!&\u0002\u0010\nA1\t\\1tgR\u000bw\rC\u0004\u0002\u001aJ\u0001\r!a'\u0002\t\u0011\fG/\u0019\t\u0007\u0003;\u000b\u0019+a*\u000e\u0005\u0005}%bAAQ\u001d\u0006\u0019!\u000f\u001a3\n\t\u0005\u0015\u0016q\u0014\u0002\u0004%\u0012#\u0005#B,\u0002*\u00065\u0016bAAV1\n)\u0011I\u001d:bsB)q+!+\u0002r!*!#!\f\u0002:UA\u00111WA]\u0003K\fy\r\u0006\u0003\u00026\u0006m\u0006CBA\u0011\u0003[\n9\f\u0005\u0003\u0002t\u0005eFaBA<'\t\u0007\u0011\u0011\u0010\u0005\b\u00033\u001b\u0002\u0019AA_!\u0019\ty,!3\u0002N6\u0011\u0011\u0011\u0019\u0006\u0005\u0003\u0007\f)-\u0001\u0003kCZ\f'bAAd\u001d\u0006\u0019\u0011\r]5\n\t\u0005-\u0017\u0011\u0019\u0002\b\u0015\u00064\u0018M\u0015#E!\u0011\t\u0019(a4\u0005\u000f\u0005E7C1\u0001\u0002T\nA1+Z9vK:\u001cW-\u0005\u0003\u0002|\u0005U\u0007CBAl\u0003?\f\u0019/\u0004\u0002\u0002Z*!\u00111\\Ao\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0017\u0002BAq\u00033\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0005\u0003g\n)\u000fB\u0004\u0002hN\u0011\r!!;\u0003\u000f%#X-\\:fiF!\u00111PAv!\u0019\t9.a8\u00028\"*1#!\f\u0002:!*\u0001!!\f\u0002:\u0005Q\u0001K]3gSb\u001c\u0006/\u00198\u0011\u0007\u0005\u0005RcE\u0003\u0016-r\u000b9\u0010\u0005\u0003\u0002z\u0006}XBAA~\u0015\u0011\ti0!8\u0002\u0005%|\u0017b\u00017\u0002|R\u0011\u00111_\u0001\u0012M&tGM\u0012:fcV,g\u000e^%uK6\u001cX\u0003\u0002B\u0004\u0005\u001f!bA!\u0003\u0003\u0018\tuA\u0003\u0002B\u0006\u0005#\u0001RaVAU\u0005\u001b\u0001B!a\u001d\u0003\u0010\u00119\u0011qO\fC\u0002\u0005e\u0004\"\u0003B\n/\u0005\u0005\t9\u0001B\u000b\u0003))g/\u001b3f]\u000e,GE\r\t\u0007\u0003\u001b\u000b\u0019J!\u0004\t\u000f\u0005eu\u00031\u0001\u0003\u001aA1\u0011QTAR\u00057\u0001RaVAU\u0005\u0017AqAa\b\u0018\u0001\u0004\ti!\u0001\u0005nS:\u001cu.\u001e8u\u0003Y!x\u000eR1uC\n\f7/Z%oi\u0016\u0014h.\u00197SKB\u0014X\u0003\u0002B\u0013\u0005k!bAa\n\u00038\t}B\u0003\u0002B\u0015\u0005[\u0001b!!(\u0002$\n-\u0002\u0003B,\u0002*vD\u0011Ba\f\u0019\u0003\u0003\u0005\u001dA!\r\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007\u0005\u0004\u0002\u000e\u0006M%1\u0007\t\u0005\u0003g\u0012)\u0004B\u0004\u0002xa\u0011\r!!\u001f\t\u000f\u0005e\u0005\u00041\u0001\u0003:A1\u0011QTAR\u0005w\u0001RaVAU\u0005{\u0001RaVAU\u0005gAqA!\u0011\u0019\u0001\u0004\u0011\u0019%A\u0005ji\u0016lGk\\%oiB9!Q\tB'\u0005gih\u0002\u0002B$\u0005\u0013\u0002\"!\u001a-\n\u0007\t-\u0003,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u001f\u0012\tFA\u0002NCBT1Aa\u0013Y\u0003=9WM\u001c$sKF\u0004\u0016\r\u001e;fe:\u001cHC\u0003B,\u0005?\u0012\tGa\u0019\u0003fA1\u0011QTAR\u00053\u0002ra\u0016B.\u0005W\ti!C\u0002\u0003^a\u0013a\u0001V;qY\u0016\u0014\u0004bBAM3\u0001\u0007!\u0011\u0006\u0005\b\u0005?I\u0002\u0019AA\u0007\u0011\u0015Y\u0018\u00041\u0001~\u0011\u001d\tI!\u0007a\u0001\u0003\u001b\u0011a\u0001\u0015:fM&D8c\u0001\u000eWE\u0006)\u0011\u000e^3ngV\u0011!1F\u0001\u0007SR,Wn\u001d\u0011\u0002\r1,gn\u001a;i\u0003\u001daWM\\4uQ\u0002\"bAa\u001e\u0003|\tu\u0004c\u0001B=55\tQ\u0003C\u0004\u0003l}\u0001\rAa\u000b\t\r\tEt\u00041\u0001~\u0003\tIG-A\u0002jI\u0002\n1\u0002J2pY>tG\u0005\u001d7vgR!!q\u000fBD\u0011\u0019\u0011II\ta\u0001{\u0006!\u0011\u000e^3n\u0003\u0019\u0001&/\u001a4jqB\u0019!\u0011\u0010\u0013\u0014\t\u00112\u0016q\u001f\u000b\u0003\u0005\u001b\u000bqaY8v]R,'/\u0006\u0002\u0003\u0018B!!\u0011\u0014BT\u001b\t\u0011YJ\u0003\u0003\u0003\u001e\n}\u0015AB1u_6L7M\u0003\u0003\u0003\"\n\r\u0016AC2p]\u000e,(O]3oi*!!QUAo\u0003\u0011)H/\u001b7\n\t\t%&1\u0014\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002\u0011\r|WO\u001c;fe\u0002\naA\\3yi&#\u0017!B3naRLXC\u0001B<\u0003\u0019)W\u000e\u001d;zA\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u0018\t\u0005\u0003/\u0014Y,\u0003\u0003\u0003>\u0006e'AB(cU\u0016\u001cGOA\u0004Q_N$h-\u001b=\u0014\u000712&-A\u0003ti\u0006\u0014H/\u0001\u0004ti\u0006\u0014H\u000fI\u0001\u000ea\u0006\u0014H/[1m'R\f'\u000f^:\u0002\u001dA\f'\u000f^5bYN#\u0018M\u001d;tAQA!Q\u001aBh\u0005#\u0014\u0019\u000eE\u0002\u0003z1BqAa\u001b4\u0001\u0004\u0011Y\u0003\u0003\u0005\u0003DN\u0002\n\u00111\u0001~\u0011%\u00119m\rI\u0001\u0002\u0004\u0011Y#A\u0005gk2d7\u000b^1si\u0006qq-\u001a8Qe\u00164\u0017\u000e_%uK6\u001cXC\u0001Bn!\u0015\u0019'Q\u001cBq\u0013\r\u0011y.\u001c\u0002\t\u0013R,'/\u0019;peB1qKa\u0017~\u0003\u001b\t\u0001B\\8o\u000b6\u0004H/_\u000b\u0003\u0005O\u00042a\u0016Bu\u0013\r\u0011Y\u000f\u0017\u0002\b\u0005>|G.Z1o\u0003\u001d\u0001(o\u001c6fGR$BA!4\u0003r\"1!1_\u001cA\u0002u\fa\u0001\u001d:fM&DH\u0003\u0002Bg\u0005oDqAa=9\u0001\u0004\u0011Y\u0003\u0006\u0003\u0003N\nm\bb\u0002Bzs\u0001\u0007!qO\u0001\u000bG>l\u0007O]3tg\u0016$WC\u0001Bg\u0003\u001d\u0001vn\u001d;gSb\u00042A!\u001f='\u0011ad+a>\u0015\u0005\r\r\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0004\u000e)\u001aQpa\u0004,\u0005\rE\u0001\u0003BB\n\u00077i!a!\u0006\u000b\t\r]1\u0011D\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\rY\u0013\u0011\u0019ib!\u0006\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0007GQCAa\u000b\u0004\u0010\taaI]3r'\u0016\fX/\u001a8dKV!1\u0011FB\u001b'\r\teKY\u0001\tg\u0016\fX/\u001a8dKV\u00111q\u0006\t\u0006/\u0006%6\u0011\u0007\t\u0006/\u0006%61\u0007\t\u0005\u0003g\u001a)\u0004B\u0004\u0002x\u0005\u0013\r!!\u001f)\u000b\t\u000bi#!\u000f\u0002\u0013M,\u0017/^3oG\u0016\u0004\u0003&B\"\u0002.\u0005e\u0012\u0001\u00024sKFDS\u0001RA\u0017\u0003s\tQA\u001a:fc\u0002BS!RA\u0017\u0003s!baa\u0012\u0004J\r5\u0003#\u0002B=\u0003\u000eM\u0002bBB\u0016\r\u0002\u00071q\u0006\u0015\u0007\u0007\u0013\ni#!\u000f\t\u000f\rub\t1\u0001\u0002\u000e!21QJA\u0017\u0003sASARA\u0017\u0003s\tAB[1wCN+\u0017/^3oG\u0016,\"aa\u0016\u0011\r\re31LB0\u001b\t\u0011\u0019+\u0003\u0003\u0004^\t\r&\u0001\u0002'jgR\u0004ba!\u0017\u0004\\\rM\u0002&B$\u0002.\u0005e\u0002&B!\u0002.\u0005e\u0002&B\u000b\u0002.\u0005e\u0002&\u0002\u000b\u0002.\u0005e\u0002")
public class PrefixSpan
implements Logging,
Serializable {
    private double minSupport;
    private int maxPatternLength;
    private long maxLocalProjDBSize;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private double minSupport() {
        return this.minSupport;
    }

    private void minSupport_$eq(double x$1) {
        this.minSupport = x$1;
    }

    private int maxPatternLength() {
        return this.maxPatternLength;
    }

    private void maxPatternLength_$eq(int x$1) {
        this.maxPatternLength = x$1;
    }

    private long maxLocalProjDBSize() {
        return this.maxLocalProjDBSize;
    }

    private void maxLocalProjDBSize_$eq(long x$1) {
        this.maxLocalProjDBSize = x$1;
    }

    public double getMinSupport() {
        return this.minSupport();
    }

    public PrefixSpan setMinSupport(double minSupport) {
        Predef$.MODULE$.require(minSupport >= 0.0 && minSupport <= 1.0, (Function0 & Serializable)() -> "The minimum support value must be in [0, 1], but got " + minSupport + ".");
        this.minSupport_$eq(minSupport);
        return this;
    }

    public int getMaxPatternLength() {
        return this.maxPatternLength();
    }

    public PrefixSpan setMaxPatternLength(int maxPatternLength) {
        Predef$.MODULE$.require(maxPatternLength >= 1, (Function0 & Serializable)() -> "The maximum pattern length value must be greater than 0, but got " + maxPatternLength + ".");
        this.maxPatternLength_$eq(maxPatternLength);
        return this;
    }

    public long getMaxLocalProjDBSize() {
        return this.maxLocalProjDBSize();
    }

    public PrefixSpan setMaxLocalProjDBSize(long maxLocalProjDBSize) {
        Predef$.MODULE$.require(maxLocalProjDBSize >= 0L, (Function0 & Serializable)() -> "The maximum local projected database size must be nonnegative, but got " + maxLocalProjDBSize);
        this.maxLocalProjDBSize_$eq(maxLocalProjDBSize);
        return this;
    }

    public <Item> PrefixSpanModel<Item> run(RDD<Object[]> data, ClassTag<Item> evidence$1) {
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Input data is not cached.");
        }
        long totalCount = data.count();
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"number of sequences: ", ""}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_SEQUENCES, BoxesRunTime.boxToLong((long)totalCount))}))));
        long minCount = (long)package$.MODULE$.ceil(this.minSupport() * (double)totalCount);
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"minimum count for a frequent pattern: ", ""}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.MIN_NUM_FREQUENT_PATTERN, BoxesRunTime.boxToLong((long)minCount))}))));
        Object freqItems = PrefixSpan$.MODULE$.findFrequentItems(data, minCount, evidence$1);
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"number of frequent items: ", ""}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_FREQUENT_ITEMS, BoxesRunTime.boxToInteger((int)ScalaRunTime$.MODULE$.array_length(freqItems)))}))));
        scala.collection.immutable.Map itemToInt = Utils$.MODULE$.toMapWithIndex((Iterable)Predef$.MODULE$.genericWrapArray(freqItems));
        RDD dataInternalRepr = PrefixSpan$.MODULE$.toDatabaseInternalRepr(data, itemToInt, evidence$1).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        RDD<Tuple2<int[], Object>> results = PrefixSpan$.MODULE$.genFreqPatterns((RDD<int[]>)dataInternalRepr, minCount, this.maxPatternLength(), this.maxLocalProjDBSize());
        RDD freqSequences = results.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int[] seq = (int[])tuple2._1();
                long count = tuple2._2$mcJ$sp();
                if (seq != null) {
                    int[] nArray = seq;
                    if (true) {
                        long l = count;
                        return new FreqSequence(PrefixSpan.toPublicRepr$1(nArray, evidence$1, freqItems), l);
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(FreqSequence.class));
        StorageLevel storageLevel3 = data.getStorageLevel();
        StorageLevel storageLevel4 = StorageLevel$.MODULE$.NONE();
        if (storageLevel3 == null ? storageLevel4 != null : !storageLevel3.equals(storageLevel4)) {
            freqSequences.persist(data.getStorageLevel());
            v2 = BoxesRunTime.boxToLong((long)freqSequences.count());
        } else {
            v2 = BoxedUnit.UNIT;
        }
        dataInternalRepr.unpersist(dataInternalRepr.unpersist$default$1());
        return new PrefixSpanModel(freqSequences);
    }

    public <Item, Itemset extends java.lang.Iterable<Item>, Sequence extends java.lang.Iterable<Itemset>> PrefixSpanModel<Item> run(JavaRDD<Sequence> data) {
        ClassTag tag = JavaSparkContext$.MODULE$.fakeClassTag();
        return this.run((RDD<Object[]>)data.rdd().map((Function1 & Serializable)x$1 -> (Object[])((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(x$1).asScala().map((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.IterableHasAsScala(x$2).asScala().toArray(tag))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(tag.runtimeClass()))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(tag.runtimeClass())))), tag);
    }

    private static final Object[] toPublicRepr$1(int[] pattern, ClassTag evidence$1$1, Object freqItems$1) {
        ArrayBuilder sequenceBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$1$1.runtimeClass())));
        ArrayBuilder itemsetBuilder = ArrayBuilder$.MODULE$.make(evidence$1$1);
        int n = pattern.length;
        for (int i = 1; i < n; ++i) {
            BoxedUnit boxedUnit;
            int x = pattern[i];
            if (x == 0) {
                sequenceBuilder.$plus$eq(itemsetBuilder.result());
                itemsetBuilder.clear();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = itemsetBuilder.$plus$eq(ScalaRunTime$.MODULE$.array_apply(freqItems$1, x - 1));
        }
        return (Object[])sequenceBuilder.result();
    }

    private PrefixSpan(double minSupport, int maxPatternLength, long maxLocalProjDBSize) {
        this.minSupport = minSupport;
        this.maxPatternLength = maxPatternLength;
        this.maxLocalProjDBSize = maxLocalProjDBSize;
        Logging.$init$((Logging)this);
    }

    public PrefixSpan() {
        this(0.1, 10, 32000000L);
    }

    public static class FreqSequence<Item>
    implements Serializable {
        private final Object[] sequence;
        private final long freq;

        public Object[] sequence() {
            return this.sequence;
        }

        public long freq() {
            return this.freq;
        }

        public List<List<Item>> javaSequence() {
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(this.sequence()), (Function1 & Serializable)x$10 -> CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.genericWrapArray(x$10).toList()).asJava(), ClassTag$.MODULE$.apply(List.class))).toList()).asJava();
        }

        public FreqSequence(Object[] sequence, long freq) {
            this.sequence = sequence;
            this.freq = freq;
        }
    }

    public static class Postfix
    implements Serializable {
        private final int[] items;
        private final int start;
        private final int[] partialStarts;

        public int[] items() {
            return this.items;
        }

        public int start() {
            return this.start;
        }

        public int[] partialStarts() {
            return this.partialStarts;
        }

        private int fullStart() {
            int i = this.start();
            while (this.items()[i] != 0) {
                ++i;
            }
            return i;
        }

        public Iterator<Tuple2<Object, Object>> genPrefixItems() {
            int n1 = this.items().length - 1;
            scala.collection.mutable.Map prefixes = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(this.partialStarts()), (Function1)(JFunction1.mcVI.sp & Serializable)start -> {
                int i = start;
                int x = -this.items()[i];
                while (x != 0) {
                    if (!prefixes.contains((Object)BoxesRunTime.boxToInteger((int)x))) {
                        prefixes.update((Object)BoxesRunTime.boxToInteger((int)x), (Object)BoxesRunTime.boxToLong((long)(n1 - i)));
                    }
                    x = -this.items()[++i];
                }
            });
            for (int i = this.fullStart(); i < n1; ++i) {
                int x = this.items()[i];
                if (x == 0 || prefixes.contains((Object)BoxesRunTime.boxToInteger((int)x))) continue;
                prefixes.update((Object)BoxesRunTime.boxToInteger((int)x), (Object)BoxesRunTime.boxToLong((long)(n1 - i)));
            }
            return prefixes.iterator();
        }

        public boolean nonEmpty() {
            return this.items().length > this.start() + 1;
        }

        public Postfix project(int prefix) {
            Predef$.MODULE$.require(prefix != 0);
            int n1 = this.items().length - 1;
            BooleanRef matched = BooleanRef.create((boolean)false);
            IntRef newStart = IntRef.create((int)n1);
            ArrayBuilder newPartialStarts = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Int());
            if (prefix < 0) {
                int target = -prefix;
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(this.partialStarts()), (Function1 & Serializable)start -> Postfix.$anonfun$project$1(this, target, matched, newStart, newPartialStarts, BoxesRunTime.unboxToInt((Object)start)));
            } else {
                int target = prefix;
                for (int i = this.fullStart(); i < n1; ++i) {
                    BoxedUnit boxedUnit;
                    int x = this.items()[i];
                    if (x == target) {
                        if (!matched.elem) {
                            newStart.elem = i;
                            matched.elem = true;
                        }
                        if (this.items()[i + 1] != 0) {
                            boxedUnit = newPartialStarts.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i + 1)));
                            continue;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return new Postfix(this.items(), newStart.elem, (int[])newPartialStarts.result());
        }

        private Postfix project(int[] prefix) {
            boolean partial = true;
            Postfix cur = this;
            int np = prefix.length;
            for (int i = 0; i < np && cur.nonEmpty(); ++i) {
                int x = prefix[i];
                if (x == 0) {
                    partial = false;
                    continue;
                }
                if (partial) {
                    cur = cur.project(-x);
                    continue;
                }
                cur = cur.project(x);
                partial = true;
            }
            return cur;
        }

        public Postfix project(Prefix prefix) {
            return this.project(prefix.items());
        }

        public Postfix compressed() {
            if (this.start() > 0) {
                return new Postfix((int[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.intArrayOps(this.items()), this.start(), this.items().length), 0, (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(this.partialStarts()), (Function1)(JFunction1.mcII.sp & Serializable)x$9 -> x$9 - this.start(), (ClassTag)ClassTag$.MODULE$.Int()));
            }
            return this;
        }

        public static final /* synthetic */ Object $anonfun$project$1(Postfix $this, int target$1, BooleanRef matched$1, IntRef newStart$1, ArrayBuilder newPartialStarts$1, int start) {
            int i = start;
            int x = $this.items()[i];
            while (x != target$1 && x != 0) {
                x = $this.items()[++i];
            }
            if (x == target$1) {
                ++i;
                if (!matched$1.elem) {
                    newStart$1.elem = i;
                    matched$1.elem = true;
                }
                if ($this.items()[i] != 0) {
                    return newPartialStarts$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }

        public Postfix(int[] items, int start, int[] partialStarts) {
            block0: {
                this.items = items;
                this.start = start;
                this.partialStarts = partialStarts;
                Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.intArrayOps(items))) == 0, (Function0 & Serializable)() -> "The last item in a postfix must be zero, but got " + ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.intArrayOps(this.items())) + ".");
                if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.intArrayOps(partialStarts))) break block0;
                Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.intArrayOps(partialStarts))) >= start, (Function0 & Serializable)() -> "The first partial start cannot be smaller than the start index,but got partialStarts.head = " + ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.intArrayOps(this.partialStarts())) + " < start = " + this.start() + ".");
            }
        }
    }

    public static class Prefix
    implements Serializable {
        private final int[] items;
        private final int length;
        private final int id;

        public int[] items() {
            return this.items;
        }

        public int length() {
            return this.length;
        }

        public int id() {
            return this.id;
        }

        public Prefix $colon$plus(int item) {
            Predef$.MODULE$.require(item != 0);
            if (item < 0) {
                return new Prefix((int[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.intArrayOps(this.items()), (Object)BoxesRunTime.boxToInteger((int)(-item)), (ClassTag)ClassTag$.MODULE$.Int()), this.length() + 1);
            }
            return new Prefix((int[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.intArrayOps(this.items()), (Object)new int[]{0, item}, (ClassTag)ClassTag$.MODULE$.Int()), this.length() + 1);
        }

        public Prefix(int[] items, int length) {
            this.items = items;
            this.length = length;
            this.id = PrefixSpan$Prefix$.MODULE$.org$apache$spark$mllib$fpm$PrefixSpan$Prefix$$nextId();
        }
    }
}

