/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorExplainVectorization;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorSelectDesc;

@Explain(displayName="Select Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class SelectDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private List<ExprNodeDesc> colList;
    private List<String> outputColumnNames;
    private boolean selectStar;
    private boolean selStarNoCompute;

    public SelectDesc() {
    }

    public SelectDesc(boolean selStarNoCompute) {
        this.selStarNoCompute = selStarNoCompute;
    }

    public SelectDesc(List<ExprNodeDesc> colList, List<String> outputColumnNames) {
        this(colList, outputColumnNames, false);
    }

    public SelectDesc(List<ExprNodeDesc> colList, List<String> outputColumnNames, boolean selectStar) {
        this.colList = colList;
        this.selectStar = selectStar;
        this.outputColumnNames = outputColumnNames;
    }

    @Override
    public Object clone() {
        SelectDesc ret = new SelectDesc();
        ret.setColList((List<ExprNodeDesc>)(this.getColList() == null ? null : new ArrayList<ExprNodeDesc>(this.getColList())));
        ret.setOutputColumnNames((List<String>)(this.getOutputColumnNames() == null ? null : new ArrayList<String>(this.getOutputColumnNames())));
        ret.setSelectStar(this.selectStar);
        ret.setSelStarNoCompute(this.selStarNoCompute);
        return ret;
    }

    @Explain(displayName="expressions")
    public String getColListString() {
        return PlanUtils.getExprListString(this.colList);
    }

    public List<ExprNodeDesc> getColList() {
        return this.colList;
    }

    public void setColList(List<ExprNodeDesc> colList) {
        this.colList = colList;
    }

    @Explain(displayName="outputColumnNames")
    public List<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    @Explain(displayName="Output", explainLevels={Explain.Level.USER})
    public List<String> getUserLevelExplainOutputColumnNames() {
        return this.outputColumnNames;
    }

    public void setOutputColumnNames(List<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    @Explain(displayName="SELECT * ")
    public String explainNoCompute() {
        if (this.isSelStarNoCompute()) {
            return "(no compute)";
        }
        return null;
    }

    public boolean isSelectStar() {
        return this.selectStar;
    }

    public void setSelectStar(boolean selectStar) {
        this.selectStar = selectStar;
    }

    public boolean isSelStarNoCompute() {
        return this.selStarNoCompute;
    }

    public void setSelStarNoCompute(boolean selStarNoCompute) {
        this.selStarNoCompute = selStarNoCompute;
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="Select Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public SelectOperatorExplainVectorization getSelectVectorization() {
        if (this.vectorDesc == null) {
            return null;
        }
        return new SelectOperatorExplainVectorization(this, this.vectorDesc);
    }

    public class SelectOperatorExplainVectorization
    extends OperatorExplainVectorization {
        private final SelectDesc selectDesc;
        private final VectorSelectDesc vectorSelectDesc;

        public SelectOperatorExplainVectorization(SelectDesc selectDesc, VectorDesc vectorDesc) {
            super(vectorDesc, true);
            this.selectDesc = selectDesc;
            this.vectorSelectDesc = (VectorSelectDesc)vectorDesc;
        }

        @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="selectExpressions", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getSelectExpressions() {
            return this.vectorExpressionsToStringList(this.vectorSelectDesc.getSelectExpressions());
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="projectedOutputColumns", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getProjectedOutputColumns() {
            return Arrays.toString(this.vectorSelectDesc.getProjectedOutputColumns());
        }
    }
}

