/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.compression.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.List;
import org.sparkproject.jetty.compression.Compression;
import org.sparkproject.jetty.compression.DecoderConfig;
import org.sparkproject.jetty.compression.DecoderSource;
import org.sparkproject.jetty.compression.EncoderConfig;
import org.sparkproject.jetty.compression.EncoderSink;
import org.sparkproject.jetty.compression.gzip.GzipDecoderConfig;
import org.sparkproject.jetty.compression.gzip.GzipEncoderConfig;
import org.sparkproject.jetty.compression.gzip.internal.ConfigurableGzipInputStream;
import org.sparkproject.jetty.compression.gzip.internal.ConfigurableGzipOutputStream;
import org.sparkproject.jetty.compression.gzip.internal.GzipDecoderSource;
import org.sparkproject.jetty.compression.gzip.internal.GzipEncoderSink;
import org.sparkproject.jetty.http.HttpField;
import org.sparkproject.jetty.http.HttpHeader;
import org.sparkproject.jetty.http.PreEncodedHttpField;
import org.sparkproject.jetty.io.Content;
import org.sparkproject.jetty.io.RetainableByteBuffer;
import org.sparkproject.jetty.util.compression.DeflaterPool;
import org.sparkproject.jetty.util.compression.InflaterPool;

public class GzipCompression
extends Compression {
    private static final int DEFAULT_MIN_GZIP_SIZE = 32;
    private static final List<String> EXTENSIONS = List.of("gz", "gzip");
    private static final String ENCODING_NAME = "gzip";
    private static final HttpField X_CONTENT_ENCODING = new PreEncodedHttpField("X-Content-Encoding", "gzip");
    private static final HttpField CONTENT_ENCODING = new PreEncodedHttpField(HttpHeader.CONTENT_ENCODING, "gzip");
    private DeflaterPool deflaterPool;
    private InflaterPool inflaterPool;
    private GzipEncoderConfig defaultEncoderConfig = new GzipEncoderConfig();
    private GzipDecoderConfig defaultDecoderConfig = new GzipDecoderConfig();

    public GzipCompression() {
        super(ENCODING_NAME);
        this.setMinCompressSize(32);
    }

    @Override
    public RetainableByteBuffer.Mutable acquireByteBuffer(int length) {
        RetainableByteBuffer.Mutable buffer = this.getByteBufferPool().acquire(length, true);
        buffer.getByteBuffer().order(this.getByteOrder());
        return buffer;
    }

    @Override
    public HttpField getContentEncodingField() {
        return CONTENT_ENCODING;
    }

    @Override
    public DecoderConfig getDefaultDecoderConfig() {
        return this.defaultDecoderConfig;
    }

    @Override
    public void setDefaultDecoderConfig(DecoderConfig config) {
        this.defaultDecoderConfig = (GzipDecoderConfig)config;
    }

    @Override
    public EncoderConfig getDefaultEncoderConfig() {
        return this.defaultEncoderConfig;
    }

    @Override
    public void setDefaultEncoderConfig(EncoderConfig config) {
        this.defaultEncoderConfig = (GzipEncoderConfig)config;
    }

    public DeflaterPool getDeflaterPool() {
        return this.deflaterPool;
    }

    public void setDeflaterPool(DeflaterPool deflaterPool) {
        this.deflaterPool = deflaterPool;
    }

    @Override
    public List<String> getFileExtensionNames() {
        return EXTENSIONS;
    }

    public InflaterPool getInflaterPool() {
        return this.inflaterPool;
    }

    public void setInflaterPool(InflaterPool inflaterPool) {
        this.inflaterPool = inflaterPool;
    }

    @Override
    public void setMinCompressSize(int minCompressSize) {
        super.setMinCompressSize(Math.max(minCompressSize, 32));
    }

    @Override
    public String getName() {
        return ENCODING_NAME;
    }

    @Override
    public HttpField getXContentEncodingField() {
        return X_CONTENT_ENCODING;
    }

    @Override
    public InputStream newDecoderInputStream(InputStream in, DecoderConfig config) throws IOException {
        GzipDecoderConfig gzipDecoderConfig = (GzipDecoderConfig)config;
        return new ConfigurableGzipInputStream(in, gzipDecoderConfig);
    }

    @Override
    public DecoderSource newDecoderSource(Content.Source source, DecoderConfig config) {
        GzipDecoderConfig gzipDecoderConfig = (GzipDecoderConfig)config;
        return new GzipDecoderSource(source, this, gzipDecoderConfig);
    }

    @Override
    public OutputStream newEncoderOutputStream(OutputStream out, EncoderConfig config) throws IOException {
        GzipEncoderConfig gzipEncoderConfig = (GzipEncoderConfig)config;
        return new ConfigurableGzipOutputStream(out, gzipEncoderConfig);
    }

    @Override
    public EncoderSink newEncoderSink(Content.Sink sink, EncoderConfig config) {
        GzipEncoderConfig gzipEncoderConfig = (GzipEncoderConfig)config;
        return new GzipEncoderSink(this, sink, gzipEncoderConfig);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.deflaterPool == null) {
            this.deflaterPool = DeflaterPool.ensurePool(this.getContainer());
        }
        this.addBean(this.deflaterPool);
        if (this.inflaterPool == null) {
            this.inflaterPool = InflaterPool.ensurePool(this.getContainer());
        }
        this.addBean(this.inflaterPool);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.inflaterPool);
        this.inflaterPool = null;
        this.removeBean(this.deflaterPool);
        this.deflaterPool = null;
    }

    private ByteOrder getByteOrder() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

