/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.ee10.servlet;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.ee10.servlet.ServletContextHandler;
import org.sparkproject.jetty.ee10.servlet.ServletHandler;
import org.sparkproject.jetty.ee10.servlet.ServletHolder;
import org.sparkproject.jetty.ee10.servlet.ServletMapping;
import org.sparkproject.jetty.server.handler.ContextHandler;
import org.sparkproject.jetty.util.ArrayUtil;
import org.sparkproject.jetty.util.URIUtil;
import org.sparkproject.jetty.util.thread.AutoLock;

public class Invoker
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(Invoker.class);
    private ContextHandler _contextHandler;
    private ServletHandler _servletHandler;
    private Map<String, String> _parameters;
    private boolean _nonContextServlets;
    private boolean _verbose;

    public void init() {
        ServletContext servletContext = this.getServletContext();
        ServletContextHandler.ServletContextApi servletContextApi = (ServletContextHandler.ServletContextApi)servletContext;
        this._servletHandler = servletContextApi.getContext().getServletContextHandler().getServletHandler();
        this._contextHandler = servletContextApi.getContextHandler();
        Enumeration e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String param = (String)e.nextElement();
            String value = this.getInitParameter(param);
            String lvalue = value.toLowerCase(Locale.ENGLISH);
            if ("nonContextServlets".equals(param)) {
                boolean bl = this._nonContextServlets = !value.isEmpty() && lvalue.startsWith("t");
            }
            if ("verbose".equals(param)) {
                this._verbose = !value.isEmpty() && lvalue.startsWith("t");
                continue;
            }
            if (this._parameters == null) {
                this._parameters = new HashMap<String, String>();
            }
            this._parameters.put(param, value);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletHolder holder;
        String servlet;
        String pathInfo;
        String servletPath;
        boolean included;
        block27: {
            included = false;
            servletPath = (String)request.getAttribute("jakarta.servlet.include.servlet_path");
            if (servletPath == null) {
                servletPath = request.getServletPath();
            } else {
                included = true;
            }
            pathInfo = (String)request.getAttribute("jakarta.servlet.include.path_info");
            if (pathInfo == null) {
                pathInfo = request.getPathInfo();
            }
            if ((servlet = pathInfo) == null || servlet.length() <= 1) {
                response.sendError(404);
                return;
            }
            int i0 = servlet.charAt(0) == '/' ? 1 : 0;
            int i1 = servlet.indexOf(47, i0);
            servlet = i1 < 0 ? servlet.substring(i0) : servlet.substring(i0, i1);
            ServletHolder[] holders = this._servletHandler.getServlets();
            holder = this.getHolder(holders, servlet);
            if (holder != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding servlet mapping for named servlet: {}:{}/*", (Object)servlet, (Object)URIUtil.addPaths(servletPath, servlet));
                }
                ServletMapping mapping = new ServletMapping();
                mapping.setServletName(servlet);
                mapping.setPathSpec(URIUtil.addPaths(servletPath, servlet) + "/*");
                this._servletHandler.setServletMappings(ArrayUtil.addToArray(this._servletHandler.getServletMappings(), mapping, ServletMapping.class));
            } else {
                if (servlet.endsWith(".class")) {
                    servlet = servlet.substring(0, servlet.length() - 6);
                }
                if (servlet.isEmpty()) {
                    response.sendError(404);
                    return;
                }
                try (AutoLock ignored = this._servletHandler.lock();){
                    ServletHandler.MappedServlet invokerEntry = this._servletHandler.getMappedServlet(servletPath);
                    String path = URIUtil.addPaths(servletPath, servlet);
                    ServletHandler.MappedServlet entry = this._servletHandler.getMappedServlet(path);
                    if (entry != null && !entry.equals(invokerEntry)) {
                        holder = entry.getServletHolder();
                        break block27;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Making new servlet={}  with path={}/*", (Object)servlet, (Object)path);
                    }
                    holder = this._servletHandler.addServletWithMapping(servlet, path + "/*");
                    if (this._parameters != null) {
                        holder.setInitParameters(this._parameters);
                    }
                    try {
                        holder.start();
                    }
                    catch (Exception e) {
                        LOG.debug("Unable to start {}", (Object)holder, (Object)e);
                        throw new UnavailableException(e.toString());
                    }
                    if (!this._nonContextServlets) {
                        Servlet s = holder.getServlet();
                        if (this._contextHandler.getClassLoader() != s.getClass().getClassLoader()) {
                            try {
                                holder.stop();
                            }
                            catch (Exception e) {
                                LOG.trace("IGNORED", (Throwable)e);
                            }
                            LOG.warn("Dynamic servlet {} not loaded from context {}", (Object)s, (Object)request.getContextPath());
                            throw new UnavailableException("Not in context");
                        }
                    }
                    if (this._verbose && LOG.isDebugEnabled()) {
                        LOG.debug("Dynamic load '{}' at {}", (Object)servlet, (Object)path);
                    }
                }
            }
        }
        if (holder != null) {
            holder.prepare((ServletRequest)request, (ServletResponse)response);
            holder.handle((ServletRequest)new InvokedRequest(request, included, servlet, servletPath, pathInfo), (ServletResponse)response);
        } else {
            LOG.info("Can't find holder for servlet: {}", (Object)servlet);
            response.sendError(404);
        }
    }

    private ServletHolder getHolder(ServletHolder[] holders, String servlet) {
        if (holders == null) {
            return null;
        }
        ServletHolder holder = null;
        for (int i = 0; holder == null && i < holders.length; ++i) {
            if (!holders[i].getName().equals(servlet)) continue;
            holder = holders[i];
        }
        return holder;
    }

    static class InvokedRequest
    extends HttpServletRequestWrapper {
        String _servletPath;
        String _pathInfo;
        boolean _included;

        InvokedRequest(HttpServletRequest request, boolean included, String name, String servletPath, String pathInfo) {
            super(request);
            this._included = included;
            this._servletPath = URIUtil.addPaths(servletPath, name);
            this._pathInfo = pathInfo.substring(name.length() + 1);
            if (this._pathInfo.isEmpty()) {
                this._pathInfo = null;
            }
        }

        public String getServletPath() {
            if (this._included) {
                return super.getServletPath();
            }
            return this._servletPath;
        }

        public String getPathInfo() {
            if (this._included) {
                return super.getPathInfo();
            }
            return this._pathInfo;
        }

        public Object getAttribute(String name) {
            if (this._included) {
                return switch (name) {
                    case "jakarta.servlet.include.request_uri" -> URIUtil.addPaths(URIUtil.addPaths(this.getContextPath(), this._servletPath), this._pathInfo);
                    case "jakarta.servlet.include.path_info" -> this._pathInfo;
                    case "jakarta.servlet.include.servlet_path" -> this._servletPath;
                    default -> super.getAttribute(name);
                };
            }
            return super.getAttribute(name);
        }
    }
}

