/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.utils;

import java.io.Serializable;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.PipelineAnalysisContext;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.connect.proto.UserContext;
import org.sparkproject.connect.protobuf.Any;
import org.sparkproject.connect.protobuf.Message;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class PipelineAnalysisContextUtils$ {
    public static final PipelineAnalysisContextUtils$ MODULE$ = new PipelineAnalysisContextUtils$();

    private <T extends Message> Seq<T> getExtensionList(Buffer<Any> extensions, ClassTag<T> evidence$1) {
        Class cls = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass();
        return ((IterableOnceOps)extensions.collect((PartialFunction)new Serializable(cls){
            private static final long serialVersionUID = 0L;
            private final Class cls$1;

            public final <A1 extends Any, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.is(this.cls$1)) {
                    return (B1)A1.unpack(this.cls$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Any x1) {
                Any any = x1;
                return any.is(this.cls$1);
            }
            {
                this.cls$1 = cls$1;
            }
        })).toSeq();
    }

    private Seq<PipelineAnalysisContext> getPipelineAnalysisContextList(UserContext userContext) {
        Buffer userContextExtensions = CollectionConverters$.MODULE$.ListHasAsScala(userContext.getExtensionsList()).asScala();
        return this.getExtensionList((Buffer<Any>)userContextExtensions, ClassTag$.MODULE$.apply(PipelineAnalysisContext.class));
    }

    public boolean hasPipelineAnalysisContext(UserContext userContext) {
        return this.getPipelineAnalysisContextList(userContext).nonEmpty();
    }

    public boolean isInsidePipelineFlowFunction(UserContext userContext) {
        return this.getPipelineAnalysisContextList(userContext).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.hasFlowName()));
    }

    public boolean isUnsupportedEagerExecutionInsideFlowFunction(UserContext userContext, Plan plan) {
        if (!this.isInsidePipelineFlowFunction(userContext)) {
            return false;
        }
        Plan.OpTypeCase opTypeCase = plan.getOpTypeCase();
        if (Plan.OpTypeCase.ROOT.equals(opTypeCase)) {
            return true;
        }
        if (Plan.OpTypeCase.COMMAND.equals(opTypeCase)) {
            Set commandAllowList = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Command.CommandTypeCase[]{Command.CommandTypeCase.SQL_COMMAND}));
            return !commandAllowList.contains((Object)plan.getCommand().getCommandTypeCase());
        }
        return true;
    }

    private PipelineAnalysisContextUtils$() {
    }
}

