/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.ReadOnlyException;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.internal.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.internal.Prim;
import org.apache.datasketches.memory.internal.Util;

public interface WritableMemory
extends Memory {
    public static WritableMemory writableWrap(ByteBuffer byteBuffer) {
        return WritableMemory.writableWrap(byteBuffer, byteBuffer.order(), null);
    }

    public static WritableMemory writableWrap(ByteBuffer byteBuffer, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyException("byteBuffer must be writable.");
        }
        return BaseWritableMemoryImpl.wrapByteBuffer(byteBuffer, false, byteOrder, memReqSvr);
    }

    public static WritableMemory writableMap(File file) throws IOException {
        return WritableMemory.writableMap(file, 0L, file.length(), ByteOrder.nativeOrder());
    }

    public static WritableMemory writableMap(File file, long fileOffsetBytes, long capacityBytes, ByteOrder byteOrder) throws IOException {
        if (!file.canWrite()) {
            throw new ReadOnlyException("file must be writable.");
        }
        return BaseWritableMemoryImpl.wrapMap(file, fileOffsetBytes, capacityBytes, false, byteOrder);
    }

    public static WritableMemory allocateDirect(long capacityBytes) {
        return WritableMemory.allocateDirect(capacityBytes, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory allocateDirect(long capacityBytes, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        return BaseWritableMemoryImpl.wrapDirect(capacityBytes, byteOrder, memReqSvr);
    }

    default public WritableMemory writableRegion(long offsetBytes, long capacityBytes) {
        return this.writableRegion(offsetBytes, capacityBytes, this.getTypeByteOrder());
    }

    public WritableMemory writableRegion(long var1, long var3, ByteOrder var5);

    default public WritableBuffer asWritableBuffer() {
        return this.asWritableBuffer(this.getTypeByteOrder());
    }

    public WritableBuffer asWritableBuffer(ByteOrder var1);

    public static WritableMemory allocate(int capacityBytes) {
        return WritableMemory.allocate(capacityBytes, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory allocate(int capacityBytes, ByteOrder byteOrder) {
        return WritableMemory.allocate(capacityBytes, byteOrder, null);
    }

    public static WritableMemory allocate(int capacityBytes, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        byte[] arr = new byte[capacityBytes];
        Util.negativeCheck(capacityBytes, "capacityBytes");
        return WritableMemory.writableWrap(arr, 0, capacityBytes, byteOrder, memReqSvr);
    }

    public static WritableMemory writableWrap(byte[] array) {
        return WritableMemory.writableWrap(array, 0, array.length, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(byte[] array, ByteOrder byteOrder) {
        return WritableMemory.writableWrap(array, 0, array.length, byteOrder, null);
    }

    public static WritableMemory writableWrap(byte[] array, int offsetBytes, int lengthBytes, ByteOrder byteOrder) {
        return WritableMemory.writableWrap(array, offsetBytes, lengthBytes, byteOrder, null);
    }

    public static WritableMemory writableWrap(byte[] array, int offsetBytes, int lengthBytes, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        return BaseWritableMemoryImpl.wrapHeapArray(array, offsetBytes, lengthBytes, false, byteOrder, memReqSvr);
    }

    public static WritableMemory writableWrap(char[] array) {
        Objects.requireNonNull(array, "array must be non-null");
        long lengthBytes = array.length << (int)Prim.CHAR.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, false, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(short[] array) {
        Objects.requireNonNull(array, "array must be non-null");
        long lengthBytes = array.length << (int)Prim.SHORT.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, false, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(int[] array) {
        Objects.requireNonNull(array, "array must be non-null");
        long lengthBytes = array.length << (int)Prim.INT.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, false, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(long[] array) {
        Objects.requireNonNull(array, "array must be non-null");
        long lengthBytes = array.length << (int)Prim.LONG.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, false, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(float[] array) {
        Objects.requireNonNull(array, "array must be non-null");
        long lengthBytes = array.length << (int)Prim.FLOAT.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, false, ByteOrder.nativeOrder(), null);
    }

    public static WritableMemory writableWrap(double[] array) {
        Objects.requireNonNull(array, "array must be non-null");
        long lengthBytes = array.length << (int)Prim.DOUBLE.shift();
        return BaseWritableMemoryImpl.wrapHeapArray(array, 0L, lengthBytes, false, ByteOrder.nativeOrder(), null);
    }

    public void putBoolean(long var1, boolean var3);

    public void putByte(long var1, byte var3);

    public void putByteArray(long var1, byte[] var3, int var4, int var5);

    public void putChar(long var1, char var3);

    public void putCharArray(long var1, char[] var3, int var4, int var5);

    public void putDouble(long var1, double var3);

    public void putDoubleArray(long var1, double[] var3, int var4, int var5);

    public void putFloat(long var1, float var3);

    public void putFloatArray(long var1, float[] var3, int var4, int var5);

    public void putInt(long var1, int var3);

    public void putIntArray(long var1, int[] var3, int var4, int var5);

    public void putLong(long var1, long var3);

    public void putLongArray(long var1, long[] var3, int var4, int var5);

    public void putShort(long var1, short var3);

    public void putShortArray(long var1, short[] var3, int var4, int var5);

    public Object getArray();

    public void clear();

    public void clear(long var1, long var3);

    public void clearBits(long var1, byte var3);

    public void fill(byte var1);

    public void fill(long var1, long var3, byte var5);

    public void setBits(long var1, byte var3);
}

