/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BitwiseCount$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the number of bits that are set in the argument expr as an unsigned 64-bit integer, or NULL if the argument is NULL.", examples="\n    Examples:\n      > SELECT _FUNC_(0);\n       0\n  ", since="3.0.0", group="bitwise_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001\u0002\u000f\u001e\u0001*B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\")!\n\u0001C\u0001\u0017\")a\n\u0001C!\u001f\")1\u000b\u0001C!)\")a\f\u0001C!?\")1\r\u0001C!I\")Q\u000e\u0001C!]\")q\u000e\u0001C!a\")a\u0010\u0001C)\u007f\"9\u00111\u0002\u0001\u0005R\u00055\u0001\"CA\n\u0001\u0005\u0005I\u0011AA\u000b\u0011%\tI\u0002AI\u0001\n\u0003\tY\u0002C\u0005\u00022\u0001\t\t\u0011\"\u0011\u00024!I\u00111\t\u0001\u0002\u0002\u0013\u0005\u0011Q\t\u0005\n\u0003\u001b\u0002\u0011\u0011!C\u0001\u0003\u001fB\u0011\"!\u0016\u0001\u0003\u0003%\t%a\u0016\t\u0013\u0005\u0015\u0004!!A\u0005\u0002\u0005\u001d\u0004\"CA6\u0001\u0005\u0005I\u0011IA7\u0011%\t\t\bAA\u0001\n\u0003\n\u0019hB\u0005\u0002\u0018v\t\t\u0011#\u0001\u0002\u001a\u001aAA$HA\u0001\u0012\u0003\tY\n\u0003\u0004K-\u0011\u0005\u00111\u0017\u0005\tGZ\t\t\u0011\"\u0012\u00026\"I\u0011q\u0017\f\u0002\u0002\u0013\u0005\u0015\u0011\u0018\u0005\n\u0003{3\u0012\u0011!CA\u0003\u007fC\u0011\"a3\u0017\u0003\u0003%I!!4\u0003\u0019\tKGo^5tK\u000e{WO\u001c;\u000b\u0005yy\u0012aC3yaJ,7o]5p]NT!\u0001I\u0011\u0002\u0011\r\fG/\u00197zgRT!AI\u0012\u0002\u0007M\fHN\u0003\u0002%K\u0005)1\u000f]1sW*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u00160ea\u0002\"\u0001L\u0017\u000e\u0003uI!AL\u000f\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"\u0001\f\u0019\n\u0005Ej\"!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t9\u0001K]8ek\u000e$\bCA\u001dB\u001d\tQtH\u0004\u0002<}5\tAH\u0003\u0002>S\u00051AH]8pizJ\u0011!N\u0005\u0003\u0001R\nq\u0001]1dW\u0006<W-\u0003\u0002C\u0007\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001\tN\u0001\u0006G\"LG\u000eZ\u000b\u0002\rB\u0011AfR\u0005\u0003\u0011v\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"\"\u0001T'\u0011\u00051\u0002\u0001\"\u0002#\u0004\u0001\u00041\u0015A\u00048vY2Le\u000e^8mKJ\fg\u000e^\u000b\u0002!B\u00111'U\u0005\u0003%R\u0012qAQ8pY\u0016\fg.\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0016\t\u0004sYC\u0016BA,D\u0005\r\u0019V-\u001d\t\u00033rk\u0011A\u0017\u0006\u00037\u0006\nQ\u0001^=qKNL!!\u0018.\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\u0001\u0004\"!W1\n\u0005\tT&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u001a\t\u0003M*t!a\u001a5\u0011\u0005m\"\u0014BA55\u0003\u0019\u0001&/\u001a3fM&\u00111\u000e\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%$\u0014A\u00039sKR$\u0018PT1nKV\tQ-A\u0005e_\u001e+gnQ8eKR\u0019\u0011o\u001e?\u0011\u0005I,X\"A:\u000b\u0005Ql\u0012aB2pI\u0016<WM\\\u0005\u0003mN\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006q&\u0001\r!_\u0001\u0004GRD\bC\u0001:{\u0013\tY8O\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000buL\u0001\u0019A9\u0002\u0005\u00154\u0018\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003BA\u0001\u0003\u000f\u00012aMA\u0002\u0013\r\t)\u0001\u000e\u0002\u0004\u0003:L\bbBA\u0005\u0015\u0001\u0007\u0011\u0011A\u0001\u0006S:\u0004X\u000f^\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u00071\u000by\u0001\u0003\u0004\u0002\u0012-\u0001\rAR\u0001\t]\u0016<8\t[5mI\u0006!1m\u001c9z)\ra\u0015q\u0003\u0005\b\t2\u0001\n\u00111\u0001G\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\b+\u0007\u0019\u000byb\u000b\u0002\u0002\"A!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012!C;oG\",7m[3e\u0015\r\tY\u0003N\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0018\u0003K\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0007\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0012\u0001\u00026bm\u0006L1a[A\u001d\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\u0005E\u00024\u0003\u0013J1!a\u00135\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t!!\u0015\t\u0013\u0005M\u0003#!AA\u0002\u0005\u001d\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002ZA1\u00111LA1\u0003\u0003i!!!\u0018\u000b\u0007\u0005}C'\u0001\u0006d_2dWm\u0019;j_:LA!a\u0019\u0002^\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\u0001\u0016\u0011\u000e\u0005\n\u0003'\u0012\u0012\u0011!a\u0001\u0003\u0003\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011QGA8\u0011%\t\u0019fEA\u0001\u0002\u0004\t9%\u0001\u0004fcV\fGn\u001d\u000b\u0004!\u0006U\u0004\"CA*)\u0005\u0005\t\u0019AA\u0001QM\u0001\u0011\u0011PA@\u0003\u0003\u000b))a\"\u0002\f\u00065\u0015\u0011SAJ!\ra\u00131P\u0005\u0004\u0003{j\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u0007\u000b\u0011qC0G+:\u001bu\fK3yaJL\u0003%\f\u0011SKR,(O\\:!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!E&$8\u000f\t;iCR\u0004\u0013M]3!g\u0016$\b%\u001b8!i\",\u0007%\u0019:hk6,g\u000e\u001e\u0011fqB\u0014\b%Y:!C:\u0004SO\\:jO:,G\r\t\u001c5[\tLG\u000fI5oi\u0016<WM\u001d\u0017!_J\u0004c*\u0016'MA%4\u0007\u0005\u001e5fA\u0005\u0014x-^7f]R\u0004\u0013n\u001d\u0011O+2ce&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tI)\u0001\u001b\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QAJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019\u000bA\u0001\nQa]5oG\u0016\f#!a$\u0002\u000bMr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005U\u0015!\u00042ji^L7/Z0gk:\u001c7/\u0001\u0007CSR<\u0018n]3D_VtG\u000f\u0005\u0002--M)a#!(\u0002*B1\u0011qTAS\r2k!!!)\u000b\u0007\u0005\rF'A\u0004sk:$\u0018.\\3\n\t\u0005\u001d\u0016\u0011\u0015\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004\u0003BAV\u0003ck!!!,\u000b\t\u0005=\u0016QH\u0001\u0003S>L1AQAW)\t\tI\n\u0006\u0002\u00026\u0005)\u0011\r\u001d9msR\u0019A*a/\t\u000b\u0011K\u0002\u0019\u0001$\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011YAd!\u0011\u0019\u00141\u0019$\n\u0007\u0005\u0015GG\u0001\u0004PaRLwN\u001c\u0005\t\u0003\u0013T\u0012\u0011!a\u0001\u0019\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005=\u0007\u0003BA\u001c\u0003#LA!a5\u0002:\t1qJ\u00196fGR\u0004")
public class BitwiseCount
extends UnaryExpression
implements ExpectsInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(BitwiseCount x$0) {
        return BitwiseCount$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitwiseCount, A> g) {
        return BitwiseCount$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, BitwiseCount> compose(Function1<A$, Expression> g) {
        return BitwiseCount$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegralType$.MODULE$, BooleanType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public String toString() {
        return "bit_count(" + this.child() + ")";
    }

    @Override
    public String prettyName() {
        return "bit_count";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.child().dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "(" + c + ") ? 1 : 0");
        }
        return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "java.lang.Long.bitCount(" + c + ")");
    }

    @Override
    public Object nullSafeEval(Object input) {
        DataType dataType = this.child().dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            if (BoxesRunTime.unboxToBoolean((Object)input)) {
                return BoxesRunTime.boxToInteger((int)1);
            }
            return BoxesRunTime.boxToInteger((int)0);
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToByte((Object)input)));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToShort((Object)input)));
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToInt((Object)input)));
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToInteger((int)Long.bitCount(BoxesRunTime.unboxToLong((Object)input)));
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public BitwiseCount withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public BitwiseCount copy(Expression child) {
        return new BitwiseCount(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitwiseCount";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitwiseCount;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitwiseCount)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitwiseCount bitwiseCount = (BitwiseCount)x$1;
        Expression expression = this.child();
        Expression expression2 = bitwiseCount.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitwiseCount.canEqual(this)) return false;
        return true;
    }

    public BitwiseCount(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

