/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.Serializable;
import java.io.Writer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalStringStyles$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.catalyst.util.TimeFormatter;
import org.apache.spark.sql.catalyst.util.TimeFormatter$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.VariantVal;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h\u0001\u0002\u0012$\u0001AB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!Aq\t\u0001B\u0001B\u0003%\u0001\nC\u0003M\u0001\u0011\u0005Q*\u0002\u0003S\u0001\u0011\u0019\u0006\u0002\u00032\u0001\u0011\u000b\u0007I\u0011B2\t\u0011%\u0004\u0001R1A\u0005\n)D\u0001b\u001b\u0001\t\u0006\u0004%IA\u001b\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u0019Q\b\u0001)A\u0005]\"91\u0010\u0001b\u0001\n\u0013a\bbBA\t\u0001\u0001\u0006I! \u0005\n\u0003'\u0001!\u0019!C\u0005\u0003+A\u0001\"a\t\u0001A\u0003%\u0011q\u0003\u0005\n\u0003K\u0001!\u0019!C\u0005\u0003+A\u0001\"a\n\u0001A\u0003%\u0011q\u0003\u0005\n\u0003S\u0001!\u0019!C\u0005\u0003WA\u0001\"a\r\u0001A\u0003%\u0011Q\u0006\u0005\n\u0003k\u0001!\u0019!C\u0005\u0003oA\u0001\"a\u0010\u0001A\u0003%\u0011\u0011\b\u0005\b\u0003\u0003\u0002A\u0011BA\"\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013Bq!!\u0016\u0001\t\u0013\t9\u0006C\u0004\u0002\u0006\u0002!I!a\"\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\"9\u0011Q\u0014\u0001\u0005\n\u0005}\u0005bBA\\\u0001\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003w\u0003A\u0011AA]\u0011\u001d\ti\f\u0001C\u0001\u0003\u007fCq!!0\u0001\t\u0003\t\u0019\rC\u0004\u0002>\u0002!\t!a2\t\u000f\u0005u\u0006\u0001\"\u0001\u0002L\"9\u0011q\u001c\u0001\u0005\u0002\u0005e&\u0001\u0005&bG.\u001cxN\\$f]\u0016\u0014\u0018\r^8s\u0015\t!S%\u0001\u0003kg>t'B\u0001\u0014(\u0003!\u0019\u0017\r^1msN$(B\u0001\u0015*\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003U-\nQa\u001d9be.T!\u0001L\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0013aA8sO\u000e\u00011C\u0001\u00012!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u0019\te.\u001f*fM\u0006AA-\u0019;b)f\u0004X\r\u0005\u0002:y5\t!H\u0003\u0002<O\u0005)A/\u001f9fg&\u0011QH\u000f\u0002\t\t\u0006$\u0018\rV=qK\u00061qO]5uKJ\u0004\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\u0005%|'\"\u0001#\u0002\t)\fg/Y\u0005\u0003\r\u0006\u0013aa\u0016:ji\u0016\u0014\u0018aB8qi&|gn\u001d\t\u0003\u0013*k\u0011aI\u0005\u0003\u0017\u000e\u00121BS*P\u001d>\u0003H/[8og\u00061A(\u001b8jiz\"BAT(Q#B\u0011\u0011\n\u0001\u0005\u0006o\u0011\u0001\r\u0001\u000f\u0005\u0006}\u0011\u0001\ra\u0010\u0005\u0006\u000f\u0012\u0001\r\u0001\u0013\u0002\f-\u0006dW/Z,sSR,'\u000fE\u00033)Zcv,\u0003\u0002Vg\tIa)\u001e8di&|gN\r\t\u0003/jk\u0011\u0001\u0017\u0006\u00033\u0016\n1\"\u001a=qe\u0016\u001c8/[8og&\u00111\f\u0017\u0002\u0013'B,7-[1mSj,GmR3ui\u0016\u00148\u000f\u0005\u00023;&\u0011al\r\u0002\u0004\u0013:$\bC\u0001\u001aa\u0013\t\t7G\u0001\u0003V]&$\u0018\u0001\u0005:p_R4\u0015.\u001a7e/JLG/\u001a:t+\u0005!\u0007c\u0001\u001afO&\u0011am\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003Q\u0016i\u0011\u0001A\u0001\u0011CJ\u0014X\t\\3nK:$xK]5uKJ,\u0012aZ\u0001\u0011[\u0006\u0004X\t\\3nK:$xK]5uKJ\f1aZ3o+\u0005q\u0007CA8y\u001b\u0005\u0001(BA9s\u0003\u0011\u0019wN]3\u000b\u0005M$\u0018a\u00026bG.\u001cxN\u001c\u0006\u0003kZ\f\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u0003]\f1aY8n\u0013\tI\bOA\u0007Kg>tw)\u001a8fe\u0006$xN]\u0001\u0005O\u0016t\u0007%A\u0007mS:,7+\u001a9be\u0006$xN]\u000b\u0002{B\u0019a0a\u0003\u000f\u0007}\f9\u0001E\u0002\u0002\u0002Mj!!a\u0001\u000b\u0007\u0005\u0015q&\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0013\u0019\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u000e\u0005=!AB*ue&twMC\u0002\u0002\nM\na\u0002\\5oKN+\u0007/\u0019:bi>\u0014\b%\u0001\nuS6,7\u000f^1na\u001a{'/\\1ui\u0016\u0014XCAA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000fK\u0005!Q\u000f^5m\u0013\u0011\t\t#a\u0007\u0003%QKW.Z:uC6\u0004hi\u001c:nCR$XM]\u0001\u0014i&lWm\u001d;b[B4uN]7biR,'\u000fI\u0001\u0016i&lWm\u001d;b[BtEK\u0017$pe6\fG\u000f^3s\u0003Y!\u0018.\\3ti\u0006l\u0007O\u0014+[\r>\u0014X.\u0019;uKJ\u0004\u0013!\u00043bi\u00164uN]7biR,'/\u0006\u0002\u0002.A!\u0011\u0011DA\u0018\u0013\u0011\t\t$a\u0007\u0003\u001b\u0011\u000bG/\u001a$pe6\fG\u000f^3s\u00039!\u0017\r^3G_Jl\u0017\r\u001e;fe\u0002\nQ\u0002^5nK\u001a{'/\\1ui\u0016\u0014XCAA\u001d!\u0011\tI\"a\u000f\n\t\u0005u\u00121\u0004\u0002\u000e)&lWMR8s[\u0006$H/\u001a:\u0002\u001dQLW.\u001a$pe6\fG\u000f^3sA\u0005QQ.Y6f/JLG/\u001a:\u0015\u0007\u001d\f)\u0005C\u00038+\u0001\u0007\u0001(A\u0006xe&$Xm\u00142kK\u000e$HcA0\u0002L!A\u0011Q\n\f\u0005\u0002\u0004\ty%A\u0001g!\u0011\u0011\u0014\u0011K0\n\u0007\u0005M3G\u0001\u0005=Eft\u0017-\\3?\u0003-9(/\u001b;f\r&,G\u000eZ:\u0015\u000f}\u000bI&!\u001a\u0002p!9\u00111L\fA\u0002\u0005u\u0013a\u0001:poB!\u0011qLA1\u001b\u0005)\u0013bAA2K\tY\u0011J\u001c;fe:\fGNU8x\u0011\u001d\t9g\u0006a\u0001\u0003S\naa]2iK6\f\u0007cA\u001d\u0002l%\u0019\u0011Q\u000e\u001e\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002r]\u0001\r!a\u001d\u0002\u0019\u0019LW\r\u001c3Xe&$XM]:\u0011\u000b\u0005U\u0014qP4\u000f\t\u0005]\u00141\u0010\b\u0005\u0003\u0003\tI(C\u00015\u0013\r\tihM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t)a!\u0003\u0007M+\u0017OC\u0002\u0002~M\n!b\u001e:ji\u0016\f%O]1z)\ry\u0016\u0011\u0012\u0005\t\u0003\u001bBB\u00111\u0001\u0002P\u0005qqO]5uK\u0006\u0013(/Y=ECR\fG#B0\u0002\u0010\u0006e\u0005bBAI3\u0001\u0007\u00111S\u0001\u0006CJ\u0014\u0018-\u001f\t\u0005\u00033\t)*\u0003\u0003\u0002\u0018\u0006m!!C!se\u0006LH)\u0019;b\u0011\u0019\tY*\u0007a\u0001O\u0006Ya-[3mI^\u0013\u0018\u000e^3s\u000319(/\u001b;f\u001b\u0006\u0004H)\u0019;b)\u001dy\u0016\u0011UAV\u0003kCq!a)\u001b\u0001\u0004\t)+A\u0002nCB\u0004B!!\u0007\u0002(&!\u0011\u0011VA\u000e\u0005\u001di\u0015\r\u001d#bi\u0006Dq!!,\u001b\u0001\u0004\ty+A\u0004nCB$\u0016\u0010]3\u0011\u0007e\n\t,C\u0002\u00024j\u0012q!T1q)f\u0004X\r\u0003\u0004\u0002\u001cj\u0001\raZ\u0001\u0006G2|7/\u001a\u000b\u0002?\u0006)a\r\\;tQ\u0006)qO]5uKR\u0019q,!1\t\u000f\u0005mS\u00041\u0001\u0002^Q\u0019q,!2\t\u000f\u0005Ee\u00041\u0001\u0002\u0014R\u0019q,!3\t\u000f\u0005\rv\u00041\u0001\u0002&R\u0019q,!4\t\u000f\u0005=\u0007\u00051\u0001\u0002R\u0006\ta\u000f\u0005\u0003\u0002T\u0006mWBAAk\u0015\rY\u0014q\u001b\u0006\u0004\u00033L\u0013AB;og\u00064W-\u0003\u0003\u0002^\u0006U'A\u0003,be&\fg\u000e\u001e,bY\u0006yqO]5uK2Kg.Z#oI&tw\r")
public class JacksonGenerator {
    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters;
    private Function2<SpecializedGetters, Object, BoxedUnit> arrElementWriter;
    private Function2<SpecializedGetters, Object, BoxedUnit> mapElementWriter;
    private final DataType dataType;
    private final JSONOptions options;
    private final JsonGenerator gen;
    private final String lineSeparator;
    private final TimestampFormatter timestampFormatter;
    private final TimestampFormatter timestampNTZFormatter;
    private final DateFormatter dateFormatter;
    private final TimeFormatter timeFormatter;
    private volatile byte bitmap$0;

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters$lzycompute() {
        JacksonGenerator jacksonGenerator = this;
        synchronized (jacksonGenerator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                DataType dataType2 = this.dataType;
                if (!(dataType2 instanceof StructType)) {
                    throw QueryExecutionErrors$.MODULE$.initialTypeNotTargetDataTypeError(this.dataType, StructType$.MODULE$.simpleString());
                }
                StructType structType = (StructType)dataType2;
                this.rootFieldWriters = (Function2[])((IterableOnceOps)((IterableOps)structType.map((Function1 & Serializable)x$1 -> x$1.dataType())).map((Function1 & Serializable)dataType -> this.makeWriter((DataType)dataType))).toArray(ClassTag$.MODULE$.apply(Function2.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.rootFieldWriters;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.rootFieldWriters$lzycompute();
        }
        return this.rootFieldWriters;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> arrElementWriter$lzycompute() {
        JacksonGenerator jacksonGenerator = this;
        synchronized (jacksonGenerator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Function2<SpecializedGetters, Object, BoxedUnit> function2;
                DataType dataType = this.dataType;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    function2 = this.makeWriter(arrayType.elementType());
                } else if (dataType instanceof StructType ? true : dataType instanceof MapType) {
                    function2 = this.makeWriter(this.dataType);
                } else {
                    throw QueryExecutionErrors$.MODULE$.initialTypeNotTargetDataTypesError(this.dataType);
                }
                this.arrElementWriter = function2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.arrElementWriter;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> arrElementWriter() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.arrElementWriter$lzycompute();
        }
        return this.arrElementWriter;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> mapElementWriter$lzycompute() {
        JacksonGenerator jacksonGenerator = this;
        synchronized (jacksonGenerator) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                DataType dataType = this.dataType;
                if (!(dataType instanceof MapType)) {
                    throw QueryExecutionErrors$.MODULE$.initialTypeNotTargetDataTypeError(this.dataType, MapType$.MODULE$.simpleString());
                }
                MapType mapType = (MapType)dataType;
                this.mapElementWriter = this.makeWriter(mapType.valueType());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.mapElementWriter;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> mapElementWriter() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.mapElementWriter$lzycompute();
        }
        return this.mapElementWriter;
    }

    private JsonGenerator gen() {
        return this.gen;
    }

    private String lineSeparator() {
        return this.lineSeparator;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private DateFormatter dateFormatter() {
        return this.dateFormatter;
    }

    private TimeFormatter timeFormatter() {
        return this.timeFormatter;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeWriter(DataType dataType2) {
        while (true) {
            DataType dataType3;
            if (NullType$.MODULE$.equals(dataType3 = dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (BooleanType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (ByteType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (ShortType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$4(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (IntegerType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$5(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (LongType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$6(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (FloatType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$7(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (DoubleType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$8(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof StringType) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$9(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (TimestampType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$10(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (TimestampNTZType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$11(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (DateType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$12(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (CalendarIntervalType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$13(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof YearMonthIntervalType) {
                YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType3;
                byte start = yearMonthIntervalType.startField();
                byte end = yearMonthIntervalType.endField();
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$14(this, start, end, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof DayTimeIntervalType) {
                DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType3;
                byte start = dayTimeIntervalType.startField();
                byte end = dayTimeIntervalType.endField();
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$15(this, start, end, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof TimeType) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$16(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (BinaryType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$17(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dataType3;
                return (Function2 & Serializable)(row, ordinal) -> {
                    JacksonGenerator.$anonfun$makeWriter$18(this, decimalType, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof StructType) {
                StructType structType = (StructType)dataType3;
                Seq fieldWriters = (Seq)((IterableOps)structType.map((Function1 & Serializable)x$2 -> x$2.dataType())).map((Function1 & Serializable)dataType -> this.makeWriter((DataType)dataType));
                return (Function2 & Serializable)(row, ordinal) -> {
                    this.writeObject((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeFields(row.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), structType.length()), structType, (Seq<Function2<SpecializedGetters, Object, BoxedUnit>>)fieldWriters));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType3;
                Function2<SpecializedGetters, Object, BoxedUnit> elementWriter = this.makeWriter(arrayType.elementType());
                return (Function2 & Serializable)(row, ordinal) -> {
                    this.writeArray((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeArrayData(row.getArray(BoxesRunTime.unboxToInt((Object)ordinal)), (Function2<SpecializedGetters, Object, BoxedUnit>)elementWriter));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof MapType) {
                MapType mapType = (MapType)dataType3;
                Function2<SpecializedGetters, Object, BoxedUnit> valueWriter = this.makeWriter(mapType.valueType());
                return (Function2 & Serializable)(row, ordinal) -> {
                    this.writeObject((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeMapData(row.getMap(BoxesRunTime.unboxToInt((Object)ordinal)), mapType, (Function2<SpecializedGetters, Object, BoxedUnit>)valueWriter));
                    return BoxedUnit.UNIT;
                };
            }
            if (VariantType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    this.write(row.getVariant(BoxesRunTime.unboxToInt((Object)ordinal)));
                    return BoxedUnit.UNIT;
                };
            }
            if (!(dataType3 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType3;
            dataType2 = userDefinedType.sqlType();
        }
        return (Function2 & Serializable)(row, ordinal) -> JacksonGenerator.$anonfun$makeWriter$28(dataType2, row, BoxesRunTime.unboxToInt((Object)ordinal));
    }

    private void writeObject(Function0<BoxedUnit> f) {
        this.gen().writeStartObject();
        f.apply$mcV$sp();
        this.gen().writeEndObject();
    }

    private void writeFields(InternalRow row, StructType schema, Seq<Function2<SpecializedGetters, Object, BoxedUnit>> fieldWriters) {
        for (int i = 0; i < row.numFields(); ++i) {
            Object object;
            StructField field = schema.apply(i);
            if (!row.isNullAt(i)) {
                this.gen().writeFieldName(field.name());
                object = ((Function2)fieldWriters.apply(i)).apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i));
                continue;
            }
            if (!this.options.ignoreNullFields() || this.options.writeNullIfWithDefaultValue() && field.getExistenceDefaultValue().isDefined()) {
                this.gen().writeFieldName(field.name());
                this.gen().writeNull();
            }
            object = BoxedUnit.UNIT;
        }
    }

    private void writeArray(Function0<BoxedUnit> f) {
        this.gen().writeStartArray();
        f.apply$mcV$sp();
        this.gen().writeEndArray();
    }

    private void writeArrayData(ArrayData array, Function2<SpecializedGetters, Object, BoxedUnit> fieldWriter) {
        for (int i = 0; i < array.numElements(); ++i) {
            Object object;
            if (!array.isNullAt(i)) {
                object = fieldWriter.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i));
                continue;
            }
            this.gen().writeNull();
            object = BoxedUnit.UNIT;
        }
    }

    private void writeMapData(MapData map, MapType mapType, Function2<SpecializedGetters, Object, BoxedUnit> fieldWriter) {
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        for (int i = 0; i < map.numElements(); ++i) {
            Object object;
            this.gen().writeFieldName(keyArray.get(i, mapType.keyType()).toString());
            if (!valueArray.isNullAt(i)) {
                object = fieldWriter.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i));
                continue;
            }
            this.gen().writeNull();
            object = BoxedUnit.UNIT;
        }
    }

    public void close() {
        this.gen().close();
    }

    public void flush() {
        this.gen().flush();
    }

    public void write(InternalRow row) {
        this.writeObject((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            ArraySeq x$1 = ArrayImplicits$.MODULE$.SparkArrayOps(this.rootFieldWriters()).toImmutableArraySeq();
            InternalRow x$2 = row;
            StructType x$3 = (StructType)$this.dataType;
            this.writeFields(x$2, x$3, (Seq<Function2<SpecializedGetters, Object, BoxedUnit>>)x$1);
        });
    }

    public void write(ArrayData array) {
        this.writeArray((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeArrayData(array, this.arrElementWriter()));
    }

    public void write(MapData map) {
        this.writeObject((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Function2<SpecializedGetters, Object, BoxedUnit> x$1 = this.mapElementWriter();
            MapData x$2 = map;
            MapType x$3 = (MapType)$this.dataType;
            this.writeMapData(x$2, x$3, x$1);
        });
    }

    public void write(VariantVal v) {
        this.gen().writeRawValue(v.toJson(this.options.zoneId()));
    }

    public void writeLineEnding() {
        this.gen().writeRaw(this.lineSeparator());
    }

    public static final /* synthetic */ void $anonfun$makeWriter$1(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNull();
    }

    public static final /* synthetic */ void $anonfun$makeWriter$2(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeBoolean(row.getBoolean(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$3(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber((short)row.getByte(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$4(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getShort(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$5(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getInt(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$6(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$7(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getFloat(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$8(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getDouble(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$9(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeString(row.getUTF8String(ordinal).toString());
    }

    public static final /* synthetic */ void $anonfun$makeWriter$10(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        String timestampString = $this.timestampFormatter().format(row.getLong(ordinal));
        $this.gen().writeString(timestampString);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$11(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        String timestampString = $this.timestampNTZFormatter().format(DateTimeUtils$.MODULE$.microsToLocalDateTime(row.getLong(ordinal)));
        $this.gen().writeString(timestampString);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$12(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        String dateString = $this.dateFormatter().format(row.getInt(ordinal));
        $this.gen().writeString(dateString);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$13(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeString(row.getInterval(ordinal).toString());
    }

    public static final /* synthetic */ void $anonfun$makeWriter$14(JacksonGenerator $this, byte start$1, byte end$1, SpecializedGetters row, int ordinal) {
        String ymString = IntervalUtils$.MODULE$.toYearMonthIntervalString(row.getInt(ordinal), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start$1, end$1);
        $this.gen().writeString(ymString);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$15(JacksonGenerator $this, byte start$2, byte end$2, SpecializedGetters row, int ordinal) {
        String dtString = IntervalUtils$.MODULE$.toDayTimeIntervalString(row.getLong(ordinal), IntervalStringStyles$.MODULE$.ANSI_STYLE(), start$2, end$2);
        $this.gen().writeString(dtString);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$16(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        String timeString = $this.timeFormatter().format(row.getLong(ordinal));
        $this.gen().writeString(timeString);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$17(JacksonGenerator $this, SpecializedGetters row, int ordinal) {
        $this.gen().writeBinary(row.getBinary(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$18(JacksonGenerator $this, DecimalType x19$1, SpecializedGetters row, int ordinal) {
        $this.gen().writeNumber(row.getDecimal(ordinal, x19$1.precision(), x19$1.scale()).toJavaBigDecimal());
    }

    public static final /* synthetic */ Nothing$ $anonfun$makeWriter$28(DataType dataType$1, SpecializedGetters row, int ordinal) {
        Object v = row.get(ordinal, dataType$1);
        throw QueryExecutionErrors$.MODULE$.failToConvertValueToJsonError(v, v.getClass(), dataType$1);
    }

    public JacksonGenerator(DataType dataType, Writer writer, JSONOptions options) {
        this.dataType = dataType;
        this.options = options;
        Predef$.MODULE$.require(dataType instanceof StructType || dataType instanceof MapType || dataType instanceof ArrayType || dataType instanceof VariantType, (Function0 & Serializable)() -> "JacksonGenerator only supports to be initialized with a " + StructType$.MODULE$.simpleString() + ", " + MapType$.MODULE$.simpleString() + ", " + ArrayType$.MODULE$.simpleString() + " or " + VariantType$.MODULE$.simpleString() + " but got " + $this.dataType.catalogString());
        JsonGenerator generator = new JsonFactory().createGenerator(writer).setRootValueSeparator(null);
        Object object = options.pretty() ? generator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter(PrettyPrinter.DEFAULT_SEPARATORS.withRootSeparator(""))) : BoxedUnit.UNIT;
        Object object2 = options.writeNonAsciiCharacterAsCodePoint() ? generator.setHighestNonEscapedChar(127) : BoxedUnit.UNIT;
        this.gen = generator;
        this.lineSeparator = options.lineSeparatorInWrite();
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormatInWrite(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInWrite(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false, true);
        this.dateFormatter = DateFormatter$.MODULE$.apply(options.dateFormatInWrite(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), false);
        String string = options.timeFormatInWrite();
        String string2 = TimeFormatter$.MODULE$.defaultPattern();
        String string3 = string;
        this.timeFormatter = !(string2 != null ? !string2.equals(string3) : string3 != null) ? TimeFormatter$.MODULE$.getFractionFormatter() : TimeFormatter$.MODULE$.apply(string, false);
    }
}

