/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util.geo;

import java.util.List;
import org.apache.spark.sql.catalyst.util.geo.GeoTypeId;
import org.apache.spark.sql.catalyst.util.geo.GeometryModel;
import org.apache.spark.sql.catalyst.util.geo.Point;

class MultiPoint
extends GeometryModel {
    private final List<Point> points;

    MultiPoint(List<Point> points, int srid, boolean hasZ, boolean hasM) {
        super(GeoTypeId.MULTI_POINT, srid, hasZ, hasM);
        this.points = points;
    }

    List<Point> getPoints() {
        return this.points;
    }

    int getNumGeometries() {
        return this.points.size();
    }

    @Override
    boolean isEmpty() {
        return this.points.isEmpty() || this.points.stream().allMatch(Point::isEmpty);
    }

    @Override
    int getDimensionCount() {
        return 2 + (this.hasZ ? 1 : 0) + (this.hasM ? 1 : 0);
    }
}

