/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.PortForward;
import io.fabric8.kubernetes.client.ServiceToURLProvider;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.client.utils.URLUtils;
import java.net.InetAddress;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class ServiceOperationsImpl
extends HasMetadataOperation<Service, ServiceList, ServiceResource<Service>>
implements ServiceResource<Service> {
    public static final String EXTERNAL_NAME = "ExternalName";

    public ServiceOperationsImpl(Client client) {
        this(HasMetadataOperationsImpl.defaultContext(client));
    }

    private ServiceOperationsImpl(OperationContext context) {
        super(context.withPlural("services"), Service.class, ServiceList.class);
    }

    @Override
    public ServiceOperationsImpl newInstance(OperationContext context) {
        return new ServiceOperationsImpl(context);
    }

    @Override
    public Service waitUntilReady(long amount, TimeUnit timeUnit) {
        long started = System.nanoTime();
        super.waitUntilReady(amount, timeUnit);
        long alreadySpent = System.nanoTime() - started;
        long remaining = Math.max(10000L, timeUnit.toNanos(amount) - alreadySpent);
        Resource endpointsOperation = (Resource)((NonNamespaceOperation)this.context.getClient().resources(Endpoints.class, EndpointsList.class).inNamespace(this.context.getNamespace())).withName(this.context.getName());
        endpointsOperation.waitUntilReady(remaining, TimeUnit.MILLISECONDS);
        return (Service)this.get();
    }

    public String getURL(String portName) {
        String clusterIP = ((Service)this.getItemOrRequireFromServer()).getSpec().getClusterIP();
        if ("None".equals(clusterIP)) {
            throw new IllegalStateException("Service: " + ((Service)this.getItemOrRequireFromServer()).getMetadata().getName() + " in namespace " + this.namespace + " is head-less. Search for endpoints instead");
        }
        return this.getUrlHelper(portName);
    }

    private String getUrlHelper(String portName) {
        List<ServiceToURLProvider> servicesList = ServiceOperationsImpl.getServiceToURLProviders(Thread.currentThread().getContextClassLoader());
        if (servicesList.isEmpty()) {
            servicesList = ServiceOperationsImpl.getServiceToURLProviders(this.getClass().getClassLoader());
        }
        Collections.sort(servicesList, new ServiceToUrlSortComparator());
        for (ServiceToURLProvider serviceToURLProvider : servicesList) {
            String url = serviceToURLProvider.getURL((Service)this.getItemOrRequireFromServer(), portName, this.namespace, (KubernetesClient)this.context.getClient().adapt(KubernetesClient.class));
            if (url == null || !URLUtils.isValidURL((String)url)) continue;
            return url;
        }
        return null;
    }

    private static List<ServiceToURLProvider> getServiceToURLProviders(ClassLoader loader) {
        Iterator<ServiceToURLProvider> iterator = ServiceLoader.load(ServiceToURLProvider.class, loader).iterator();
        ArrayList<ServiceToURLProvider> servicesList = new ArrayList<ServiceToURLProvider>();
        while (iterator.hasNext()) {
            servicesList.add(iterator.next());
        }
        return servicesList;
    }

    private Pod matchingPod(Service item) {
        Map labels = item.getSpec().getSelector();
        PodList list = (PodList)((BaseOperation)new PodOperationsImpl(this.context.getClient()).inNamespace(item.getMetadata().getNamespace())).withLabels((Map<String, String>)labels).list();
        return (Pod)list.getItems().stream().findFirst().orElseThrow(() -> new IllegalStateException("Could not find matching pod for service:" + String.valueOf(item) + "."));
    }

    public PortForward portForward(int port, ReadableByteChannel in, WritableByteChannel out) {
        Service s = (Service)this.requireFromServer();
        Pod m = this.matchingPod(s);
        return ((PodResource)((BaseOperation)new PodOperationsImpl(this.context.getClient()).inNamespace(m.getMetadata().getNamespace())).withName(m.getMetadata().getName())).portForward(this.getTargetPortAsInt(s, port), in, out);
    }

    public LocalPortForward portForward(int port) {
        return this.portForward(port, 0);
    }

    public LocalPortForward portForward(int port, int localPort) {
        return this.portForward(port, null, localPort);
    }

    public LocalPortForward portForward(int port, InetAddress localInetAddress, int localPort) {
        Service s = (Service)this.requireFromServer();
        Pod m = this.matchingPod(s);
        return ((PodResource)((BaseOperation)new PodOperationsImpl(this.context.getClient()).inNamespace(m.getMetadata().getNamespace())).withName(m.getMetadata().getName())).portForward(this.getTargetPortAsInt(s, port), localInetAddress, localPort);
    }

    private int getTargetPortAsInt(Service service, int port) {
        return service.getSpec().getPorts().stream().filter(p -> p.getPort().equals(port)).map(p -> p.getTargetPort().getIntVal()).filter(Objects::nonNull).findFirst().orElse(port);
    }

    @Override
    protected Service modifyItemForReplaceOrPatch(Supplier<Service> currentSupplier, Service item) {
        if (!this.isExternalNameService(item)) {
            Service old = currentSupplier.get();
            return ((ServiceBuilder)((ServiceFluent.SpecNested)new ServiceBuilder(item).editSpec().withClusterIP(old.getSpec().getClusterIP())).endSpec()).build();
        }
        return item;
    }

    private boolean isExternalNameService(Service item) {
        if (item.getSpec() != null && item.getSpec().getType() != null) {
            return item.getSpec().getType().equals(EXTERNAL_NAME);
        }
        return false;
    }

    public static final class ServiceToUrlSortComparator
    implements Comparator<ServiceToURLProvider> {
        @Override
        public int compare(ServiceToURLProvider first, ServiceToURLProvider second) {
            return first.getPriority() - second.getPriority();
        }
    }
}

