/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.classic;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.sql.Observation;
import org.apache.spark.sql.Observation$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.plans.logical.CollectMetrics;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.execution.QueryExecution;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005I4Q!\u0003\u0006\u0001\u0019QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I!\b\u0005\u0006C\u0001!\tA\t\u0005\bK\u0001\u0011\r\u0011\"\u0003'\u0011\u00191\u0005\u0001)A\u0005O!)q\t\u0001C\u0001\u0011\")q\t\u0001C\u0001?\")1\r\u0001C\u0001I\"1\u0001\u000e\u0001C\u0001\u0019%\u0014!c\u00142tKJ4\u0018\r^5p]6\u000bg.Y4fe*\u00111\u0002D\u0001\bG2\f7o]5d\u0015\tia\"A\u0002tc2T!a\u0004\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\n\u0003\u0001U\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0017aB:fgNLwN\\\u0002\u0001!\tqr$D\u0001\u000b\u0013\t\u0001#B\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003G\u0011\u0002\"A\b\u0001\t\u000bm\u0011\u0001\u0019A\u000f\u0002\u0019=\u00147/\u001a:wCRLwN\\:\u0016\u0003\u001d\u0002B\u0001K\u00182\u00056\t\u0011F\u0003\u0002+W\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u00051j\u0013\u0001B;uS2T\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021S\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\tY\u0011DgP\u0005\u0003g]\u0011a\u0001V;qY\u0016\u0014\u0004CA\u001b=\u001d\t1$\b\u0005\u00028/5\t\u0001H\u0003\u0002:9\u00051AH]8pizJ!aO\f\u0002\rA\u0013X\rZ3g\u0013\tidH\u0001\u0004TiJLgn\u001a\u0006\u0003w]\u0001\"A\u0006!\n\u0005\u0005;\"\u0001\u0002'p]\u001e\u0004\"a\u0011#\u000e\u00031I!!\u0012\u0007\u0003\u0017=\u00137/\u001a:wCRLwN\\\u0001\u000e_\n\u001cXM\u001d<bi&|gn\u001d\u0011\u0002\u0011I,w-[:uKJ$2!\u0013'O!\t1\"*\u0003\u0002L/\t!QK\\5u\u0011\u0015iU\u00011\u0001C\u0003-y'm]3sm\u0006$\u0018n\u001c8\t\u000b=+\u0001\u0019\u0001)\u0002\u0005\u0011\u001c\bGA)W!\rq\"\u000bV\u0005\u0003'*\u0011q\u0001R1uCN,G\u000f\u0005\u0002V-2\u0001A!C,O\u0003\u0003\u0005\tQ!\u0001Y\u0005\ryF%M\t\u00033r\u0003\"A\u0006.\n\u0005m;\"a\u0002(pi\"Lgn\u001a\t\u0003-uK!AX\f\u0003\u0007\u0005s\u0017\u0010F\u0002JA\u0006DQ!\u0014\u0004A\u0002\tCQA\u0019\u0004A\u0002}\n1\u0002Z1uC\u001a\u0013\u0018-\\3JI\u0006\u0019r-\u001a;Pe:+wo\u00142tKJ4\u0018\r^5p]R\u0019!)Z4\t\u000b\u0019<\u0001\u0019\u0001\u001b\u0002\t9\fW.\u001a\u0005\u0006E\u001e\u0001\raP\u0001\fiJL8i\\7qY\u0016$X\r\u0006\u0002JU\")1\u000e\u0003a\u0001Y\u0006\u0011\u0011/\u001a\t\u0003[Bl\u0011A\u001c\u0006\u0003_2\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005Et'AD)vKJLX\t_3dkRLwN\u001c")
public class ObservationManager {
    private final ConcurrentHashMap<Tuple2<String, Object>, Observation> observations = new ConcurrentHashMap();

    private ConcurrentHashMap<Tuple2<String, Object>, Observation> observations() {
        return this.observations;
    }

    public void register(Observation observation, Dataset<?> ds) {
        if (ds.isStreaming()) {
            throw new IllegalArgumentException("Observation does not support streaming Datasets.This is because there will be multiple observed metrics as microbatches are constructed. Please register a StreamingQueryListener and get the metric for each microbatch in QueryProgressEvent.progress, or use query.lastProgress or query.recentProgress.");
        }
        this.register(observation, ds.id());
    }

    public void register(Observation observation, long dataFrameId) {
        observation.markRegistered();
        this.observations().putIfAbsent((Tuple2<String, Object>)new Tuple2((Object)observation.name(), (Object)BoxesRunTime.boxToLong((long)dataFrameId)), observation);
    }

    public Observation getOrNewObservation(String name, long dataFrameId) {
        return this.observations().computeIfAbsent((Tuple2<String, Object>)new Tuple2((Object)name, (Object)BoxesRunTime.boxToLong((long)dataFrameId)), x$1 -> {
            Observation observation = Observation$.MODULE$.apply(name);
            observation.markRegistered();
            return observation;
        });
    }

    public void tryComplete(QueryExecution qe) {
        LazyRef lazyObservedMetrics$lzy = new LazyRef();
        qe.logical().foreachWithSubqueriesAndPruning((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.containsPattern(TreePattern$.MODULE$.COLLECT_METRICS())), (Function1 & Serializable)x0$1 -> {
            ObservationManager.$anonfun$tryComplete$3(this, lazyObservedMetrics$lzy, qe, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private static final /* synthetic */ Try lazyObservedMetrics$lzycompute$1(LazyRef lazyObservedMetrics$lzy$1, QueryExecution qe$1) {
        Try try_;
        LazyRef lazyRef = lazyObservedMetrics$lzy$1;
        synchronized (lazyRef) {
            try_ = lazyObservedMetrics$lzy$1.initialized() ? (Try)lazyObservedMetrics$lzy$1.value() : (Try)lazyObservedMetrics$lzy$1.initialize((Object)Try$.MODULE$.apply((Function0 & Serializable)() -> qe$1.observedMetrics()));
        }
        return try_;
    }

    private static final Try lazyObservedMetrics$1(LazyRef lazyObservedMetrics$lzy$1, QueryExecution qe$1) {
        if (lazyObservedMetrics$lzy$1.initialized()) {
            return (Try)lazyObservedMetrics$lzy$1.value();
        }
        return ObservationManager.lazyObservedMetrics$lzycompute$1(lazyObservedMetrics$lzy$1, qe$1);
    }

    public static final /* synthetic */ void $anonfun$tryComplete$3(ObservationManager $this, LazyRef lazyObservedMetrics$lzy$1, QueryExecution qe$1, LogicalPlan x0$1) {
        LogicalPlan logicalPlan2 = x0$1;
        if (logicalPlan2 instanceof CollectMetrics) {
            CollectMetrics collectMetrics = (CollectMetrics)logicalPlan2;
            Observation observation = $this.observations().remove(new Tuple2((Object)collectMetrics.name(), (Object)BoxesRunTime.boxToLong((long)collectMetrics.dataframeId())));
            if (observation != null) {
                Try metricsResult = ObservationManager.lazyObservedMetrics$1(lazyObservedMetrics$lzy$1, qe$1).map((Function1 & Serializable)x$3 -> (Row)x$3.getOrElse((Object)collectMetrics.name(), (Function0 & Serializable)() -> Row$.MODULE$.empty()));
                observation.setMetricsAndNotify(metricsResult);
                return;
            }
            return;
        }
    }

    public ObservationManager(SparkSession session) {
    }
}

