/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.checkpointing;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.zip.CheckedInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckedSequentialInputStream;
import org.apache.spark.sql.execution.streaming.checkpointing.Checksum;
import org.apache.spark.sql.execution.streaming.checkpointing.Checksum$;
import org.apache.spark.sql.execution.streaming.checkpointing.ChecksumCheckpointFileManager$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005Q4A\u0001F\u000b\u0001I!A1\u0007\u0001BC\u0002\u0013%A\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u0003&\u0011!1\u0004A!A!\u0002\u00139\u0004\u0002\u0003\u001e\u0001\u0005\u000b\u0007I\u0011\u0002\u001b\t\u0011m\u0002!\u0011!Q\u0001\n\u0015B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%I!\u0010\u0005\t\r\u0002\u0011\t\u0011)A\u0005}!)q\t\u0001C\u0001\u0011\"9q\n\u0001a\u0001\n\u0013\u0001\u0006bB+\u0001\u0001\u0004%IA\u0016\u0005\u00079\u0002\u0001\u000b\u0015B)\t\u000f\u0005\u0004\u0001\u0019!C\u0005!\"9!\r\u0001a\u0001\n\u0013\u0019\u0007BB3\u0001A\u0003&\u0011\u000bC\u0003h\u0001\u0011\u0005\u0003\u000eC\u0003j\u0001\u0011\u0005\u0001\u000eC\u0003k\u0001\u0011%\u0001\u000eC\u0003l\u0001\u0011%\u0001\u000eC\u0006m\u0001A\u0005\u0019\u0011!A\u0005\n!l'!G\"iK\u000e\\7/^7G'\u0012\u000bG/Y%oaV$8\u000b\u001e:fC6T!AF\f\u0002\u001b\rDWmY6q_&tG/\u001b8h\u0015\tA\u0012$A\u0005tiJ,\u0017-\\5oO*\u0011!dG\u0001\nKb,7-\u001e;j_:T!\u0001H\u000f\u0002\u0007M\fHN\u0003\u0002\u001f?\u0005)1\u000f]1sW*\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h\u0007\u0001\u00192\u0001A\u0013.!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0002gg*\u0011!fH\u0001\u0007Q\u0006$wn\u001c9\n\u00051:#!\u0005$T\t\u0006$\u0018-\u00138qkR\u001cFO]3b[B\u0011a&M\u0007\u0002_)\u0011\u0001'H\u0001\tS:$XM\u001d8bY&\u0011!g\f\u0002\b\u0019><w-\u001b8h\u0003)i\u0017-\u001b8TiJ,\u0017-\\\u000b\u0002K\u0005YQ.Y5o'R\u0014X-Y7!\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005\u0019B\u0014BA\u001d(\u0005\u0011\u0001\u0016\r\u001e5\u0002-\u0015D\b/Z2uK\u0012\u001c\u0005.Z2lgVl7\u000b\u001e:fC6\fq#\u001a=qK\u000e$X\rZ\"iK\u000e\\7/^7TiJ,\u0017-\u001c\u0011\u0002\u0015QD'/Z1e!>|G.F\u0001?!\tyD)D\u0001A\u0015\t\t%)\u0001\u0006d_:\u001cWO\u001d:f]RT\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\u0002\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0017QD'/Z1e!>|G\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b%[E*\u0014(\u0011\u0005)\u0003Q\"A\u000b\t\u000bMB\u0001\u0019A\u0013\t\u000bYB\u0001\u0019A\u001c\t\u000biB\u0001\u0019A\u0013\t\u000bqB\u0001\u0019\u0001 \u0002\u0011Y,'/\u001b4jK\u0012,\u0012!\u0015\t\u0003%Nk\u0011AQ\u0005\u0003)\n\u0013qAQ8pY\u0016\fg.\u0001\u0007wKJLg-[3e?\u0012*\u0017\u000f\u0006\u0002X5B\u0011!\u000bW\u0005\u00033\n\u0013A!\u00168ji\"91LCA\u0001\u0002\u0004\t\u0016a\u0001=%c\u0005Ia/\u001a:jM&,G\r\t\u0015\u0003\u0017y\u0003\"AU0\n\u0005\u0001\u0014%\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\r\rdwn]3e\u0003)\u0019Gn\\:fI~#S-\u001d\u000b\u0003/\u0012DqaW\u0007\u0002\u0002\u0003\u0007\u0011+A\u0004dY>\u001cX\r\u001a\u0011)\u00059q\u0016!B2m_N,G#A,\u0002A\rdwn]3XSRDw.\u001e;DQ\u0016\u001c7n];n-\u0016\u0014\u0018NZ5dCRLwN\\\u0001\u000eG2|7/Z%oi\u0016\u0014h.\u00197\u0002\u001dY,'/\u001b4z\u0007\",7m[:v[\u0006Y1/\u001e9fe\u0012\u001aGn\\:f\u0013\t9g.\u0003\u0002pa\n\tb)\u001b7uKJLe\u000e];u'R\u0014X-Y7\u000b\u0005E\u0014\u0018AA5p\u0015\u0005\u0019\u0018\u0001\u00026bm\u0006\u0004")
public class ChecksumFSDataInputStream
extends FSDataInputStream
implements Logging {
    private final FSDataInputStream mainStream;
    private final Path path;
    private final FSDataInputStream expectedChecksumStream;
    private final ExecutionContext threadPool;
    private volatile boolean verified;
    private volatile boolean closed;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private /* synthetic */ void super$close() {
        super.close();
    }

    private FSDataInputStream mainStream() {
        return this.mainStream;
    }

    private FSDataInputStream expectedChecksumStream() {
        return this.expectedChecksumStream;
    }

    private ExecutionContext threadPool() {
        return this.threadPool;
    }

    private boolean verified() {
        return this.verified;
    }

    private void verified_$eq(boolean x$1) {
        this.verified = x$1;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    public void close() {
        if (!this.closed()) {
            try {
                this.verifyChecksum();
            }
            finally {
                this.closeInternal();
            }
            return;
        }
    }

    public void closeWithoutChecksumVerification() {
        if (!this.closed()) {
            this.logDebug(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Closing file ", " without checksum verification"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, $this.path)}))));
            this.closeInternal();
            return;
        }
    }

    private void closeInternal() {
        this.closed_$eq(true);
        Future mainCloseFuture = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.super$close(), this.threadPool());
        Future checksumCloseFuture = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.expectedChecksumStream().close(), this.threadPool());
        ChecksumCheckpointFileManager$.MODULE$.awaitResult(mainCloseFuture, (Duration)Duration$.MODULE$.Inf());
        ChecksumCheckpointFileManager$.MODULE$.awaitResult(checksumCloseFuture, (Duration)Duration$.MODULE$.Inf());
    }

    private void verifyChecksum() {
        if (!this.verified()) {
            IntRef remainingBytesRead = IntRef.create((int)0);
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = super.read(buffer)) != -1) {
                remainingBytesRead.elem += bytesRead;
            }
            long computedFileSize = this.mainStream().getPos();
            if (remainingBytesRead.elem > 0) {
                this.logDebug(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"File ", " was not read till the end by reader. "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, $this.path)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Finished reading the rest of the file for checksum verification. "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Remaining bytes read: ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_BYTES, BoxesRunTime.boxToInteger((int)remainingBytesRead$1.elem))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"total size: ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_BYTES, BoxesRunTime.boxToLong((long)computedFileSize))})))));
            }
            String expectedChecksumJson = Source$.MODULE$.fromInputStream((InputStream)this.expectedChecksumStream(), StandardCharsets.UTF_8.name()).mkString();
            Checksum expectedChecksum = Checksum$.MODULE$.fromJson(expectedChecksumJson);
            int computedChecksumValue = (int)((CheckedInputStream)this.in).getChecksum().getValue();
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Verifying checksum for file ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, $this.path)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"remainingBytesRead= ", ". "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_BYTES, BoxesRunTime.boxToInteger((int)remainingBytesRead$1.elem))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Computed(checksum= ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CHECKSUM, BoxesRunTime.boxToInteger((int)computedChecksumValue))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fileSize= ", ")."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_BYTES, BoxesRunTime.boxToLong((long)computedFileSize))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Checksum file content: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CHECKSUM, expectedChecksumJson)})))));
            this.verified_$eq(true);
            if (expectedChecksum.value() != computedChecksumValue || expectedChecksum.mainFileSize() != computedFileSize) {
                throw QueryExecutionErrors$.MODULE$.checkpointFileChecksumVerificationFailed(this.path, expectedChecksum.mainFileSize(), expectedChecksum.value(), computedFileSize, computedChecksumValue);
            }
            return;
        }
    }

    public ChecksumFSDataInputStream(FSDataInputStream mainStream, Path path, FSDataInputStream expectedChecksumStream, ExecutionContext threadPool) {
        this.mainStream = mainStream;
        this.path = path;
        this.expectedChecksumStream = expectedChecksumStream;
        this.threadPool = threadPool;
        super((InputStream)new CheckedSequentialInputStream((InputStream)mainStream));
        Logging.$init$((Logging)this);
        this.verified = false;
        this.closed = false;
    }
}

