/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkThrowable;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$;
import org.apache.spark.sql.execution.datasources.v2.state.metadata.StateMetadataPartitionReader;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqBase;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqLog;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqMetadata$;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqMetadataBase;
import org.apache.spark.sql.execution.streaming.operators.stateful.StatefulOperatorStateInfo$;
import org.apache.spark.sql.execution.streaming.operators.stateful.StatefulOperatorsUtils$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.StateVariableType$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateOperatorProperties;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateOperatorProperties$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateVariableInfo;
import org.apache.spark.sql.execution.streaming.runtime.StreamingCheckpointConstants$;
import org.apache.spark.sql.execution.streaming.runtime.StreamingQueryCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.InMemoryStateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadata;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadataV2;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StatePartitionAllColumnFamiliesWriter;
import org.apache.spark.sql.execution.streaming.state.StatePartitionWriterColumnFamilyInfo;
import org.apache.spark.sql.execution.streaming.state.StateRewriter$;
import org.apache.spark.sql.execution.streaming.state.StateRewriterErrors$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaMetadata;
import org.apache.spark.sql.execution.streaming.state.StateSchemaMetadata$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCheckpointInfo;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreMetadata;
import org.apache.spark.sql.execution.streaming.state.StateStoreMetadataV1;
import org.apache.spark.sql.execution.streaming.state.StateStoreMetadataV2;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.SerializableConfiguration$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0005e\u0001B\u0012%\u0001MB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"A\u0011\n\u0001B\u0001B\u0003%a\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!1\u0006A!A!\u0002\u00139\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u0011\r\u0004!\u0011!Q\u0001\n\u0011D\u0001b\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\u0007\u007f\u0002!\t!!\u0001\t\u0013\u0005]\u0001A1A\u0005\n\u0005e\u0001bBA\u000e\u0001\u0001\u0006Ia\u0013\u0005\n\u0003;\u0001!\u0019!C\u0005\u0003?A\u0001\"a\f\u0001A\u0003%\u0011\u0011\u0005\u0005\u000b\u0003c\u0001\u0001R1A\u0005\n\u0005M\u0002BCA\u001b\u0001!\u0015\r\u0011\"\u0003\u00024!9\u0011q\u0007\u0001\u0005\u0002\u0005e\u0002bBA&\u0001\u0011%\u0011Q\n\u0005\b\u0003?\u0002A\u0011BA\u001d\u0011\u001d\t\t\u0007\u0001C\u0005\u0003GBq!!7\u0001\t\u0013\tY\u000eC\u0004\u0002n\u0002!I!a<\t\u000f\u0005U\b\u0001\"\u0003\u0002x\"I!\u0011\u0003\u0001\u0012\u0002\u0013%!1\u0003\u0005\b\u0005S\u0001A\u0011\u0002B\u0016\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{AqA!\u0012\u0001\t\u0013\u00119\u0005C\u0004\u0003L\u0001!IA!\u0014\t\u000f\tu\u0003\u0001\"\u0003\u0003`\u001dI!q\r\u0013\u0002\u0002#\u0005!\u0011\u000e\u0004\tG\u0011\n\t\u0011#\u0001\u0003l!1qP\bC\u0001\u0005[B\u0011Ba\u001c\u001f#\u0003%\tA!\u001d\t\u0013\tUd$%A\u0005\u0002\t]\u0004\"\u0003B>=E\u0005I\u0011\u0001B?\u00055\u0019F/\u0019;f%\u0016<(/\u001b;fe*\u0011QEJ\u0001\u0006gR\fG/\u001a\u0006\u0003O!\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005%R\u0013!C3yK\u000e,H/[8o\u0015\tYC&A\u0002tc2T!!\f\u0018\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0002\u0014AB1qC\u000eDWMC\u00012\u0003\ry'oZ\u0002\u0001'\r\u0001AG\u000f\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\u0007\u0003:L(+\u001a4\u0011\u0005mrT\"\u0001\u001f\u000b\u0005ub\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005}b$a\u0002'pO\u001eLgnZ\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003\u0005\u000ek\u0011AK\u0005\u0003\t*\u0012Ab\u00159be.\u001cVm]:j_:\f1B]3bI\n\u000bGo\u00195JIB\u0011QgR\u0005\u0003\u0011Z\u0012A\u0001T8oO\u0006aqO]5uK\n\u000bGo\u00195JI\u0006Q\"/Z:pYZ,Gm\u00115fG.\u0004x.\u001b8u\u0019>\u001c\u0017\r^5p]B\u0011Aj\u0015\b\u0003\u001bF\u0003\"A\u0014\u001c\u000e\u0003=S!\u0001\u0015\u001a\u0002\rq\u0012xn\u001c;?\u0013\t\u0011f'\u0001\u0004Qe\u0016$WMZ\u0005\u0003)V\u0013aa\u0015;sS:<'B\u0001*7\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u00031vk\u0011!\u0017\u0006\u00035n\u000bAaY8oM*\u0011ALL\u0001\u0007Q\u0006$wn\u001c9\n\u0005yK&!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0010sK\u0006$'+Z:pYZ,Gm\u00115fG.\u0004x.\u001b8u\u0019>\u001c\u0017\r^5p]B\u0019Q'Y&\n\u0005\t4$AB(qi&|g.A\u0007ue\u0006t7OZ8s[\u001a+hn\u0019\t\u0004k\u0005,\u0007\u0003B\u001bgQ\"L!a\u001a\u001c\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA5u\u001d\tQ'O\u0004\u0002lc:\u0011A\u000e\u001d\b\u0003[>t!A\u00148\n\u0003EJ!a\f\u0019\n\u00055r\u0013BA\u0016-\u0013\t\u0019(&A\u0004qC\u000e\\\u0017mZ3\n\u0005U4(!\u0003#bi\u00064%/Y7f\u0015\t\u0019(&A\fxe&$Xm\u00115fG.\u0004x.\u001b8u\u001b\u0016$\u0018\rZ1uCB\u0019Q'Y=\u0011\u0005ilX\"A>\u000b\u0005q4\u0013a\u0002:v]RLW.Z\u0005\u0003}n\u0014\u0001e\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018p\u00115fG.\u0004x.\u001b8u\u001b\u0016$\u0018\rZ1uC\u00061A(\u001b8jiz\"\"#a\u0001\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0002\u0016A\u0019\u0011Q\u0001\u0001\u000e\u0003\u0011BQ\u0001Q\u0005A\u0002\u0005CQ!R\u0005A\u0002\u0019CQ!S\u0005A\u0002\u0019CQAS\u0005A\u0002-CQAV\u0005A\u0002]CqaX\u0005\u0011\u0002\u0003\u0007\u0001\rC\u0004d\u0013A\u0005\t\u0019\u00013\t\u000f]L\u0001\u0013!a\u0001q\u0006I2\r[3dWB|\u0017N\u001c;M_\u000e\fG/[8o\r>\u0014(+Z1e+\u0005Y\u0015AG2iK\u000e\\\u0007o\\5oi2{7-\u0019;j_:4uN\u001d*fC\u0012\u0004\u0013!E:uCR,'k\\8u\u0019>\u001c\u0017\r^5p]V\u0011\u0011\u0011\u0005\t\u0005\u0003G\ti#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0012\u0001\u00026bm\u0006L1\u0001VA\u0013\u0003I\u0019H/\u0019;f%>|G\u000fT8dCRLwN\u001c\u0011\u0002\u001f]\u0014\u0018\u000e^3DQ\u0016\u001c7\u000e]8j]R,\u0012!_\u0001\u000fe\u0016\fGm\u00115fG.\u0004x.\u001b8u\u0003\r\u0011XO\u001c\u000b\u0003\u0003w\u0001B!N1\u0002>A1A*a\u0010G\u0003\u0007J1!!\u0011V\u0005\ri\u0015\r\u001d\t\u0006k\u0005\u0015\u0013\u0011J\u0005\u0004\u0003\u000f2$!B!se\u0006L\b\u0003B\u001b\u0002F-\u000b\u0001%\u001a=ue\u0006\u001cGo\u00115fG.\u0004x.\u001b8u\u0013\u0012\u001c\b+\u001a:QCJ$\u0018\u000e^5p]R!\u00111HA(\u0011\u001d\t\t&\u0005a\u0001\u0003'\nqb\u00195fG.\u0004x.\u001b8u\u0013:4wn\u001d\t\u0007\u0019\u0006}b)!\u0016\u0011\u000bU\n)%a\u0016\u0011\u000bU\n)%!\u0017\u0011\t\u0005\u0015\u00111L\u0005\u0004\u0003;\"#\u0001G*uCR,7\u000b^8sK\u000eCWmY6q_&tG/\u00138g_\u0006Y!/\u001e8J]R,'O\\1m\u00031\u0011Xm\u001e:ji\u0016\u001cFo\u001c:f)9\t9&!\u001a\u0002p\u0005e\u00141QAP\u0003\u007fCq!a\u001a\u0014\u0001\u0004\tI'\u0001\u0006pa6+G/\u00193bi\u0006\u0004B!!\u0002\u0002l%\u0019\u0011Q\u000e\u0013\u0003+=\u0003XM]1u_J\u001cF/\u0019;f\u001b\u0016$\u0018\rZ1uC\"9\u0011\u0011O\nA\u0002\u0005M\u0014AE:uCR,7\u000b^8sK6+G/\u00193bi\u0006\u0004B!!\u0002\u0002v%\u0019\u0011q\u000f\u0013\u0003%M#\u0018\r^3Ti>\u0014X-T3uC\u0012\fG/\u0019\u0005\b\u0003w\u001a\u0002\u0019AA?\u0003%\u0019Ho\u001c:f\u0007>tg\r\u0005\u0003\u0002\u0006\u0005}\u0014bAAAI\tq1\u000b^1uKN#xN]3D_:4\u0007bBAC'\u0001\u0007\u0011qQ\u0001\u0014Q\u0006$wn\u001c9D_:4'I]8bI\u000e\f7\u000f\u001e\t\u0007\u0003\u0013\u000by)a%\u000e\u0005\u0005-%bAAGY\u0005I!M]8bI\u000e\f7\u000f^\u0005\u0005\u0003#\u000bYIA\u0005Ce>\fGmY1tiB!\u0011QSAN\u001b\t\t9JC\u0002\u0002\u001a2\nA!\u001e;jY&!\u0011QTAL\u0005e\u0019VM]5bY&T\u0018M\u00197f\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005\u00056\u00031\u0001\u0002$\u0006\u00012\u000f^8sKN\u001b\u0007.Z7b\r&dWm\u001d\t\u0007\u0003K\u000bi+a-\u000f\t\u0005\u001d\u00161\u0016\b\u0004\u001d\u0006%\u0016\"A\u001c\n\u0005M4\u0014\u0002BAX\u0003c\u0013A\u0001T5ti*\u00111O\u000e\t\u0005\u0003k\u000bY,\u0004\u0002\u00028*\u0019\u0011\u0011X.\u0002\u0005\u0019\u001c\u0018\u0002BA_\u0003o\u0013A\u0001U1uQ\"9\u0011\u0011Y\nA\u0002\u0005\r\u0017AD:uCR,g+\u0019:t\u0013\u001a$vo\u001d\t\u0007\u0019\u0006}2*!2\u0011\t\u0005\u001d\u0017Q[\u0007\u0003\u0003\u0013TA!a3\u0002N\u0006\u0011BO]1og\u001a|'/\\<ji\"\u001cH/\u0019;f\u0015\u0011\ty-!5\u0002\u0011M$\u0018\r^3gk2T1!a5'\u0003%y\u0007/\u001a:bi>\u00148/\u0003\u0003\u0002X\u0006%'A\b+sC:\u001chm\u001c:n/&$\bn\u0015;bi\u00164\u0016M]5bE2,\u0017J\u001c4p\u0003a\u0019'/Z1uK\u000e{gNZ:Ge>lwJ\u001a4tKRdun\u001a\u000b\u0003\u0003;\u0004r!NAp\u0003{\n\u0019/C\u0002\u0002bZ\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BAs\u0003Sl!!a:\u000b\u0005uR\u0013\u0002BAv\u0003O\u0014qaU)M\u0007>tg-\u0001\rhKR\u001cFo\u001c:f)>\u001c6\r[3nC\u001aKG.Z:NCB$B!!=\u0002tB1A*a\u0010L\u0003GCq!a\u001a\u0016\u0001\u0004\tI'A\rhKR<&/\u001b;fe\u000e{GNR1nS2L\u0018J\u001c4p\u001b\u0006\u0004HCCA}\u0005\u0003\u0011)A!\u0003\u0003\u000eA1A*a\u0010L\u0003w\u0004B!!\u0002\u0002~&\u0019\u0011q \u0013\u0003IM#\u0018\r^3QCJ$\u0018\u000e^5p]^\u0013\u0018\u000e^3s\u0007>dW/\u001c8GC6LG._%oM>DaAa\u0001\u0017\u0001\u00041\u0015AC8qKJ\fGo\u001c:JI\"9!q\u0001\fA\u0002\u0005M\u0014!D:u_J,W*\u001a;bI\u0006$\u0018\rC\u0004\u0003\fY\u0001\r!a)\u0002\u0017M\u001c\u0007.Z7b\r&dWm\u001d\u0005\n\u0005\u001f1\u0002\u0013!a\u0001\u0003\u0007\f\u0011\u0003^<t'R\fG/\u001a,be&\f'\r\\3t\u0003\r:W\r^,sSR,'oQ8m\r\u0006l\u0017\u000e\\=J]\u001a|W*\u00199%I\u00164\u0017-\u001e7uIQ*\"A!\u0006+\t\u0005\r'qC\u0016\u0003\u00053\u0001BAa\u0007\u0003&5\u0011!Q\u0004\u0006\u0005\u0005?\u0011\t#A\u0005v]\u000eDWmY6fI*\u0019!1\u0005\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003(\tu!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006ir-\u001a;MCR,7\u000f^\"pY\u001a\u000bW.\u001b7z)>\u001c6\r[3nC6\u000b\u0007\u000f\u0006\u0005\u0003.\tU\"q\u0007B\u001d!\u0019a\u0015qH&\u00030A!\u0011Q\u0001B\u0019\u0013\r\u0011\u0019\u0004\n\u0002\u001a'R\fG/Z*u_J,7i\u001c7GC6LG._*dQ\u0016l\u0017\r\u0003\u0004\u0003\u0004a\u0001\rA\u0012\u0005\b\u0005\u000fA\u0002\u0019AA:\u0011\u001d\u0011Y\u0001\u0007a\u0001\u0003G\u000bAd\u0019:fCR,7*Z=F]\u000e|G-\u001a:Ta\u0016\u001c\u0017JZ!cg\u0016tG\u000f\u0006\u0004\u00030\t}\"1\t\u0005\b\u0005\u0003J\u0002\u0019\u0001B\u0018\u0003=\u0019w\u000e\u001c$b[&d\u0017pU2iK6\f\u0007b\u0002B\u00043\u0001\u0007\u00111O\u0001\u0017O\u0016$8\u000b^1uKZ\u000b'/[1cY\u0016\u001c\u0018J\u001a+X'R!\u00111\u0019B%\u0011\u001d\t9G\u0007a\u0001\u0003S\nad\u0019:fCR,7\u000b^8sKN\u001b\u0007.Z7b!J|g/\u001b3fe&3GkV*\u0015\r\t=#q\u000bB.!\u0011)\u0014M!\u0015\u0011\t\u0005\u0015!1K\u0005\u0004\u0005+\"#aE*uCR,7k\u00195f[\u0006\u0004&o\u001c<jI\u0016\u0014\bB\u0002B-7\u0001\u00071*\u0001\u0004pa:\u000bW.\u001a\u0005\b\u0005\u0017Y\u0002\u0019AAR\u0003u1XM]5gs\u000eCWmY6q_&tGOR8s[\u0006$h+\u001a:tS>tGC\u0001B1!\r)$1M\u0005\u0004\u0005K2$\u0001B+oSR\fQb\u0015;bi\u0016\u0014Vm\u001e:ji\u0016\u0014\bcAA\u0003=M\u0011a\u0004\u000e\u000b\u0003\u0005S\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122TC\u0001B:U\r\u0001'qC\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\te$f\u00013\u0003\u0018\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIa*\"Aa +\u0007a\u00149\u0002")
public class StateRewriter
implements Logging {
    private StreamingQueryCheckpointMetadata writeCheckpoint;
    private StreamingQueryCheckpointMetadata readCheckpoint;
    private final SparkSession sparkSession;
    private final long readBatchId;
    private final long writeBatchId;
    private final String resolvedCheckpointLocation;
    private final Configuration hadoopConf;
    private final Option<String> readResolvedCheckpointLocation;
    private final Option<Function1<Dataset<Row>, Dataset<Row>>> transformFunc;
    private final Option<StreamingQueryCheckpointMetadata> writeCheckpointMetadata;
    private final String checkpointLocationForRead;
    private final String stateRootLocation;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Option<StreamingQueryCheckpointMetadata> $lessinit$greater$default$8() {
        return StateRewriter$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Function1<Dataset<Row>, Dataset<Row>>> $lessinit$greater$default$7() {
        return StateRewriter$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<String> $lessinit$greater$default$6() {
        return StateRewriter$.MODULE$.$lessinit$greater$default$6();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String checkpointLocationForRead() {
        return this.checkpointLocationForRead;
    }

    private String stateRootLocation() {
        return this.stateRootLocation;
    }

    private StreamingQueryCheckpointMetadata writeCheckpoint$lzycompute() {
        StateRewriter stateRewriter = this;
        synchronized (stateRewriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.writeCheckpoint = (StreamingQueryCheckpointMetadata)this.writeCheckpointMetadata.getOrElse((Function0 & Serializable)() -> new StreamingQueryCheckpointMetadata($this.sparkSession, $this.resolvedCheckpointLocation));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.writeCheckpoint;
    }

    private StreamingQueryCheckpointMetadata writeCheckpoint() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.writeCheckpoint$lzycompute();
        }
        return this.writeCheckpoint;
    }

    private StreamingQueryCheckpointMetadata readCheckpoint$lzycompute() {
        StateRewriter stateRewriter = this;
        synchronized (stateRewriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.readCheckpoint = this.readResolvedCheckpointLocation.isDefined() ? new StreamingQueryCheckpointMetadata(this.sparkSession, (String)this.readResolvedCheckpointLocation.get()) : this.writeCheckpoint();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.readCheckpoint;
    }

    private StreamingQueryCheckpointMetadata readCheckpoint() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.readCheckpoint$lzycompute();
        }
        return this.readCheckpoint;
    }

    public Option<scala.collection.immutable.Map<Object, String[][]>> run() {
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting state rewrite for "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"checkpointLocation=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CHECKPOINT_LOCATION, $this.resolvedCheckpointLocation)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"readCheckpointLocation="}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CHECKPOINT_LOCATION, $this.readResolvedCheckpointLocation.getOrElse((Function0 & Serializable)() -> ""))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"readBatchId=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)$this.readBatchId))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"writeBatchId=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)$this.writeBatchId))})))));
        Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0 & Serializable)() -> this.runInternal());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option checkpointIds = (Option)tuple2._1();
        long timeTakenMs = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)checkpointIds, (Object)BoxesRunTime.boxToLong((long)timeTakenMs));
        Option checkpointIds2 = (Option)tuple22._1();
        long timeTakenMs2 = tuple22._2$mcJ$sp();
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"State rewrite completed in ", " ms for "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.DURATION, BoxesRunTime.boxToLong((long)timeTakenMs2))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"checkpointLocation=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CHECKPOINT_LOCATION, $this.resolvedCheckpointLocation)})))));
        return checkpointIds2;
    }

    private Option<scala.collection.immutable.Map<Object, String[][]>> extractCheckpointIdsPerPartition(scala.collection.immutable.Map<Object, StateStoreCheckpointInfo[][]> checkpointInfos) {
        boolean enableCheckpointId = StatefulOperatorStateInfo$.MODULE$.enableStateStoreCheckpointIds(this.sparkSession.sessionState().conf());
        if (!enableCheckpointId) {
            return None$.MODULE$;
        }
        return Option$.MODULE$.apply((Object)checkpointInfos.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long operator = tuple2._1$mcJ$sp();
                StateStoreCheckpointInfo[][] storesSeq = (StateStoreCheckpointInfo[][])tuple2._2();
                int numPartitions = ((StateStoreCheckpointInfo[])ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storesSeq))).length;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)operator)), RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1 & Serializable)partitionIdx -> StateRewriter.$anonfun$extractCheckpointIdsPerPartition$2(this, storesSeq, BoxesRunTime.unboxToInt((Object)partitionIdx))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private Option<scala.collection.immutable.Map<Object, String[][]>> runInternal() {
        Option<scala.collection.immutable.Map<Object, String[][]>> option;
        try {
            this.verifyCheckpointFormatVersion();
            StateMetadataPartitionReader stateMetadataReader = new StateMetadataPartitionReader(this.resolvedCheckpointLocation, new SerializableConfiguration(this.hadoopConf), this.readBatchId);
            OperatorStateMetadata[] allOperatorsMetadata = stateMetadataReader.allOperatorStateMetadata();
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])allOperatorsMetadata))) {
                throw StateRewriterErrors$.MODULE$.missingOperatorMetadataError(this.resolvedCheckpointLocation, this.readBatchId);
            }
            Tuple2<StateStoreConf, SQLConf> tuple2 = this.createConfsFromOffsetLog();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            StateStoreConf storeConf = (StateStoreConf)tuple2._1();
            SQLConf sqlConf = (SQLConf)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)storeConf, (Object)sqlConf);
            StateStoreConf storeConf2 = (StateStoreConf)tuple22._1();
            SQLConf sqlConf2 = (SQLConf)tuple22._2();
            Broadcast hadoopConfBroadcast = SerializableConfiguration$.MODULE$.broadcast(this.sparkSession.sparkContext(), this.hadoopConf);
            scala.collection.immutable.Map checkpointInfos = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])allOperatorsMetadata), (Function1 & Serializable)opMetadata -> {
                Seq<StateStoreMetadata> stateStoresMetadata = opMetadata.stateStoresMetadata();
                Predef$.MODULE$.assert(!stateStoresMetadata.isEmpty(), (Function0 & Serializable)() -> "Operator " + opMetadata.operatorInfo().operatorName() + " has no state stores");
                scala.collection.immutable.Map<String, List<Path>> storeToSchemaFilesMap = this.getStoreToSchemaFilesMap((OperatorStateMetadata)opMetadata);
                scala.collection.immutable.Map<String, TransformWithStateVariableInfo> stateVarsIfTws = this.getStateVariablesIfTWS((OperatorStateMetadata)opMetadata);
                StateStoreCheckpointInfo[][] checkpointInfo = (StateStoreCheckpointInfo[][])((IterableOnceOps)stateStoresMetadata.map((Function1 & Serializable)stateStoreMetadata -> this.rewriteStore((OperatorStateMetadata)opMetadata, (StateStoreMetadata)stateStoreMetadata, storeConf2, (Broadcast<SerializableConfiguration>)hadoopConfBroadcast, (List<Path>)((List)storeToSchemaFilesMap.apply((Object)stateStoreMetadata.storeName())), stateVarsIfTws))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(StateStoreCheckpointInfo.class)));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)opMetadata.operatorInfo().operatorId())), (Object)checkpointInfo);
            }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            option = this.extractCheckpointIdsPerPartition((scala.collection.immutable.Map<Object, StateStoreCheckpointInfo[][]>)checkpointInfos);
        }
        catch (Throwable e) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"State rewrite failed for "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"checkpointLocation=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CHECKPOINT_LOCATION, $this.resolvedCheckpointLocation)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"readBatchId=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)$this.readBatchId))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"writeBatchId=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)$this.writeBatchId))})))), e);
            throw e;
        }
        return option;
    }

    private StateStoreCheckpointInfo[] rewriteStore(OperatorStateMetadata opMetadata, StateStoreMetadata stateStoreMetadata, StateStoreConf storeConf, Broadcast<SerializableConfiguration> hadoopConfBroadcast, List<Path> storeSchemaFiles, scala.collection.immutable.Map<String, TransformWithStateVariableInfo> stateVarsIfTws) {
        Dataset stateDf = this.sparkSession.read().format("statestore").option(StateSourceOptions$.MODULE$.PATH(), this.checkpointLocationForRead()).option(StateSourceOptions$.MODULE$.BATCH_ID(), this.readBatchId).option(StateSourceOptions$.MODULE$.OPERATOR_ID(), opMetadata.operatorInfo().operatorId()).option(StateSourceOptions$.MODULE$.STORE_NAME(), stateStoreMetadata.storeName()).option(StateSourceOptions$.MODULE$.INTERNAL_ONLY_READ_ALL_COLUMN_FAMILIES(), "true").load();
        Dataset updatedStateDf = (Dataset)this.transformFunc.map((Function1 & Serializable)func -> (Dataset)func.apply((Object)stateDf)).getOrElse((Function0 & Serializable)() -> stateDf);
        StructType structType = updatedStateDf.schema();
        StructType structType2 = stateDf.schema();
        Predef$.MODULE$.require(!(structType != null ? !structType.equals(structType2) : structType2 != null), (Function0 & Serializable)() -> "State transformation function must return a DataFrame with the same schema as the original state DataFrame. Original schema: " + stateDf.schema() + ", Updated schema: " + updatedStateDf.schema());
        Option<StateSchemaProvider> schemaProvider = this.createStoreSchemaProviderIfTWS(opMetadata.operatorInfo().operatorName(), storeSchemaFiles);
        scala.collection.immutable.Map<String, StatePartitionWriterColumnFamilyInfo> writerColFamilyInfoMap = this.getWriterColFamilyInfoMap(opMetadata.operatorInfo().operatorId(), stateStoreMetadata, storeSchemaFiles, stateVarsIfTws);
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Writing new state for "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"operator=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.OP_TYPE, opMetadata.operatorInfo().operatorName())}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"stateStore=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.STATE_NAME, stateStoreMetadata.storeName())}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numColumnFamilies=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.COUNT, BoxesRunTime.boxToInteger((int)writerColFamilyInfoMap.size()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numSchemaFiles=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_FILES, BoxesRunTime.boxToInteger((int)storeSchemaFiles.size()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for new batch=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)$this.writeBatchId))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"for checkpoint=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CHECKPOINT_LOCATION, $this.resolvedCheckpointLocation)})))));
        String targetCheckpointLocation = this.resolvedCheckpointLocation;
        long currentBatchId = this.writeBatchId;
        RDD<InternalRow> qual$1 = updatedStateDf.queryExecution().toRdd();
        Function1 & Serializable x$1 = (Function1 & Serializable)partitionIter -> {
            StatePartitionAllColumnFamiliesWriter partitionWriter = new StatePartitionAllColumnFamiliesWriter(storeConf, ((SerializableConfiguration)hadoopConfBroadcast.value()).value(), TaskContext$.MODULE$.get().partitionId(), targetCheckpointLocation, opMetadata.operatorInfo().operatorId(), stateStoreMetadata.storeName(), currentBatchId, writerColFamilyInfoMap, schemaProvider);
            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StateStoreCheckpointInfo[]{partitionWriter.write((Iterator<InternalRow>)partitionIter)}));
        };
        boolean x$2 = qual$1.mapPartitions$default$2();
        return (StateStoreCheckpointInfo[])qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(StateStoreCheckpointInfo.class)).collect();
    }

    private Tuple2<StateStoreConf, SQLConf> createConfsFromOffsetLog() {
        OffsetSeqLog offsetLog = ((StreamingQueryCheckpointMetadata)this.writeCheckpointMetadata.getOrElse((Function0 & Serializable)() -> new StreamingQueryCheckpointMetadata($this.sparkSession, $this.resolvedCheckpointLocation))).offsetLog();
        Option offsetSeq = offsetLog.get(this.writeBatchId);
        Predef$.MODULE$.require(offsetSeq.isDefined(), (Function0 & Serializable)() -> "Offset seq must be present for the new batch " + $this.writeBatchId);
        Option<OffsetSeqMetadataBase> metadata = ((OffsetSeqBase)offsetSeq.get()).metadataOpt();
        Predef$.MODULE$.require(metadata.isDefined(), (Function0 & Serializable)() -> "Metadata must be present for the new batch " + $this.writeBatchId);
        SQLConf clonedSqlConf = this.sparkSession.sessionState().conf().clone();
        OffsetSeqMetadata$.MODULE$.setSessionConf((OffsetSeqMetadataBase)metadata.get(), clonedSqlConf);
        return new Tuple2((Object)StateStoreConf$.MODULE$.apply(clonedSqlConf), (Object)clonedSqlConf);
    }

    private scala.collection.immutable.Map<String, List<Path>> getStoreToSchemaFilesMap(OperatorStateMetadata opMetadata) {
        return ((IterableOnceOps)opMetadata.stateStoresMetadata().map((Function1 & Serializable)storeMetadata -> {
            List list;
            StateStoreMetadata stateStoreMetadata = storeMetadata;
            if (stateStoreMetadata instanceof StateStoreMetadataV1) {
                list = package$.MODULE$.List().empty();
            } else if (stateStoreMetadata instanceof StateStoreMetadataV2) {
                StateStoreMetadataV2 stateStoreMetadataV2 = (StateStoreMetadataV2)stateStoreMetadata;
                list = stateStoreMetadataV2.stateSchemaFilePaths().map((Function1 & Serializable)x$3 -> new Path(x$3));
            } else {
                throw StateRewriterErrors$.MODULE$.unsupportedStateStoreMetadataVersionError($this.resolvedCheckpointLocation);
            }
            List schemaFiles = list;
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)storeMetadata.storeName()), (Object)schemaFiles);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private scala.collection.immutable.Map<String, StatePartitionWriterColumnFamilyInfo> getWriterColFamilyInfoMap(long operatorId, StateStoreMetadata storeMetadata, List<Path> schemaFiles, scala.collection.immutable.Map<String, TransformWithStateVariableInfo> twsStateVariables) {
        return (scala.collection.immutable.Map)this.getLatestColFamilyToSchemaMap(operatorId, storeMetadata, schemaFiles).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String colFamilyName = (String)tuple2._1();
                StateStoreColFamilySchema schema = (StateStoreColFamilySchema)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)colFamilyName), (Object)new StatePartitionWriterColumnFamilyInfo(schema, BoxesRunTime.unboxToBoolean((Object)twsStateVariables.get((Object)colFamilyName).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StateRewriter.$anonfun$getWriterColFamilyInfoMap$2(x$4))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private scala.collection.immutable.Map<String, TransformWithStateVariableInfo> getWriterColFamilyInfoMap$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    private scala.collection.immutable.Map<String, StateStoreColFamilySchema> getLatestColFamilyToSchemaMap(long operatorId, StateStoreMetadata storeMetadata, List<Path> schemaFiles) {
        StateStoreId storeId = new StateStoreId(this.stateRootLocation(), operatorId, StateStore$.MODULE$.PARTITION_ID_TO_CHECK_SCHEMA(), storeMetadata.storeName());
        StateStoreProviderId providerId = new StateStoreProviderId(storeId, UUID.randomUUID());
        StateSchemaCompatibilityChecker manager = new StateSchemaCompatibilityChecker(providerId, this.hadoopConf, schemaFiles, StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$4());
        return manager.readSchemaFile().map((Function1 & Serializable)schema -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)schema.colFamilyName()), (Object)this.createKeyEncoderSpecIfAbsent((StateStoreColFamilySchema)schema, storeMetadata))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private StateStoreColFamilySchema createKeyEncoderSpecIfAbsent(StateStoreColFamilySchema colFamilySchema, StateStoreMetadata storeMetadata) {
        Option<KeyStateEncoderSpec> option = colFamilySchema.keyStateEncoderSpec();
        if (option instanceof Some) {
            return colFamilySchema;
        }
        if (None$.MODULE$.equals(option) && storeMetadata instanceof StateStoreMetadataV1) {
            if (storeMetadata.numColsPrefixKey() > 0) {
                Some x$1 = new Some((Object)new PrefixKeyScanStateEncoderSpec(colFamilySchema.keySchema(), storeMetadata.numColsPrefixKey()));
                String x$2 = colFamilySchema.copy$default$1();
                short x$3 = colFamilySchema.copy$default$2();
                StructType x$4 = colFamilySchema.copy$default$3();
                short x$5 = colFamilySchema.copy$default$4();
                StructType x$6 = colFamilySchema.copy$default$5();
                Option<StructType> x$7 = colFamilySchema.copy$default$7();
                return colFamilySchema.copy(x$2, x$3, x$4, x$5, x$6, (Option<KeyStateEncoderSpec>)x$1, x$7);
            }
            Some x$8 = new Some((Object)new NoPrefixKeyStateEncoderSpec(colFamilySchema.keySchema()));
            String x$9 = colFamilySchema.copy$default$1();
            short x$10 = colFamilySchema.copy$default$2();
            StructType x$11 = colFamilySchema.copy$default$3();
            short x$12 = colFamilySchema.copy$default$4();
            StructType x$13 = colFamilySchema.copy$default$5();
            Option<StructType> x$14 = colFamilySchema.copy$default$7();
            return colFamilySchema.copy(x$9, x$10, x$11, x$12, x$13, (Option<KeyStateEncoderSpec>)x$8, x$14);
        }
        throw StateRewriterErrors$.MODULE$.missingKeyEncoderSpecError(this.resolvedCheckpointLocation, colFamilySchema.colFamilyName());
    }

    private scala.collection.immutable.Map<String, TransformWithStateVariableInfo> getStateVariablesIfTWS(OperatorStateMetadata opMetadata) {
        if (StatefulOperatorsUtils$.MODULE$.TRANSFORM_WITH_STATE_OP_NAMES().contains((Object)opMetadata.operatorInfo().operatorName())) {
            TransformWithStateOperatorProperties operatorProperties = TransformWithStateOperatorProperties$.MODULE$.fromJson(((OperatorStateMetadataV2)opMetadata).operatorPropertiesJson());
            return operatorProperties.stateVariables().map((Function1 & Serializable)s -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)s.stateName()), s)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return Predef$.MODULE$.Map().empty();
    }

    private Option<StateSchemaProvider> createStoreSchemaProviderIfTWS(String opName, List<Path> schemaFiles) {
        if (StatefulOperatorsUtils$.MODULE$.TRANSFORM_WITH_STATE_OP_NAMES().contains((Object)opName)) {
            StateSchemaMetadata schemaMetadata = StateSchemaMetadata$.MODULE$.createStateSchemaMetadata(this.stateRootLocation(), this.hadoopConf, (List<String>)schemaFiles.map((Function1 & Serializable)x$5 -> x$5.toString()));
            return new Some((Object)new InMemoryStateSchemaProvider(schemaMetadata));
        }
        return None$.MODULE$;
    }

    private void verifyCheckpointFormatVersion() {
        try {
            this.readCheckpoint().commitLog().get(this.readBatchId);
        }
        catch (Throwable throwable) {
            IllegalStateException illegalStateException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IllegalStateException && (illegalStateException = (IllegalStateException)throwable2).getCause() != null && illegalStateException.getCause() instanceof SparkThrowable) {
                SparkThrowable sparkThrowable = (SparkThrowable)illegalStateException.getCause();
                String string = sparkThrowable.getCondition();
                String string2 = "INVALID_LOG_VERSION.EXACT_MATCH_VERSION";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Map params = sparkThrowable.getMessageParameters();
                    String expectedVersion = (String)params.get("version");
                    String actualVersion = (String)params.get("matchVersion");
                    throw StateRewriterErrors$.MODULE$.stateCheckpointFormatVersionMismatchError(this.checkpointLocationForRead(), expectedVersion, actualVersion);
                }
                throw illegalStateException;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ String[] $anonfun$extractCheckpointIdsPerPartition$2(StateRewriter $this, StateStoreCheckpointInfo[][] storesSeq$1, int partitionIdx) {
        return (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])storesSeq$1), (Function1 & Serializable)storePartitions -> {
            StateStoreCheckpointInfo checkpointInfoPerPartition = storePartitions[partitionIdx];
            Predef$.MODULE$.assert(checkpointInfoPerPartition.partitionId() == partitionIdx);
            Predef$.MODULE$.assert(checkpointInfoPerPartition.batchVersion() == $this.writeBatchId + 1L);
            Predef$.MODULE$.assert(checkpointInfoPerPartition.baseStateStoreCkptId().isEmpty());
            return (String)checkpointInfoPerPartition.stateStoreCkptId().get();
        }, ClassTag$.MODULE$.apply(String.class));
    }

    public static final /* synthetic */ boolean $anonfun$getWriterColFamilyInfoMap$2(TransformWithStateVariableInfo x$4) {
        Enumeration.Value value = x$4.stateVariableType();
        Enumeration.Value value2 = StateVariableType$.MODULE$.ListState();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public StateRewriter(SparkSession sparkSession, long readBatchId, long writeBatchId, String resolvedCheckpointLocation, Configuration hadoopConf, Option<String> readResolvedCheckpointLocation, Option<Function1<Dataset<Row>, Dataset<Row>>> transformFunc, Option<StreamingQueryCheckpointMetadata> writeCheckpointMetadata) {
        this.sparkSession = sparkSession;
        this.readBatchId = readBatchId;
        this.writeBatchId = writeBatchId;
        this.resolvedCheckpointLocation = resolvedCheckpointLocation;
        this.hadoopConf = hadoopConf;
        this.readResolvedCheckpointLocation = readResolvedCheckpointLocation;
        this.transformFunc = transformFunc;
        this.writeCheckpointMetadata = writeCheckpointMetadata;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(readResolvedCheckpointLocation.isDefined() || readBatchId < writeBatchId, (Function0 & Serializable)() -> "Read batch id " + $this.readBatchId + " must be less than write batch id " + $this.writeBatchId + " when reading and writing to the same checkpoint location");
        this.checkpointLocationForRead = (String)readResolvedCheckpointLocation.getOrElse((Function0 & Serializable)() -> $this.resolvedCheckpointLocation);
        this.stateRootLocation = new Path(resolvedCheckpointLocation, StreamingCheckpointConstants$.MODULE$.DIR_NAME_STATE()).toString();
    }
}

