/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.utils;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParseStart;
import com.github.javaparser.Problem;
import com.github.javaparser.Providers;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.printer.PrettyPrinter;
import com.github.javaparser.utils.CodeGenerationUtils;
import com.github.javaparser.utils.Log;
import com.github.javaparser.utils.Utils;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SourceRoot {
    private final Path root;
    private final Map<Path, ParseResult<CompilationUnit>> cache = new HashMap<Path, ParseResult<CompilationUnit>>();
    private JavaParser javaParser = new JavaParser();
    private Function<CompilationUnit, String> printer = new PrettyPrinter()::print;

    public SourceRoot(Path root) {
        Utils.assertNotNull(root);
        if (!Files.isDirectory(root, new LinkOption[0])) {
            throw new IllegalArgumentException("Only directories are allowed as root path!");
        }
        this.root = root.normalize();
        Log.info("New source root at \"%s\"", this.root);
    }

    public List<ParseResult<CompilationUnit>> tryToParse(String startPackage) throws IOException {
        Utils.assertNotNull(startPackage);
        Log.info("Parsing package \"%s\"", startPackage);
        Path path = CodeGenerationUtils.packageAbsolutePath(this.root, startPackage);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!attrs.isDirectory() && file.toString().endsWith(".java")) {
                    Path relative = SourceRoot.this.root.relativize(file.getParent());
                    SourceRoot.this.tryToParse(relative.toString(), file.getFileName().toString());
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return this.getCache();
    }

    public SourceRoot parse(String startPackage, final JavaParser javaParser, final Callback callback) throws IOException {
        Utils.assertNotNull(startPackage);
        Utils.assertNotNull(javaParser);
        Utils.assertNotNull(callback);
        Log.info("Parsing package \"%s\"", startPackage);
        final Path path = CodeGenerationUtils.packageAbsolutePath(this.root, startPackage);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path absolutePath, BasicFileAttributes attrs) throws IOException {
                if (!attrs.isDirectory() && absolutePath.toString().endsWith(".java")) {
                    Path localPath = SourceRoot.this.root.relativize(absolutePath);
                    Log.trace("Parsing %s", localPath);
                    ParseResult<CompilationUnit> result = javaParser.parse(ParseStart.COMPILATION_UNIT, Providers.provider(absolutePath));
                    result.getResult().ifPresent(cu -> cu.setStorage(absolutePath));
                    if (callback.process(localPath, absolutePath, result) == Callback.Result.SAVE && result.getResult().isPresent()) {
                        SourceRoot.this.save(result.getResult().get(), path);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return this;
    }

    public List<ParseResult<CompilationUnit>> tryToParse() throws IOException {
        return this.tryToParse("");
    }

    public SourceRoot saveAll() {
        return this.saveAll(this.root);
    }

    public SourceRoot saveAll(Path root) {
        Utils.assertNotNull(root);
        Log.info("Saving all files (%s) to %s", this.cache.size(), root);
        for (Map.Entry<Path, ParseResult<CompilationUnit>> cu : this.cache.entrySet()) {
            Path path = root.resolve(cu.getKey());
            if (!cu.getValue().getResult().isPresent()) continue;
            Log.trace("Saving %s", path);
            this.save(cu.getValue().getResult().get(), path);
        }
        return this;
    }

    private SourceRoot save(CompilationUnit cu, Path path) {
        Utils.assertNotNull(cu);
        Utils.assertNotNull(path);
        cu.setStorage(path);
        cu.getStorage().get().save(this.printer);
        return this;
    }

    public List<ParseResult<CompilationUnit>> getCache() {
        return new ArrayList<ParseResult<CompilationUnit>>(this.cache.values());
    }

    public List<CompilationUnit> getCompilationUnits() {
        return this.cache.values().stream().filter(ParseResult::isSuccessful).map(p -> (CompilationUnit)p.getResult().get()).collect(Collectors.toList());
    }

    public ParseResult<CompilationUnit> tryToParse(String packag, String filename) throws IOException {
        Utils.assertNotNull(packag);
        Utils.assertNotNull(filename);
        Path relativePath = CodeGenerationUtils.fileInPackageRelativePath(packag, filename);
        if (this.cache.containsKey(relativePath)) {
            Log.trace("Retrieving cached %s", relativePath);
            return this.cache.get(relativePath);
        }
        Path path = this.root.resolve(relativePath);
        Log.trace("Parsing %s", path);
        ParseResult<CompilationUnit> result = this.javaParser.parse(ParseStart.COMPILATION_UNIT, Providers.provider(path));
        result.getResult().ifPresent(cu -> cu.setStorage(path));
        this.cache.put(relativePath, result);
        return result;
    }

    public CompilationUnit parse(String packag, String filename) {
        Utils.assertNotNull(packag);
        Utils.assertNotNull(filename);
        try {
            ParseResult<CompilationUnit> result = this.tryToParse(packag, filename);
            if (result.isSuccessful()) {
                return result.getResult().get();
            }
            throw new ParseProblemException(result.getProblems());
        }
        catch (IOException e) {
            throw new ParseProblemException(e);
        }
    }

    public SourceRoot add(String pkg, String filename, CompilationUnit compilationUnit) {
        Utils.assertNotNull(pkg);
        Utils.assertNotNull(filename);
        Utils.assertNotNull(compilationUnit);
        Log.trace("Adding new file %s.%s", pkg, filename);
        Path path = CodeGenerationUtils.fileInPackageRelativePath(pkg, filename);
        ParseResult<CompilationUnit> parseResult = new ParseResult<CompilationUnit>(compilationUnit, new ArrayList<Problem>(), null, null);
        this.cache.put(path, parseResult);
        return this;
    }

    public SourceRoot add(CompilationUnit compilationUnit) {
        Utils.assertNotNull(compilationUnit);
        if (!compilationUnit.getStorage().isPresent()) {
            throw new AssertionError((Object)"Files added with this method should have their path set.");
        }
        Path path = compilationUnit.getStorage().get().getPath();
        Log.trace("Adding new file %s", path);
        ParseResult<CompilationUnit> parseResult = new ParseResult<CompilationUnit>(compilationUnit, new ArrayList<Problem>(), null, null);
        this.cache.put(path, parseResult);
        return this;
    }

    public Path getRoot() {
        return this.root;
    }

    public JavaParser getJavaParser() {
        return this.javaParser;
    }

    public SourceRoot setJavaParser(JavaParser javaParser) {
        Utils.assertNotNull(javaParser);
        this.javaParser = javaParser;
        return this;
    }

    public SourceRoot setPrinter(Function<CompilationUnit, String> printer) {
        Utils.assertNotNull(printer);
        this.printer = printer;
        return this;
    }

    public Function<CompilationUnit, String> getPrinter() {
        return this.printer;
    }

    public static interface Callback {
        public Result process(Path var1, Path var2, ParseResult<CompilationUnit> var3);

        public static enum Result {
            SAVE,
            DONT_SAVE;

        }
    }
}

