/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;

public class RemoveShuffleMerge
extends BlockTransferMessage {
    public final String appId;
    public final int appAttemptId;
    public final int shuffleId;
    public final int shuffleMergeId;

    public RemoveShuffleMerge(String appId, int appAttemptId, int shuffleId, int shuffleMergeId) {
        this.appId = appId;
        this.appAttemptId = appAttemptId;
        this.shuffleId = shuffleId;
        this.shuffleMergeId = shuffleMergeId;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.REMOVE_SHUFFLE_MERGE;
    }

    public int hashCode() {
        return Objects.hash(this.appId, this.appAttemptId, this.shuffleId, this.shuffleMergeId);
    }

    public String toString() {
        return "RemoveShuffleMerge[appId=" + this.appId + ",attemptId=" + this.appAttemptId + ",shuffleId=" + this.shuffleId + ",shuffleMergeId=" + this.shuffleMergeId + "]";
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof RemoveShuffleMerge) {
            RemoveShuffleMerge o = (RemoveShuffleMerge)other;
            return Objects.equals(this.appId, o.appId) && this.appAttemptId == o.appAttemptId && this.shuffleId == o.shuffleId && this.shuffleMergeId == o.shuffleMergeId;
        }
        return false;
    }

    public int encodedLength() {
        return Encoders.Strings.encodedLength((String)this.appId) + 4 + 4 + 4;
    }

    public void encode(ByteBuf buf) {
        Encoders.Strings.encode((ByteBuf)buf, (String)this.appId);
        buf.writeInt(this.appAttemptId);
        buf.writeInt(this.shuffleId);
        buf.writeInt(this.shuffleMergeId);
    }

    public static RemoveShuffleMerge decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode((ByteBuf)buf);
        int attemptId = buf.readInt();
        int shuffleId = buf.readInt();
        int shuffleMergeId = buf.readInt();
        return new RemoveShuffleMerge(appId, attemptId, shuffleId, shuffleMergeId);
    }
}

