/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.ResolvedIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.package$;

public final class IdentifierHelper$ {
    public static final IdentifierHelper$ MODULE$ = new IdentifierHelper$();

    public String toQuotedString(Seq<String> nameParts) {
        return this.toTableIdentifier(nameParts).quotedString();
    }

    public TableIdentifier toTableIdentifier(Seq<String> nameParts) throws UnsupportedOperationException {
        int n = nameParts.length();
        switch (n) {
            case 1: {
                return TableIdentifier$.MODULE$.apply((String)nameParts.head());
            }
            case 2: {
                return TableIdentifier$.MODULE$.apply((String)nameParts.apply(1), Option$.MODULE$.apply(nameParts.head()));
            }
            case 3: {
                return new TableIdentifier((String)nameParts.apply(2), Option$.MODULE$.apply(nameParts.apply(1)), Option$.MODULE$.apply(nameParts.head()));
            }
        }
        throw new UnsupportedOperationException("4+ part table identifier " + nameParts.mkString(".") + " is not supported.");
    }

    public TableIdentifier toTableIdentifier(LogicalPlan table) {
        Seq seq;
        LogicalPlan logicalPlan = table;
        if (logicalPlan instanceof ResolvedIdentifier) {
            ResolvedIdentifier resolvedIdentifier = (ResolvedIdentifier)logicalPlan;
            seq = (Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])resolvedIdentifier.identifier().namespace())).$colon$plus((Object)resolvedIdentifier.identifier().name());
        } else if (logicalPlan instanceof UnresolvedIdentifier) {
            UnresolvedIdentifier unresolvedIdentifier = (UnresolvedIdentifier)logicalPlan;
            seq = unresolvedIdentifier.nameParts();
        } else if (logicalPlan instanceof UnresolvedRelation) {
            UnresolvedRelation unresolvedRelation = (UnresolvedRelation)logicalPlan;
            seq = unresolvedRelation.multipartIdentifier();
        } else {
            throw new UnsupportedOperationException("Unable to resolve name for " + table + ".");
        }
        Seq parts = seq;
        return this.toTableIdentifier((Seq<String>)parts);
    }

    public boolean isSinglePartIdentifier(TableIdentifier identifier) {
        return identifier.database().isEmpty() && identifier.catalog().isEmpty();
    }

    public boolean isPathIdentifier(SparkSession spark, TableIdentifier identifier) {
        SeqOps seqOps;
        if (identifier.nameParts().length() != 2) {
            return false;
        }
        Seq seq = identifier.nameParts();
        if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) != 0) {
            throw new MatchError((Object)seq);
        }
        String datasource = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        String path = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        Tuple2 tuple2 = new Tuple2((Object)datasource, (Object)path);
        String datasource2 = (String)tuple2._1();
        String path2 = (String)tuple2._2();
        SQLConf sqlConf = spark.sessionState().conf();
        return IdentifierHelper$.isDatasourceValid$1(datasource2, sqlConf);
    }

    public TableIdentifier fullyQualifyIdentifier(TableIdentifier maybeFullyQualifiedIdentifier, Option<String> currentCatalog, Option<String> currentDatabase) {
        Option x$1 = maybeFullyQualifiedIdentifier.database().orElse((Function0 & Serializable)() -> currentDatabase);
        Option x$2 = maybeFullyQualifiedIdentifier.catalog().orElse((Function0 & Serializable)() -> currentCatalog);
        String x$3 = maybeFullyQualifiedIdentifier.copy$default$1();
        return maybeFullyQualifiedIdentifier.copy(x$3, x$1, x$2);
    }

    public void assertIsFullyQualifiedForCreate(TableIdentifier identifier) {
        Predef$.MODULE$.assert(identifier.catalog().isDefined() && identifier.database().isDefined(), (Function0 & Serializable)() -> "Dataset identifier " + identifier + " is not properly fully qualified, expect a three-part-name <catalog>.<schema>.<table>");
    }

    public void assertIsFullyQualifiedForRead(TableIdentifier identifier) {
        Predef$.MODULE$.assert(identifier.catalog().isDefined() && identifier.database().isDefined(), (Function0 & Serializable)() -> "Failed to reference dataset " + identifier + ", expect a three-part-name <catalog>.<schema>.<table>");
    }

    private static final boolean isDatasourceValid$1(String datasource$1, SQLConf sqlConf$1) {
        boolean bl;
        try {
            DataSource$.MODULE$.lookupDataSource(datasource$1, sqlConf$1);
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }

    private IdentifierHelper$() {
    }
}

