/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.io.internal;

import org.sparkproject.jetty.io.Content;
import org.sparkproject.jetty.util.Callback;
import org.sparkproject.jetty.util.thread.Invocable;

public class ContentSourceConsumer
implements Invocable.Task {
    private final Content.Source source;
    private final Callback callback;

    public ContentSourceConsumer(Content.Source source, Callback callback) {
        this.source = source;
        this.callback = callback;
    }

    @Override
    public void run() {
        Content.Chunk chunk;
        do {
            if ((chunk = this.source.read()) == null) {
                this.source.demand(this);
                return;
            }
            if (Content.Chunk.isFailure(chunk)) {
                this.callback.failed(chunk.getFailure());
                if (!chunk.isLast()) {
                    this.source.fail(chunk.getFailure());
                }
                return;
            }
            chunk.release();
        } while (!chunk.isLast());
        this.callback.succeeded();
    }

    @Override
    public Invocable.InvocationType getInvocationType() {
        return this.callback.getInvocationType();
    }
}

