/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ReplicationControllerCondition;
import io.fabric8.kubernetes.api.model.ReplicationControllerConditionBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerConditionFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ReplicationControllerStatusFluent<A extends ReplicationControllerStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Integer availableReplicas;
    private ArrayList<ReplicationControllerConditionBuilder> conditions = new ArrayList();
    private Integer fullyLabeledReplicas;
    private Long observedGeneration;
    private Integer readyReplicas;
    private Integer replicas;

    public ReplicationControllerStatusFluent() {
    }

    public ReplicationControllerStatusFluent(ReplicationControllerStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToConditions(Collection<ReplicationControllerCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ReplicationControllerCondition item : items) {
            ReplicationControllerConditionBuilder builder = new ReplicationControllerConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new ReplicationControllerCondition(lastTransitionTime, message, reason, status, type));
    }

    public ConditionsNested<A> addNewConditionLike(ReplicationControllerCondition item) {
        return new ConditionsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToConditions(ReplicationControllerCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (ReplicationControllerCondition item : items) {
            ReplicationControllerConditionBuilder builder = new ReplicationControllerConditionBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, ReplicationControllerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ReplicationControllerConditionBuilder builder = new ReplicationControllerConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public ReplicationControllerCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public List<ReplicationControllerCondition> buildConditions() {
        return this.conditions != null ? ReplicationControllerStatusFluent.build(this.conditions) : null;
    }

    public ReplicationControllerCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public ReplicationControllerCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public ReplicationControllerCondition buildMatchingCondition(Predicate<ReplicationControllerConditionBuilder> predicate) {
        for (ReplicationControllerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    protected void copyInstance(ReplicationControllerStatus instance) {
        ReplicationControllerStatus replicationControllerStatus = instance = instance != null ? instance : new ReplicationControllerStatus();
        if (instance != null) {
            this.withAvailableReplicas(instance.getAvailableReplicas());
            this.withConditions(instance.getConditions());
            this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withReadyReplicas(instance.getReadyReplicas());
            this.withReplicas(instance.getReplicas());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ReplicationControllerConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "conditions"));
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicationControllerStatusFluent that = (ReplicationControllerStatusFluent)((Object)o);
        if (!Objects.equals(this.availableReplicas, that.availableReplicas)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.fullyLabeledReplicas, that.fullyLabeledReplicas)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.readyReplicas, that.readyReplicas)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public Integer getFullyLabeledReplicas() {
        return this.fullyLabeledReplicas;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAvailableReplicas() {
        return this.availableReplicas != null;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasFullyLabeledReplicas() {
        return this.fullyLabeledReplicas != null;
    }

    public boolean hasMatchingCondition(Predicate<ReplicationControllerConditionBuilder> predicate) {
        for (ReplicationControllerConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean hasReadyReplicas() {
        return this.readyReplicas != null;
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.conditions, this.fullyLabeledReplicas, this.observedGeneration, this.readyReplicas, this.replicas, this.additionalProperties);
    }

    public A removeAllFromConditions(Collection<ReplicationControllerCondition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (ReplicationControllerCondition item : items) {
            ReplicationControllerConditionBuilder builder = new ReplicationControllerConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(ReplicationControllerCondition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (ReplicationControllerCondition item : items) {
            ReplicationControllerConditionBuilder builder = new ReplicationControllerConditionBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ReplicationControllerConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ReplicationControllerConditionBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ReplicationControllerConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ConditionsNested<A> setNewConditionLike(int index, ReplicationControllerCondition item) {
        return new ConditionsNested(index, item);
    }

    public A setToConditions(int index, ReplicationControllerCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ReplicationControllerConditionBuilder builder = new ReplicationControllerConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availableReplicas != null) {
            sb.append("availableReplicas:");
            sb.append(this.availableReplicas);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.fullyLabeledReplicas != null) {
            sb.append("fullyLabeledReplicas:");
            sb.append(this.fullyLabeledReplicas);
            sb.append(",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
            sb.append(",");
        }
        if (this.readyReplicas != null) {
            sb.append("readyReplicas:");
            sb.append(this.readyReplicas);
            sb.append(",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return (A)((Object)this);
    }

    public A withConditions(List<ReplicationControllerCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (ReplicationControllerCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(ReplicationControllerCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (ReplicationControllerCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withFullyLabeledReplicas(Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
        return (A)((Object)this);
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public A withReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return (A)((Object)this);
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)((Object)this);
    }

    public class ConditionsNested<N>
    extends ReplicationControllerConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ReplicationControllerConditionBuilder builder;
        int index;

        ConditionsNested(int index, ReplicationControllerCondition item) {
            this.index = index;
            this.builder = new ReplicationControllerConditionBuilder(this, item);
        }

        public N and() {
            return (N)ReplicationControllerStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

