/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.AbstractFileMergeOperator;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileKeyBufferWrapper;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileValueBufferWrapper;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.RCFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.shims.CombineHiveKey;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RCFileMergeOperator
extends AbstractFileMergeOperator<RCFileMergeDesc> {
    public static final Logger LOG = LoggerFactory.getLogger((String)"RCFileMergeMapper");
    RCFile.Writer outWriter;
    CompressionCodec codec = null;
    int columnNumber = 0;

    protected RCFileMergeOperator() {
    }

    public RCFileMergeOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        Object[] keyValue = (Object[])row;
        this.processKeyValuePairs(keyValue[0], keyValue[1]);
    }

    private void processKeyValuePairs(Object k, Object v) throws HiveException {
        try {
            boolean sameCodec;
            RCFileKeyBufferWrapper key = k instanceof CombineHiveKey ? (RCFileKeyBufferWrapper)((CombineHiveKey)k).getKey() : (RCFileKeyBufferWrapper)k;
            RCFileValueBufferWrapper value = (RCFileValueBufferWrapper)v;
            this.fixTmpPath(key.getInputPath().getParent());
            if (this.outWriter == null) {
                this.codec = key.getCodec();
                this.columnNumber = key.getKeyBuffer().getColumnNumber();
                RCFileOutputFormat.setColumnNumber((Configuration)this.jc, this.columnNumber);
                this.outWriter = new RCFile.Writer(this.fs, (Configuration)this.jc, this.outPath, null, this.codec);
            }
            boolean bl = sameCodec = this.codec == key.getCodec() || this.codec.getClass().equals(key.getCodec().getClass());
            if (key.getKeyBuffer().getColumnNumber() != this.columnNumber || !sameCodec) {
                throw new IOException("RCFileMerge failed because the input files use different CompressionCodec or have different column number setting.");
            }
            this.outWriter.flushBlock(key.getKeyBuffer(), value.getValueBuffer(), key.getRecordLength(), key.getKeyLength(), key.getCompressedKeyLength());
        }
        catch (Throwable e) {
            this.exception = true;
            this.closeOp(true);
            throw new HiveException(e);
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.outWriter == null) {
            return;
        }
        try {
            this.outWriter.close();
        }
        catch (IOException e) {
            throw new HiveException("Unable to close RCFileMergeOperator", e);
        }
        this.outWriter = null;
        super.closeOp(abort);
    }

    @Override
    public OperatorType getType() {
        return OperatorType.RCFILEMERGE;
    }

    @Override
    public String getName() {
        return RCFileMergeOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "RFM";
    }
}

