/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.v2.state.metadata.StateMetadataPartitionReader;
import org.apache.spark.sql.execution.streaming.checkpointing.CommitMetadata;
import org.apache.spark.sql.execution.streaming.checkpointing.CommitMetadata$;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetMap;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeq;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqBase;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqControlBatchInfo;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqMetadataBase;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqMetadataV2;
import org.apache.spark.sql.execution.streaming.checkpointing.SourceMetadataInfo;
import org.apache.spark.sql.execution.streaming.runtime.StreamingCheckpointConstants$;
import org.apache.spark.sql.execution.streaming.runtime.StreamingQueryCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.OfflineStateRepartitionErrors$;
import org.apache.spark.sql.execution.streaming.state.OfflineStateRepartitionRunner$;
import org.apache.spark.sql.execution.streaming.state.OfflineStateRepartitionUtils$;
import org.apache.spark.sql.execution.streaming.state.OperatorInfoV1;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadata;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadataUtils;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadataV2;
import org.apache.spark.sql.execution.streaming.state.OperatorStateMetadataWriter$;
import org.apache.spark.sql.execution.streaming.state.StateRewriter;
import org.apache.spark.sql.execution.streaming.state.StateRewriter$;
import org.apache.spark.sql.execution.streaming.state.StateStoreMetadataV2;
import org.apache.spark.sql.execution.streaming.utils.StreamingUtils$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001\u0002\r\u001a\u0001!B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u001d1\u0006A1A\u0005\n]Ca\u0001\u0019\u0001!\u0002\u0013A\u0006bB1\u0001\u0005\u0004%IA\u0019\u0005\u0007G\u0002\u0001\u000b\u0011B\u001e\t\u000f\u0011\u0004!\u0019!C\u0005K\"1A\u000e\u0001Q\u0001\n\u0019DQ!\u001c\u0001\u0005\u00029DQA\u001d\u0001\u0005\n9DQa\u001d\u0001\u0005\n9DQ\u0001\u001e\u0001\u0005\nUDQA\u001f\u0001\u0005\nmDq!a\u0001\u0001\t\u0013\t)\u0001C\u0004\u0002\f\u0001!I!!\u0004\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a\u001dI\u0011qG\r\u0002\u0002#\u0005\u0011\u0011\b\u0004\t1e\t\t\u0011#\u0001\u0002<!1a*\u0006C\u0001\u0003{A\u0011\"a\u0010\u0016#\u0003%\t!!\u0011\u0003;=3g\r\\5oKN#\u0018\r^3SKB\f'\u000f^5uS>t'+\u001e8oKJT!AG\u000e\u0002\u000bM$\u0018\r^3\u000b\u0005qi\u0012!C:ue\u0016\fW.\u001b8h\u0015\tqr$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0001%I\u0001\u0004gFd'B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!K\u0018\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g!\t\u00014'D\u00012\u0015\t\u0011\u0014%\u0001\u0005j]R,'O\\1m\u0013\t!\u0014GA\u0004M_\u001e<\u0017N\\4\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005]BT\"A\u0010\n\u0005ez\"\u0001D*qCJ\\7+Z:tS>t\u0017AE2iK\u000e\\\u0007o\\5oi2{7-\u0019;j_:\u0004\"\u0001P\"\u000f\u0005u\n\u0005C\u0001 ,\u001b\u0005y$B\u0001!(\u0003\u0019a$o\\8u}%\u0011!iK\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%AB*ue&twM\u0003\u0002CW\u0005ia.^7QCJ$\u0018\u000e^5p]N\u0004\"A\u000b%\n\u0005%[#aA%oi\u00061RM\u001c4pe\u000e,W\t_1di2LxJ\\2f'&t7\u000e\u0005\u0002+\u0019&\u0011Qj\u000b\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q)\u0001KU*U+B\u0011\u0011\u000bA\u0007\u00023!)Q'\u0002a\u0001m!)!(\u0002a\u0001w!)a)\u0002a\u0001\u000f\"9!*\u0002I\u0001\u0002\u0004Y\u0015A\u00035bI>|\u0007oQ8oMV\t\u0001\f\u0005\u0002Z=6\t!L\u0003\u0002\\9\u0006!1m\u001c8g\u0015\ti6%\u0001\u0004iC\u0012|w\u000e]\u0005\u0003?j\u0013QbQ8oM&<WO]1uS>t\u0017a\u00035bI>|\u0007oQ8oM\u0002\n!C]3t_24X\rZ\"q\u0019>\u001c\u0017\r^5p]V\t1(A\nsKN|GN^3e\u0007BdunY1uS>t\u0007%\u0001\ndQ\u0016\u001c7\u000e]8j]RlU\r^1eCR\fW#\u00014\u0011\u0005\u001dTW\"\u00015\u000b\u0005%\\\u0012a\u0002:v]RLW.Z\u0005\u0003W\"\u0014\u0001e\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018p\u00115fG.\u0004x.\u001b8u\u001b\u0016$\u0018\rZ1uC\u0006\u00192\r[3dWB|\u0017N\u001c;NKR\fG-\u0019;bA\u0005\u0019!/\u001e8\u0015\u0003=\u0004\"A\u000b9\n\u0005E\\#\u0001\u0002'p]\u001e\fqcZ3u\u0019\u0006\u001cHoQ8n[&$H/\u001a3CCR\u001c\u0007.\u00133\u0002\u001d\u001d,G\u000fT1ti\n\u000bGo\u00195JI\u000612M]3bi\u0016tUm\u001e\"bi\u000eD\u0017J\u001a(fK\u0012,G\rF\u0002pmbDQa^\bA\u0002=\f1\u0002\\1ti\n\u000bGo\u00195JI\")\u0011p\u0004a\u0001_\u0006!B.Y:u\u0007>lW.\u001b;uK\u0012\u0014\u0015\r^2i\u0013\u0012\fac]6jaVs7m\\7nSR$X\r\u001a\"bi\u000eDWm\u001d\u000b\u0005y~\f\t\u0001\u0005\u0002+{&\u0011ap\u000b\u0002\u0005+:LG\u000fC\u0003x!\u0001\u0007q\u000eC\u0003z!\u0001\u0007q.A\u0010de\u0016\fG/\u001a(fo\n\u000bGo\u00195Ge>lG*Y:u\u0007>lW.\u001b;uK\u0012$Ra\\A\u0004\u0003\u0013AQa^\tA\u0002=DQ!_\tA\u0002=\fQ%\u001e9eCR,g*^7QCJ$\u0018\u000e^5p]NLen\u00149fe\u0006$xN]'fi\u0006$\u0017\r^1\u0015\u000bq\fy!a\u0005\t\r\u0005E!\u00031\u0001p\u0003)qWm\u001e\"bi\u000eD\u0017\n\u001a\u0005\u0007\u0003+\u0011\u0002\u0019A8\u0002\u0017I,\u0017\r\u001a\"bi\u000eD\u0017\nZ\u0001\fG>lW.\u001b;CCR\u001c\u0007\u000eF\u0004}\u00037\ti\"a\b\t\r\u0005E1\u00031\u0001p\u0011\u0015I8\u00031\u0001p\u0011\u001d\t\tc\u0005a\u0001\u0003G\t\u0001d\u001c9JIR{7\u000b^1uKN#xN]3DWB$\u0018J\u001c4p!\u0015Q\u0013QEA\u0015\u0013\r\t9c\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\rq\nYc\\A\u0018\u0013\r\ti#\u0012\u0002\u0004\u001b\u0006\u0004\b#\u0002\u0016\u00022\u0005U\u0012bAA\u001aW\t)\u0011I\u001d:bsB!!&!\r<\u0003uyeM\u001a7j]\u0016\u001cF/\u0019;f%\u0016\u0004\u0018M\u001d;ji&|gNU;o]\u0016\u0014\bCA)\u0016'\t)\u0012\u0006\u0006\u0002\u0002:\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"!a\u0011+\u0007-\u000b)e\u000b\u0002\u0002HA!\u0011\u0011JA*\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013!C;oG\",7m[3e\u0015\r\t\tfK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA+\u0003\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class OfflineStateRepartitionRunner
implements Logging {
    private final SparkSession sparkSession;
    private final String checkpointLocation;
    private final int numPartitions;
    private final boolean enforceExactlyOnceSink;
    private final Configuration hadoopConf;
    private final String resolvedCpLocation;
    private final StreamingQueryCheckpointMetadata checkpointMetadata;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$4() {
        return OfflineStateRepartitionRunner$.MODULE$.$lessinit$greater$default$4();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private String resolvedCpLocation() {
        return this.resolvedCpLocation;
    }

    private StreamingQueryCheckpointMetadata checkpointMetadata() {
        return this.checkpointMetadata;
    }

    public long run() {
        long l;
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting offline state repartitioning for "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"checkpointLocation=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CHECKPOINT_LOCATION, $this.checkpointLocation)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numPartitions=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_PARTITIONS, BoxesRunTime.boxToInteger((int)$this.numPartitions))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"enforceExactlyOnceSink=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.ENFORCE_EXACTLY_ONCE, BoxesRunTime.boxToBoolean((boolean)$this.enforceExactlyOnceSink))})))));
        try {
            Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0)(JFunction0.mcJ.sp & Serializable)() -> {
                long lastCommittedBatchId = this.getLastCommittedBatchId();
                long lastBatchId = this.getLastBatchId();
                long newBatchId = this.createNewBatchIfNeeded(lastBatchId, lastCommittedBatchId);
                Function1 & Serializable stateRepartitionFunc = (Function1 & Serializable)stateDf -> stateDf.repartition($this.numPartitions, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("partition_key")}));
                SparkSession x$1 = $this.sparkSession;
                long x$2 = lastCommittedBatchId;
                long x$3 = newBatchId;
                String x$4 = this.resolvedCpLocation();
                Configuration x$5 = this.hadoopConf();
                Some x$6 = new Some((Object)stateRepartitionFunc);
                Some x$7 = new Some((Object)this.checkpointMetadata());
                Option<String> x$8 = StateRewriter$.MODULE$.$lessinit$greater$default$6();
                StateRewriter rewriter = new StateRewriter(x$1, x$2, x$3, x$4, x$5, x$8, (Option<Function1<Dataset<Row>, Dataset<Row>>>)x$6, (Option<StreamingQueryCheckpointMetadata>)x$7);
                Option<scala.collection.immutable.Map<Object, String[][]>> operatorToCkptIds = rewriter.run();
                this.updateNumPartitionsInOperatorMetadata(newBatchId, lastCommittedBatchId);
                this.commitBatch(newBatchId, lastCommittedBatchId, operatorToCkptIds);
                return newBatchId;
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long repartitionBatchId = tuple2._1$mcJ$sp();
            long durationMs = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(repartitionBatchId, durationMs);
            long repartitionBatchId2 = sp2._1$mcJ$sp();
            long durationMs2 = sp2._2$mcJ$sp();
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Completed state repartitioning for "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"checkpointLocation=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CHECKPOINT_LOCATION, $this.checkpointLocation)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numPartitions=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_PARTITIONS, BoxesRunTime.boxToInteger((int)$this.numPartitions))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"enforceExactlyOnceSink=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.ENFORCE_EXACTLY_ONCE, BoxesRunTime.boxToBoolean((boolean)$this.enforceExactlyOnceSink))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"repartitionBatchId=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)repartitionBatchId2))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"durationMs=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.DURATION, BoxesRunTime.boxToLong((long)durationMs2))})))));
            l = repartitionBatchId2;
        }
        catch (Throwable e) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"State repartitioning failed for "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"checkpointLocation=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CHECKPOINT_LOCATION, $this.checkpointLocation)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numPartitions=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_PARTITIONS, BoxesRunTime.boxToInteger((int)$this.numPartitions))})))), e);
            throw e;
        }
        return l;
    }

    private long getLastCommittedBatchId() {
        Option<Object> option = this.checkpointMetadata().commitLog().getLatestBatchId();
        if (option instanceof Some) {
            Some some = (Some)option;
            long id = BoxesRunTime.unboxToLong((Object)some.value());
            return id;
        }
        if (None$.MODULE$.equals(option)) {
            throw OfflineStateRepartitionErrors$.MODULE$.noCommittedBatchError(this.checkpointLocation);
        }
        throw new MatchError(option);
    }

    private long getLastBatchId() {
        Option<Object> option = this.checkpointMetadata().offsetLog().getLatestBatchId();
        if (option instanceof Some) {
            Some some = (Some)option;
            long id = BoxesRunTime.unboxToLong((Object)some.value());
            return id;
        }
        if (None$.MODULE$.equals(option)) {
            throw OfflineStateRepartitionErrors$.MODULE$.noBatchFoundError(this.checkpointLocation);
        }
        throw new MatchError(option);
    }

    private long createNewBatchIfNeeded(long lastBatchId, long lastCommittedBatchId) {
        if (lastBatchId == lastCommittedBatchId) {
            return this.createNewBatchFromLastCommitted(lastBatchId, lastCommittedBatchId);
        }
        if (OfflineStateRepartitionUtils$.MODULE$.isRepartitionBatch(lastBatchId, this.checkpointMetadata().offsetLog())) {
            OffsetSeqBase lastBatch = (OffsetSeqBase)this.checkpointMetadata().offsetLog().get(lastBatchId).get();
            int lastBatchShufflePartitions = BoxesRunTime.unboxToInt((Object)OfflineStateRepartitionUtils$.MODULE$.getShufflePartitions((OffsetSeqMetadataBase)lastBatch.metadataOpt().get()).get());
            if (lastBatchShufflePartitions == this.numPartitions) {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The last batch is a failed repartition batch "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(batchId=", "). "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)lastBatchId))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying it since it used the same number of shuffle partitions "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"as the requested ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_PARTITIONS, BoxesRunTime.boxToInteger((int)$this.numPartitions))})))));
                return lastBatchId;
            }
            throw OfflineStateRepartitionErrors$.MODULE$.lastBatchAbandonedRepartitionError(this.checkpointLocation, lastBatchId, lastBatchShufflePartitions, this.numPartitions);
        }
        if (this.enforceExactlyOnceSink) {
            throw OfflineStateRepartitionErrors$.MODULE$.lastBatchFailedError(this.checkpointLocation, lastBatchId);
        }
        this.skipUncommittedBatches(lastBatchId, lastCommittedBatchId);
        return this.createNewBatchFromLastCommitted(lastBatchId, lastCommittedBatchId);
    }

    private void skipUncommittedBatches(long lastBatchId, long lastCommittedBatchId) {
        Predef$.MODULE$.assert(lastBatchId > lastCommittedBatchId, (Function0 & Serializable)() -> "Last batch ID must be greater than last committed batch ID");
        long fromBatchId = lastCommittedBatchId + 1L;
        new RichLong(Predef$.MODULE$.longWrapper(fromBatchId)).to((Object)BoxesRunTime.boxToLong((long)lastBatchId)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)batchId -> {
            if (!this.checkpointMetadata().commitLog().add(batchId, new CommitMetadata(CommitMetadata$.MODULE$.apply$default$1(), CommitMetadata$.MODULE$.apply$default$2()))) {
                throw QueryExecutionErrors$.MODULE$.concurrentStreamLogUpdate(batchId);
            }
        });
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Skipped uncommitted batches from batchId "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " to ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)fromBatchId)), this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)lastBatchId))})))));
    }

    private long createNewBatchFromLastCommitted(long lastBatchId, long lastCommittedBatchId) {
        OffsetSeqBase offsetSeqBase;
        long newBatchId = lastBatchId + 1L;
        OffsetSeqBase lastCommittedOffsetSeq = (OffsetSeqBase)this.checkpointMetadata().offsetLog().get(lastCommittedBatchId).getOrElse((Function0 & Serializable)() -> {
            throw OfflineStateRepartitionErrors$.MODULE$.offsetSeqNotFoundError($this.checkpointLocation, lastCommittedBatchId);
        });
        OffsetSeqMetadataBase lastCommittedMetadata = (OffsetSeqMetadataBase)lastCommittedOffsetSeq.metadataOpt().getOrElse((Function0 & Serializable)() -> {
            throw OfflineStateRepartitionErrors$.MODULE$.missingOffsetSeqMetadataError($this.checkpointLocation, 1, lastCommittedBatchId);
        });
        if (BoxesRunTime.unboxToInt((Object)OfflineStateRepartitionUtils$.MODULE$.getShufflePartitions(lastCommittedMetadata).get()) == this.numPartitions) {
            throw OfflineStateRepartitionErrors$.MODULE$.shufflePartitionsAlreadyMatchError(this.checkpointLocation, lastCommittedBatchId, this.numPartitions);
        }
        OffsetSeqBase offsetSeqBase2 = lastCommittedOffsetSeq;
        if (offsetSeqBase2 instanceof OffsetSeq) {
            OffsetSeq offsetSeq = (OffsetSeq)offsetSeqBase2;
            OffsetSeqMetadata metadata = (OffsetSeqMetadata)offsetSeq.metadataOpt().get();
            scala.collection.immutable.Map x$1 = (scala.collection.immutable.Map)metadata.conf().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key()), (Object)Integer.toString(this.numPartitions)));
            long x$2 = metadata.copy$default$1();
            long x$3 = metadata.copy$default$2();
            Some x$4 = new Some((Object)metadata.copy(x$2, x$3, (scala.collection.immutable.Map<String, String>)x$1));
            Seq<Option<Offset>> x$5 = offsetSeq.copy$default$1();
            offsetSeqBase = offsetSeq.copy(x$5, (Option<OffsetSeqMetadata>)x$4);
        } else if (offsetSeqBase2 instanceof OffsetMap) {
            OffsetMap offsetMap = (OffsetMap)offsetSeqBase2;
            scala.collection.immutable.Map x$6 = (scala.collection.immutable.Map)offsetMap.metadata().conf().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key()), (Object)Integer.toString(this.numPartitions)));
            long x$7 = offsetMap.metadata().copy$default$1();
            long x$8 = offsetMap.metadata().copy$default$2();
            scala.collection.immutable.Map<String, SourceMetadataInfo> x$9 = offsetMap.metadata().copy$default$4();
            Option<OffsetSeqControlBatchInfo> x$10 = offsetMap.metadata().copy$default$5();
            OffsetSeqMetadataV2 x$11 = offsetMap.metadata().copy(x$7, x$8, (scala.collection.immutable.Map<String, String>)x$6, x$9, x$10);
            scala.collection.immutable.Map<String, Option<Offset>> x$12 = offsetMap.copy$default$1();
            offsetSeqBase = offsetMap.copy(x$12, x$11);
        } else {
            throw OfflineStateRepartitionErrors$.MODULE$.unsupportedOffsetSeqVersionError(this.checkpointLocation, -1);
        }
        OffsetSeq newOffsetSeq = offsetSeqBase;
        if (!this.checkpointMetadata().offsetLog().add(newBatchId, newOffsetSeq)) {
            throw QueryExecutionErrors$.MODULE$.concurrentStreamLogUpdate(newBatchId);
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Created new offset log entry for repartition batch. "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"batchId=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)newBatchId))})))));
        return newBatchId;
    }

    private void updateNumPartitionsInOperatorMetadata(long newBatchId, long readBatchId) {
        StateMetadataPartitionReader stateMetadataReader = new StateMetadataPartitionReader(this.resolvedCpLocation(), new SerializableConfiguration(this.hadoopConf()), readBatchId);
        OperatorStateMetadata[] allOperatorsMetadata = stateMetadataReader.allOperatorStateMetadata();
        Predef$.MODULE$.assert(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])allOperatorsMetadata)), (Function0 & Serializable)() -> "Operator metadata shouldn't be empty");
        String stateRootLocation = new Path(this.resolvedCpLocation(), StreamingCheckpointConstants$.MODULE$.DIR_NAME_STATE()).toString();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])allOperatorsMetadata), (Function1 & Serializable)opMetadata -> {
            OfflineStateRepartitionRunner.$anonfun$updateNumPartitionsInOperatorMetadata$2(this, stateRootLocation, newBatchId, opMetadata);
            return BoxedUnit.UNIT;
        });
    }

    private void commitBatch(long newBatchId, long lastCommittedBatchId, Option<scala.collection.immutable.Map<Object, String[][]>> opIdToStateStoreCkptInfo) {
        CommitMetadata latestCommit = (CommitMetadata)this.checkpointMetadata().commitLog().get(lastCommittedBatchId).get();
        Option<scala.collection.immutable.Map<Object, String[][]>> x$1 = opIdToStateStoreCkptInfo;
        long x$2 = latestCommit.copy$default$1();
        CommitMetadata commitMetadata = latestCommit.copy(x$2, x$1);
        if (!this.checkpointMetadata().commitLog().add(newBatchId, commitMetadata)) {
            throw QueryExecutionErrors$.MODULE$.concurrentStreamLogUpdate(newBatchId);
        }
    }

    public static final /* synthetic */ void $anonfun$updateNumPartitionsInOperatorMetadata$2(OfflineStateRepartitionRunner $this, String stateRootLocation$1, long newBatchId$2, OperatorStateMetadata opMetadata) {
        OperatorStateMetadata operatorStateMetadata = opMetadata;
        if (operatorStateMetadata instanceof OperatorStateMetadataV2) {
            StateStoreMetadataV2[] updatedStoreInfo;
            OperatorStateMetadataV2 operatorStateMetadataV2 = (OperatorStateMetadataV2)operatorStateMetadata;
            StateStoreMetadataV2[] x$5 = updatedStoreInfo = (StateStoreMetadataV2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])operatorStateMetadataV2.stateStoreInfo()), (Function1 & Serializable)stateStore -> {
                int x$1 = $this.numPartitions;
                String x$2 = stateStore.copy$default$1();
                int x$3 = stateStore.copy$default$2();
                List<String> x$4 = stateStore.copy$default$4();
                return stateStore.copy(x$2, x$3, x$1, x$4);
            }, ClassTag$.MODULE$.apply(StateStoreMetadataV2.class));
            OperatorInfoV1 x$6 = operatorStateMetadataV2.copy$default$1();
            String x$7 = operatorStateMetadataV2.copy$default$3();
            OperatorStateMetadataV2 updatedMetadata = operatorStateMetadataV2.copy(x$6, x$5, x$7);
            OperatorStateMetadataUtils.OperatorStateMetadataWriter metadataWriter = OperatorStateMetadataWriter$.MODULE$.createWriter(new Path(stateRootLocation$1, Long.toString(updatedMetadata.operatorInfo().operatorId())), $this.hadoopConf(), updatedMetadata.version(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)newBatchId$2)));
            metadataWriter.write(updatedMetadata);
            $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Updated operator metadata for "}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"operator=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.OP_TYPE, updatedMetadata.operatorInfo().operatorName())}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numStateStores=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.COUNT, BoxesRunTime.boxToInteger((int)updatedMetadata.stateStoreInfo().length))})))));
            return;
        }
        $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping operator metadata update for "}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"operator=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.OP_TYPE, operatorStateMetadata.operatorInfo().operatorName())}))).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"since metadata version(", ") is not versioned"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.FILE_VERSION, BoxesRunTime.boxToInteger((int)operatorStateMetadata.version()))})))));
    }

    public OfflineStateRepartitionRunner(SparkSession sparkSession, String checkpointLocation, int numPartitions, boolean enforceExactlyOnceSink) {
        this.sparkSession = sparkSession;
        this.checkpointLocation = checkpointLocation;
        this.numPartitions = numPartitions;
        this.enforceExactlyOnceSink = enforceExactlyOnceSink;
        Logging.$init$((Logging)this);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.resolvedCpLocation = StreamingUtils$.MODULE$.resolvedCheckpointLocation(this.hadoopConf(), checkpointLocation);
        this.checkpointMetadata = new StreamingQueryCheckpointMetadata(sparkSession, this.resolvedCpLocation());
    }
}

