/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.ReadOnlyException;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.BaseWritableBufferImpl;

public interface WritableBuffer
extends Buffer {
    public static WritableBuffer writableWrap(ByteBuffer byteBuffer) {
        return WritableBuffer.writableWrap(byteBuffer, byteBuffer.order(), defaultMemReqSvr);
    }

    public static WritableBuffer writableWrap(ByteBuffer byteBuffer, ByteOrder byteOrder, MemoryRequestServer memReqSvr) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyException("Cannot create a WritableBuffer from a ReadOnly ByteBuffer.");
        }
        return BaseWritableBufferImpl.wrapByteBuffer(byteBuffer, false, byteOrder, memReqSvr);
    }

    public WritableBuffer writableDuplicate();

    public WritableBuffer writableDuplicate(ByteOrder var1);

    public WritableBuffer writableRegion();

    public WritableBuffer writableRegion(long var1, long var3, ByteOrder var5);

    default public WritableMemory asWritableMemory() {
        return this.asWritableMemory(ByteOrder.nativeOrder());
    }

    public WritableMemory asWritableMemory(ByteOrder var1);

    public void putBoolean(boolean var1);

    public void putBoolean(long var1, boolean var3);

    public void putByte(byte var1);

    public void putByte(long var1, byte var3);

    public void putByteArray(byte[] var1, int var2, int var3);

    public void putChar(char var1);

    public void putChar(long var1, char var3);

    public void putCharArray(char[] var1, int var2, int var3);

    public void putDouble(double var1);

    public void putDouble(long var1, double var3);

    public void putDoubleArray(double[] var1, int var2, int var3);

    public void putFloat(float var1);

    public void putFloat(long var1, float var3);

    public void putFloatArray(float[] var1, int var2, int var3);

    public void putInt(int var1);

    public void putInt(long var1, int var3);

    public void putIntArray(int[] var1, int var2, int var3);

    public void putLong(long var1);

    public void putLong(long var1, long var3);

    public void putLongArray(long[] var1, int var2, int var3);

    public void putShort(short var1);

    public void putShort(long var1, short var3);

    public void putShortArray(short[] var1, int var2, int var3);

    public Object getArray();

    public void clear();

    public void fill(byte var1);
}

