/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.instantiator.sun;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.objenesis.ObjenesisException;

class SunReflectionFactoryHelper {
    SunReflectionFactoryHelper() {
    }

    public static <T> Constructor<T> newConstructorForSerialization(Class<T> type, Constructor<?> constructor) {
        Class<?> reflectionFactoryClass = SunReflectionFactoryHelper.getReflectionFactoryClass();
        Object reflectionFactory = SunReflectionFactoryHelper.createReflectionFactory(reflectionFactoryClass);
        Method newConstructorForSerializationMethod = SunReflectionFactoryHelper.getNewConstructorForSerializationMethod(reflectionFactoryClass);
        try {
            return (Constructor)newConstructorForSerializationMethod.invoke(reflectionFactory, type, constructor);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new ObjenesisException(e);
        }
    }

    private static Class<?> getReflectionFactoryClass() {
        try {
            return Class.forName("sun.reflect.ReflectionFactory");
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName("jdk.internal.reflect.ReflectionFactory");
            }
            catch (ClassNotFoundException ex) {
                throw new ObjenesisException("You might need to add the unsupported module with --add-modules jdk.unsupported", e);
            }
        }
    }

    private static Object createReflectionFactory(Class<?> reflectionFactoryClass) {
        try {
            Method method = reflectionFactoryClass.getDeclaredMethod("getReflectionFactory", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new ObjenesisException(e);
        }
    }

    private static Method getNewConstructorForSerializationMethod(Class<?> reflectionFactoryClass) {
        try {
            return reflectionFactoryClass.getDeclaredMethod("newConstructorForSerialization", Class.class, Constructor.class);
        }
        catch (NoSuchMethodException e) {
            throw new ObjenesisException(e);
        }
    }
}

