/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.jobs;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.scheduler.SchedulingMode$;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.AppSummary;
import org.apache.spark.status.api.v1.ApplicationAttemptInfo;
import org.apache.spark.status.api.v1.ApplicationInfo;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.ui.ToolTips$;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.ui.jobs.ApiHelper$;
import org.apache.spark.ui.jobs.JobPagedTable;
import org.apache.spark.ui.jobs.JobsTab;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;
import scala.xml.Utility$;

@ScalaSignature(bytes="\u0006\u0005\u0005]b!B\n\u0015\u0001Yq\u0002\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\t\u0011%\u0002!\u0011!Q\u0001\n)BQ\u0001\r\u0001\u0005\u0002EBq!\u000e\u0001C\u0002\u0013%a\u0007\u0003\u0004>\u0001\u0001\u0006Ia\u000e\u0005\b}\u0001\u0011\r\u0011\"\u0003@\u0011\u0019\u0019\u0005\u0001)A\u0005\u0001\"9A\t\u0001b\u0001\n\u0013y\u0004BB#\u0001A\u0003%\u0001\tC\u0004G\u0001\t\u0007I\u0011B$\t\rM\u0003\u0001\u0015!\u0003I\u0011\u001d!\u0006A1A\u0005\n\u001dCa!\u0016\u0001!\u0002\u0013A\u0005\"\u0002,\u0001\t\u00139\u0006\"B6\u0001\t\u0013a\u0007\"B:\u0001\t\u0013!\bbBA\u0004\u0001\u0011%\u0011\u0011\u0002\u0005\b\u0003c\u0001A\u0011AA\u001a\u0005-\tE\u000e\u001c&pEN\u0004\u0016mZ3\u000b\u0005U1\u0012\u0001\u00026pENT!a\u0006\r\u0002\u0005UL'BA\r\u001b\u0003\u0015\u0019\b/\u0019:l\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\u0014\u0005\u0001y\u0002C\u0001\u0011\"\u001b\u00051\u0012B\u0001\u0012\u0017\u0005%9VMY+J!\u0006<W-\u0001\u0004qCJ,g\u000e^\u0002\u0001!\t1s%D\u0001\u0015\u0013\tACCA\u0004K_\n\u001cH+\u00192\u0002\u000bM$xN]3\u0011\u0005-rS\"\u0001\u0017\u000b\u00055B\u0012AB:uCR,8/\u0003\u00020Y\tq\u0011\t\u001d9Ti\u0006$Xo]*u_J,\u0017A\u0002\u001fj]&$h\bF\u00023gQ\u0002\"A\n\u0001\t\u000b\r\u001a\u0001\u0019A\u0013\t\u000b%\u001a\u0001\u0019\u0001\u0016\u0002!QKU*\u0012'J\u001d\u0016{VIT!C\u0019\u0016#U#A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\u000f\t{w\u000e\\3b]\u0006\tB+S'F\u0019&sUiX#O\u0003\ncU\t\u0012\u0011\u0002#5\u000b\u0005l\u0018+J\u001b\u0016c\u0015JT#`\u0015>\u00135+F\u0001A!\tA\u0014)\u0003\u0002Cs\t\u0019\u0011J\u001c;\u0002%5\u000b\u0005l\u0018+J\u001b\u0016c\u0015JT#`\u0015>\u00135\u000bI\u0001\u0017\u001b\u0006Cv\fV%N\u000b2Ke*R0F1\u0016\u001bU\u000bV(S'\u00069R*\u0011-`)&kU\tT%O\u000b~+\u0005,R\"V)>\u00136\u000bI\u0001\f\u0015>\u00135k\u0018'F\u000f\u0016sE)F\u0001I!\tI\u0005K\u0004\u0002K\u001dB\u00111*O\u0007\u0002\u0019*\u0011Q\nJ\u0001\u0007yI|w\u000e\u001e \n\u0005=K\u0014A\u0002)sK\u0012,g-\u0003\u0002R%\n11\u000b\u001e:j]\u001eT!aT\u001d\u0002\u0019){%iU0M\u000b\u001e+e\n\u0012\u0011\u0002!\u0015CViQ+U\u001fJ\u001bv\fT#H\u000b:#\u0015!E#Y\u000b\u000e+Fk\u0014*T?2+u)\u0012(EA\u0005aQ.Y6f\u0015>\u0014WI^3oiR\u0011\u0001,\u0019\t\u00043zCeB\u0001.]\u001d\tY5,C\u0001;\u0013\ti\u0016(A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0003'aA*fc*\u0011Q,\u000f\u0005\u0006+9\u0001\rA\u0019\t\u00043z\u001b\u0007C\u00013j\u001b\u0005)'B\u00014h\u0003\t1\u0018G\u0003\u0002iY\u0005\u0019\u0011\r]5\n\u0005),'a\u0002&pE\u0012\u000bG/Y\u0001\u0012[\u0006\\W-\u0012=fGV$xN]#wK:$HC\u0001-n\u0011\u0015qw\u00021\u0001p\u0003%)\u00070Z2vi>\u00148\u000fE\u0002Z=B\u0004\"\u0001Z9\n\u0005I,'aD#yK\u000e,Ho\u001c:Tk6l\u0017M]=\u0002\u00195\f7.\u001a+j[\u0016d\u0017N\\3\u0015\tUdXP \t\u00043z3\bCA<{\u001b\u0005A(BA=:\u0003\rAX\u000e\\\u0005\u0003wb\u0014AAT8eK\")Q\u0003\u0005a\u0001E\")a\u000e\u0005a\u0001_\"1q\u0010\u0005a\u0001\u0003\u0003\t\u0011b\u001d;beR$\u0016.\\3\u0011\u0007a\n\u0019!C\u0002\u0002\u0006e\u0012A\u0001T8oO\u0006I!n\u001c2t)\u0006\u0014G.\u001a\u000b\fk\u0006-\u00111EA\u0014\u0003W\ti\u0003C\u0004\u0002\u000eE\u0001\r!a\u0004\u0002\u000fI,\u0017/^3tiB!\u0011\u0011CA\u0010\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011\u0001\u00025uiBTA!!\u0007\u0002\u001c\u000591/\u001a:wY\u0016$(BAA\u000f\u0003\u001dQ\u0017m[1si\u0006LA!!\t\u0002\u0014\t\u0011\u0002\n\u001e;q'\u0016\u0014h\u000f\\3u%\u0016\fX/Z:u\u0011\u0019\t)#\u0005a\u0001\u0011\u0006iA/\u00192mK\"+\u0017\rZ3s\u0013\u0012Da!!\u000b\u0012\u0001\u0004A\u0015A\u00026pER\u000bw\rC\u0003\u0016#\u0001\u0007!\r\u0003\u0004\u00020E\u0001\raN\u0001\fW&dG.\u00128bE2,G-\u0001\u0004sK:$WM\u001d\u000b\u0004k\u0006U\u0002bBA\u0007%\u0001\u0007\u0011q\u0002")
public class AllJobsPage
extends WebUIPage {
    private final JobsTab parent;
    private final AppStatusStore store;
    private final boolean TIMELINE_ENABLED;
    private final int MAX_TIMELINE_JOBS;
    private final int MAX_TIMELINE_EXECUTORS;
    private final String JOBS_LEGEND;
    private final String EXECUTORS_LEGEND;

    private boolean TIMELINE_ENABLED() {
        return this.TIMELINE_ENABLED;
    }

    private int MAX_TIMELINE_JOBS() {
        return this.MAX_TIMELINE_JOBS;
    }

    private int MAX_TIMELINE_EXECUTORS() {
        return this.MAX_TIMELINE_EXECUTORS;
    }

    private String JOBS_LEGEND() {
        return this.JOBS_LEGEND;
    }

    private String EXECUTORS_LEGEND() {
        return this.EXECUTORS_LEGEND;
    }

    private scala.collection.immutable.Seq<String> makeJobEvent(scala.collection.immutable.Seq<JobData> jobs) {
        long now = System.currentTimeMillis();
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((SeqOps)jobs.filter((Function1 & Serializable)job -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$makeJobEvent$1(job)))).sortBy((Function1 & Serializable)j -> new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)j.completionTime().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> now)), ((Date)j.submissionTime().get()).getTime()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$))).takeRight(this.MAX_TIMELINE_JOBS())).map((Function1 & Serializable)job -> {
            String string;
            int jobId = job.jobId();
            JobExecutionStatus status = job.status();
            Tuple2<String, String> tuple2 = ApiHelper$.MODULE$.lastStageNameAndDescription($this.store, (JobData)job);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String lastStageDescription = (String)tuple2._2();
            String lastStageDescription2 = lastStageDescription;
            String jobDescription = UIUtils$.MODULE$.makeDescription((String)job.description().getOrElse((Function0 & Serializable)() -> lastStageDescription2), "", true).text();
            long submissionTime = ((Date)job.submissionTime().get()).getTime();
            long completionTime = BoxesRunTime.unboxToLong((Object)job.completionTime().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> now));
            JobExecutionStatus jobExecutionStatus = status;
            if (((Object)((Object)JobExecutionStatus.SUCCEEDED)).equals((Object)jobExecutionStatus)) {
                string = "succeeded";
            } else if (((Object)((Object)JobExecutionStatus.FAILED)).equals((Object)jobExecutionStatus)) {
                string = "failed";
            } else if (((Object)((Object)JobExecutionStatus.RUNNING)).equals((Object)jobExecutionStatus)) {
                string = "running";
            } else if (((Object)((Object)JobExecutionStatus.UNKNOWN)).equals((Object)jobExecutionStatus)) {
                string = "unknown";
            } else {
                throw new MatchError((Object)jobExecutionStatus);
            }
            String classNameByStatus = string;
            String escapedDesc = Utility$.MODULE$.escape(jobDescription);
            String jsEscapedDescForTooltip = StringEscapeUtils.escapeEcmaScript((String)Utility$.MODULE$.escape(escapedDesc));
            String jsEscapedDescForLabel = StringEscapeUtils.escapeEcmaScript((String)escapedDesc);
            JobExecutionStatus jobExecutionStatus2 = status;
            JobExecutionStatus jobExecutionStatus3 = JobExecutionStatus.RUNNING;
            String jobEventJsonAsStr = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |{\n           |  'className': 'job application-timeline-object " + classNameByStatus + "',\n           |  'group': 'jobs',\n           |  'start': new Date(" + submissionTime + "),\n           |  'end': new Date(" + completionTime + "),\n           |  'content': '<div class=\"application-timeline-content\"' +\n           |     'data-html=\"true\" data-placement=\"top\" data-toggle=\"tooltip\"' +\n           |     'data-title=\"" + jsEscapedDescForTooltip + " (Job " + jobId + ")<br>' +\n           |     'Status: " + status + "<br>' +\n           |     'Submitted: " + UIUtils$.MODULE$.formatDate(new Date(submissionTime)) + "' +\n           |     '" + ((jobExecutionStatus2 == null ? jobExecutionStatus3 != null : !((Object)((Object)jobExecutionStatus2)).equals((Object)jobExecutionStatus3)) ? "<br>Completed: " + UIUtils$.MODULE$.formatDate(new Date(completionTime)) : "") + "\">' +\n           |    '" + jsEscapedDescForLabel + " (Job " + jobId + ")</div>'\n           |}\n         "));
            return jobEventJsonAsStr;
        });
    }

    private scala.collection.immutable.Seq<String> makeExecutorEvent(scala.collection.immutable.Seq<ExecutorSummary> executors) {
        ListBuffer events = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ((IterableOnceOps)((IterableOps)executors.sortBy((Function1 & Serializable)e -> BoxesRunTime.boxToLong((long)AllJobsPage.$anonfun$makeExecutorEvent$1(e)), (Ordering)Ordering.Long$.MODULE$)).takeRight(this.MAX_TIMELINE_EXECUTORS())).foreach((Function1 & Serializable)e -> {
            AllJobsPage.$anonfun$makeExecutorEvent$4(events, e);
            return BoxedUnit.UNIT;
        });
        return events.toSeq();
    }

    private scala.collection.immutable.Seq<Node> makeTimeline(scala.collection.immutable.Seq<JobData> jobs, scala.collection.immutable.Seq<ExecutorSummary> executors, long startTime) {
        Elem elem;
        Elem elem2;
        if (!this.TIMELINE_ENABLED()) {
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        }
        scala.collection.immutable.Seq<String> jobEventJsonAsStrSeq = this.makeJobEvent(jobs);
        scala.collection.immutable.Seq<String> executorEventJsonAsStrSeq = this.makeExecutorEvent(executors);
        String groupJsonArrayAsStr = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |[\n          |  {\n          |    'id': 'executors',\n          |    'content': '<div>Executors</div>" + this.EXECUTORS_LEGEND() + "',\n          |  },\n          |  {\n          |    'id': 'jobs',\n          |    'content': '<div>Jobs</div>" + this.JOBS_LEGEND() + "',\n          |  }\n          |]\n        "));
        String eventArrayAsStr = ((IterableOnceOps)jobEventJsonAsStrSeq.$plus$plus(executorEventJsonAsStrSeq)).mkString("[", ",", "]");
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("expand-application-timeline"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("expand-application-timeline-arrow arrow-closed"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("data-placement", (Seq)new Text("top"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("title", ToolTips$.MODULE$.JOB_TIMELINE(), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md3);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        Event Timeline\n      "));
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n    "));
        Elem elem3 = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("collapsed"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("id", (Seq)new Text("application-timeline"), (MetaData)$md4);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n      "));
        if (this.MAX_TIMELINE_JOBS() < jobs.size()) {
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf5 = new NodeBuffer();
            $buf5.$amp$plus((Object)new Text("\n              Only the most recent "));
            $buf5.$amp$plus((Object)BoxesRunTime.boxToInteger((int)this.MAX_TIMELINE_JOBS()));
            $buf5.$amp$plus((Object)new Text(" submitted/completed jobs\n              (of "));
            $buf5.$amp$plus((Object)BoxesRunTime.boxToInteger((int)jobs.size()));
            $buf5.$amp$plus((Object)new Text(" total) are shown.\n            "));
            $buf4.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
            $buf4.$amp$plus((Object)new Text("\n          "));
            Elem elem4 = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector());
            elem2 = elem4;
        } else {
            elem2 = package$.MODULE$.Seq().empty();
        }
        $buf3.$amp$plus((Object)elem2);
        $buf3.$amp$plus((Object)new Text("\n      "));
        if (this.MAX_TIMELINE_EXECUTORS() < executors.size()) {
            NodeBuffer $buf6 = new NodeBuffer();
            $buf6.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf7 = new NodeBuffer();
            $buf7.$amp$plus((Object)new Text("\n              Only the most recent "));
            $buf7.$amp$plus((Object)BoxesRunTime.boxToInteger((int)this.MAX_TIMELINE_EXECUTORS()));
            $buf7.$amp$plus((Object)new Text(" added/removed executors\n              (of "));
            $buf7.$amp$plus((Object)BoxesRunTime.boxToInteger((int)executors.size()));
            $buf7.$amp$plus((Object)new Text(" total) are shown.\n            "));
            $buf6.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
            $buf6.$amp$plus((Object)new Text("\n          "));
            Elem elem5 = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector());
            elem = elem5;
        } else {
            elem = package$.MODULE$.Seq().empty();
        }
        $buf3.$amp$plus((Object)elem);
        $buf3.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("control-panel"), (MetaData)$md5);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n        "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("id", (Seq)new Text("application-timeline-zoom-lock"), (MetaData)$md6);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n          "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md7);
        $buf9.$amp$plus((Object)new Elem(null, "input", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf9.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Enable zooming"));
        $buf9.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf10.toVector()));
        $buf9.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf9.toVector()));
        $buf8.$amp$plus((Object)new Text("\n      "));
        $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf8.toVector()));
        $buf3.$amp$plus((Object)new Text("\n    "));
        NodeSeq nodeSeq = elem3.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md8);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n      "));
        $buf11.$amp$plus((Object)Unparsed$.MODULE$.apply("drawApplicationTimeline(" + groupJsonArrayAsStr + "," + eventArrayAsStr + ", " + startTime + ", " + UIUtils$.MODULE$.getTimeZoneOffset() + ");"));
        $buf11.$amp$plus((Object)new Text("\n    "));
        return nodeSeq.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "script", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf11.toVector()));
    }

    private scala.collection.immutable.Seq<Node> jobsTable(HttpServletRequest request, String tableHeaderId, String jobTag, scala.collection.immutable.Seq<JobData> jobs, boolean killEnabled) {
        Elem elem;
        boolean someJobHasJobGroup = jobs.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$jobsTable$1(x$6)));
        String jobIdTitle = someJobHasJobGroup ? "Job Id (Job Group)" : "Job Id";
        int jobPage = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)request.getParameter(jobTag + ".page")).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$7)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
        try {
            elem = new JobPagedTable(request, this.store, jobs, tableHeaderId, jobTag, UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), "jobs", killEnabled, jobIdTitle).table(jobPage);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IndexOutOfBoundsException) {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("class", (Seq)new Text("alert alert-error"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("Error while rendering job table:"));
                $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
                $buf.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf3 = new NodeBuffer();
                $buf3.$amp$plus((Object)new Text("\n            "));
                $buf3.$amp$plus((Object)Utils$.MODULE$.exceptionString(throwable2));
                $buf3.$amp$plus((Object)new Text("\n          "));
                $buf.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
                $buf.$amp$plus((Object)new Text("\n        "));
                Elem elem2 = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
                elem = elem2;
            }
            throw throwable;
        }
        return elem;
    }

    @Override
    public scala.collection.immutable.Seq<Node> render(HttpServletRequest request) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        ApplicationInfo appInfo = this.store.applicationInfo();
        Date startDate = ((ApplicationAttemptInfo)appInfo.attempts().head()).startTime();
        long startTime = startDate.getTime();
        long endTime = ((ApplicationAttemptInfo)appInfo.attempts().head()).endTime().getTime();
        ListBuffer activeJobs = new ListBuffer();
        ListBuffer completedJobs = new ListBuffer();
        ListBuffer failedJobs = new ListBuffer();
        this.store.jobsList(null).foreach((Function1 & Serializable)job -> {
            JobExecutionStatus jobExecutionStatus = job.status();
            if (((Object)((Object)JobExecutionStatus.SUCCEEDED)).equals((Object)jobExecutionStatus)) {
                return (ListBuffer)completedJobs.$plus$eq(job);
            }
            if (((Object)((Object)JobExecutionStatus.FAILED)).equals((Object)jobExecutionStatus)) {
                return (ListBuffer)failedJobs.$plus$eq(job);
            }
            return (ListBuffer)activeJobs.$plus$eq(job);
        });
        scala.collection.immutable.Seq<Node> activeJobsTable = this.jobsTable(request, "active", "activeJob", (scala.collection.immutable.Seq<JobData>)activeJobs.toSeq(), this.parent.killEnabled());
        scala.collection.immutable.Seq<Node> completedJobsTable = this.jobsTable(request, "completed", "completedJob", (scala.collection.immutable.Seq<JobData>)completedJobs.toSeq(), false);
        scala.collection.immutable.Seq<Node> failedJobsTable = this.jobsTable(request, "failed", "failedJob", (scala.collection.immutable.Seq<JobData>)failedJobs.toSeq(), false);
        boolean shouldShowActiveJobs = activeJobs.nonEmpty();
        boolean shouldShowCompletedJobs = completedJobs.nonEmpty();
        boolean shouldShowFailedJobs = failedJobs.nonEmpty();
        AppSummary appSummary = this.store.appSummary();
        Object completedJobNumStr = completedJobs.size() == appSummary.numCompletedJobs() ? String.valueOf(BoxesRunTime.boxToInteger((int)completedJobs.size())) : appSummary.numCompletedJobs() + ", only showing " + completedJobs.size();
        String schedulingMode = (String)this.store.environmentInfo().sparkProperties().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).get((Object)org.apache.spark.internal.config.package$.MODULE$.SCHEDULER_MODE().key()).map((Function1 & Serializable)mode -> SchedulingMode$.MODULE$.withName(mode.toUpperCase(Locale.ROOT)).toString()).getOrElse((Function0 & Serializable)() -> "Unknown");
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("list-unstyled"), (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n\n            "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("User:"));
        $buf3.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
        $buf3.$amp$plus((Object)new Text("\n            "));
        $buf3.$amp$plus((Object)this.parent.getSparkUser());
        $buf3.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        $buf2.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("Started At:"));
        $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()));
        $buf5.$amp$plus((Object)new Text("\n            "));
        $buf5.$amp$plus((Object)UIUtils$.MODULE$.formatDate(startDate));
        $buf5.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
        $buf2.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Total Uptime:"));
        $buf7.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf8.toVector()));
        $buf7.$amp$plus((Object)new Text("\n            "));
        $buf7.$amp$plus((Object)(endTime < 0L && this.parent.sc().isDefined() ? UIUtils$.MODULE$.formatDuration(System.currentTimeMillis() - startTime) : (endTime > 0L ? UIUtils$.MODULE$.formatDuration(endTime - startTime) : BoxedUnit.UNIT)));
        $buf7.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
        $buf2.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n            "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("Scheduling Mode: "));
        $buf9.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf10.toVector()));
        $buf9.$amp$plus((Object)new Text("\n            "));
        $buf9.$amp$plus((Object)schedulingMode);
        $buf9.$amp$plus((Object)new Text("\n          "));
        $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf9.toVector()));
        $buf2.$amp$plus((Object)new Text("\n          "));
        if (shouldShowActiveJobs) {
            NodeBuffer $buf11 = new NodeBuffer();
            $buf11.$amp$plus((Object)new Text("\n                "));
            Null$ $md2 = Null$.MODULE$;
            $md2 = new UnprefixedAttribute("href", (Seq)new Text("#active"), (MetaData)$md2);
            NodeBuffer $buf12 = new NodeBuffer();
            NodeBuffer $buf13 = new NodeBuffer();
            $buf13.$amp$plus((Object)new Text("Active Jobs:"));
            $buf12.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf13.toVector()));
            $buf11.$amp$plus((Object)new Elem(null, "a", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf12.toVector()));
            $buf11.$amp$plus((Object)new Text("\n                "));
            $buf11.$amp$plus((Object)BoxesRunTime.boxToInteger((int)activeJobs.size()));
            $buf11.$amp$plus((Object)new Text("\n              "));
            Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf11.toVector());
            boxedUnit3 = elem;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        $buf2.$amp$plus((Object)boxedUnit3);
        $buf2.$amp$plus((Object)new Text("\n          "));
        if (shouldShowCompletedJobs) {
            Null$ $md3 = Null$.MODULE$;
            $md3 = new UnprefixedAttribute("id", (Seq)new Text("completed-summary"), (MetaData)$md3);
            NodeBuffer $buf14 = new NodeBuffer();
            $buf14.$amp$plus((Object)new Text("\n                "));
            Null$ $md4 = Null$.MODULE$;
            $md4 = new UnprefixedAttribute("href", (Seq)new Text("#completed"), (MetaData)$md4);
            NodeBuffer $buf15 = new NodeBuffer();
            NodeBuffer $buf16 = new NodeBuffer();
            $buf16.$amp$plus((Object)new Text("Completed Jobs:"));
            $buf15.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf16.toVector()));
            $buf14.$amp$plus((Object)new Elem(null, "a", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf15.toVector()));
            $buf14.$amp$plus((Object)new Text("\n                "));
            $buf14.$amp$plus(completedJobNumStr);
            $buf14.$amp$plus((Object)new Text("\n              "));
            Elem elem = new Elem(null, "li", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf14.toVector());
            boxedUnit2 = elem;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        $buf2.$amp$plus((Object)boxedUnit2);
        $buf2.$amp$plus((Object)new Text("\n          "));
        if (shouldShowFailedJobs) {
            NodeBuffer $buf17 = new NodeBuffer();
            $buf17.$amp$plus((Object)new Text("\n                "));
            Null$ $md5 = Null$.MODULE$;
            $md5 = new UnprefixedAttribute("href", (Seq)new Text("#failed"), (MetaData)$md5);
            NodeBuffer $buf18 = new NodeBuffer();
            NodeBuffer $buf19 = new NodeBuffer();
            $buf19.$amp$plus((Object)new Text("Failed Jobs:"));
            $buf18.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf19.toVector()));
            $buf17.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf18.toVector()));
            $buf17.$amp$plus((Object)new Text("\n                "));
            $buf17.$amp$plus((Object)BoxesRunTime.boxToInteger((int)failedJobs.size()));
            $buf17.$amp$plus((Object)new Text("\n              "));
            Elem elem = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf17.toVector());
            boxedUnit = elem;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        $buf2.$amp$plus((Object)boxedUnit);
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem summary = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector());
        ObjectRef content = ObjectRef.create((Object)summary);
        content.elem = ((NodeSeq)content.elem).$plus$plus(this.makeTimeline((scala.collection.immutable.Seq<JobData>)((IterableOnceOps)((IterableOps)activeJobs.$plus$plus((IterableOnce)completedJobs)).$plus$plus((IterableOnce)failedJobs)).toSeq(), this.store.executorList(false), startTime));
        if (shouldShowActiveJobs) {
            NodeSeq nodeSeq = (NodeSeq)content.elem;
            Null$ $md6 = Null$.MODULE$;
            $md6 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-activeJobs','aggregated-activeJobs')"), (MetaData)$md6);
            $md6 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-activeJobs collapse-table"), (MetaData)$md6);
            $md6 = new UnprefixedAttribute("id", (Seq)new Text("active"), (MetaData)$md6);
            NodeBuffer $buf20 = new NodeBuffer();
            $buf20.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf21 = new NodeBuffer();
            $buf21.$amp$plus((Object)new Text("\n            "));
            Null$ $md7 = Null$.MODULE$;
            $md7 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md7);
            $buf21.$amp$plus((Object)new Elem(null, "span", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf21.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf22 = new NodeBuffer();
            $buf22.$amp$plus((Object)new Text("Active Jobs ("));
            $buf22.$amp$plus((Object)BoxesRunTime.boxToInteger((int)activeJobs.size()));
            $buf22.$amp$plus((Object)new Text(")"));
            $buf21.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf22.toVector()));
            $buf21.$amp$plus((Object)new Text("\n          "));
            $buf20.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf21.toVector()));
            $buf20.$amp$plus((Object)new Text("\n        "));
            Elem elem = new Elem(null, "span", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf20.toVector());
            Null$ $md8 = Null$.MODULE$;
            $md8 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-activeJobs collapsible-table"), (MetaData)$md8);
            NodeBuffer $buf23 = new NodeBuffer();
            $buf23.$amp$plus((Object)new Text("\n          "));
            $buf23.$amp$plus(activeJobsTable);
            $buf23.$amp$plus((Object)new Text("\n        "));
            content.elem = nodeSeq.$plus$plus((scala.collection.immutable.Seq)elem.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf23.toVector())));
        }
        if (shouldShowCompletedJobs) {
            NodeSeq nodeSeq = (NodeSeq)content.elem;
            Null$ $md9 = Null$.MODULE$;
            $md9 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-completedJobs','aggregated-completedJobs')"), (MetaData)$md9);
            $md9 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-completedJobs collapse-table"), (MetaData)$md9);
            $md9 = new UnprefixedAttribute("id", (Seq)new Text("completed"), (MetaData)$md9);
            NodeBuffer $buf24 = new NodeBuffer();
            $buf24.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf25 = new NodeBuffer();
            $buf25.$amp$plus((Object)new Text("\n            "));
            Null$ $md10 = Null$.MODULE$;
            $md10 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md10);
            $buf25.$amp$plus((Object)new Elem(null, "span", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf25.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf26 = new NodeBuffer();
            $buf26.$amp$plus((Object)new Text("Completed Jobs ("));
            $buf26.$amp$plus(completedJobNumStr);
            $buf26.$amp$plus((Object)new Text(")"));
            $buf25.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf26.toVector()));
            $buf25.$amp$plus((Object)new Text("\n          "));
            $buf24.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf25.toVector()));
            $buf24.$amp$plus((Object)new Text("\n        "));
            Elem elem = new Elem(null, "span", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf24.toVector());
            Null$ $md11 = Null$.MODULE$;
            $md11 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-completedJobs collapsible-table"), (MetaData)$md11);
            NodeBuffer $buf27 = new NodeBuffer();
            $buf27.$amp$plus((Object)new Text("\n          "));
            $buf27.$amp$plus(completedJobsTable);
            $buf27.$amp$plus((Object)new Text("\n        "));
            content.elem = nodeSeq.$plus$plus((scala.collection.immutable.Seq)elem.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf27.toVector())));
        }
        if (shouldShowFailedJobs) {
            NodeSeq nodeSeq = (NodeSeq)content.elem;
            Null$ $md12 = Null$.MODULE$;
            $md12 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-failedJobs','aggregated-failedJobs')"), (MetaData)$md12);
            $md12 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-failedJobs collapse-table"), (MetaData)$md12);
            $md12 = new UnprefixedAttribute("id", (Seq)new Text("failed"), (MetaData)$md12);
            NodeBuffer $buf28 = new NodeBuffer();
            $buf28.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf29 = new NodeBuffer();
            $buf29.$amp$plus((Object)new Text("\n            "));
            Null$ $md13 = Null$.MODULE$;
            $md13 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md13);
            $buf29.$amp$plus((Object)new Elem(null, "span", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
            $buf29.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf30 = new NodeBuffer();
            $buf30.$amp$plus((Object)new Text("Failed Jobs ("));
            $buf30.$amp$plus((Object)BoxesRunTime.boxToInteger((int)failedJobs.size()));
            $buf30.$amp$plus((Object)new Text(")"));
            $buf29.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf30.toVector()));
            $buf29.$amp$plus((Object)new Text("\n          "));
            $buf28.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf29.toVector()));
            $buf28.$amp$plus((Object)new Text("\n        "));
            Elem elem = new Elem(null, "span", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf28.toVector());
            Null$ $md14 = Null$.MODULE$;
            $md14 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-failedJobs collapsible-table"), (MetaData)$md14);
            NodeBuffer $buf31 = new NodeBuffer();
            $buf31.$amp$plus((Object)new Text("\n        "));
            $buf31.$amp$plus(failedJobsTable);
            $buf31.$amp$plus((Object)new Text("\n      "));
            content.elem = nodeSeq.$plus$plus((scala.collection.immutable.Seq)elem.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf31.toVector())));
        }
        String helpText = "A job is triggered by an action, like count() or saveAsTextFile(). Click on a job to see information about the stages of tasks inside it.";
        return UIUtils$.MODULE$.headerSparkPage(request, "Spark Jobs", (Function0<scala.collection.immutable.Seq<Node>>)(Function0 & Serializable)() -> (NodeSeq)content$1.elem, this.parent, (Option<String>)new Some((Object)helpText), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7());
    }

    public static final /* synthetic */ boolean $anonfun$JOBS_LEGEND$1(char x$1) {
        return x$1 != '\n';
    }

    public static final /* synthetic */ boolean $anonfun$EXECUTORS_LEGEND$1(char x$2) {
        return x$2 != '\n';
    }

    public static final /* synthetic */ boolean $anonfun$makeJobEvent$1(JobData job) {
        JobExecutionStatus jobExecutionStatus = job.status();
        JobExecutionStatus jobExecutionStatus2 = JobExecutionStatus.UNKNOWN;
        return (jobExecutionStatus == null ? jobExecutionStatus2 != null : !((Object)((Object)jobExecutionStatus)).equals((Object)jobExecutionStatus2)) && job.submissionTime().isDefined();
    }

    public static final /* synthetic */ long $anonfun$makeExecutorEvent$1(ExecutorSummary e) {
        return BoxesRunTime.unboxToLong((Object)e.removeTime().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> e.addTime().getTime()));
    }

    public static final /* synthetic */ void $anonfun$makeExecutorEvent$4(ListBuffer events$1, ExecutorSummary e) {
        String addedEvent = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |{\n           |  'className': 'executor added',\n           |  'group': 'executors',\n           |  'start': new Date(" + e.addTime().getTime() + "),\n           |  'content': '<div class=\"executor-event-content\"' +\n           |    'data-toggle=\"tooltip\" data-placement=\"top\"' +\n           |    'data-title=\"Executor " + e.id() + "<br>' +\n           |    'Added at " + UIUtils$.MODULE$.formatDate(e.addTime()) + "\"' +\n           |    'data-html=\"true\">Executor " + e.id() + " added</div>'\n           |}\n         "));
        events$1.$plus$eq((Object)addedEvent);
        e.removeTime().foreach((Function1 & Serializable)removeTime -> {
            String removedEvent = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |{\n             |  'className': 'executor removed',\n             |  'group': 'executors',\n             |  'start': new Date(" + removeTime.getTime() + "),\n             |  'content': '<div class=\"executor-event-content\"' +\n             |    'data-toggle=\"tooltip\" data-placement=\"top\"' +\n             |    'data-title=\"Executor " + e.id() + "<br>' +\n             |    'Removed at " + UIUtils$.MODULE$.formatDate((Date)removeTime) + "' +\n             |    '" + e.removeReason().map((Function1 & Serializable)reason -> "<br>Reason: " + StringEscapeUtils.escapeEcmaScript((String)reason.replace("\n", " "))).getOrElse((Function0 & Serializable)() -> "") + "\"' +\n             |    'data-html=\"true\">Executor " + e.id() + " removed</div>'\n             |}\n           "));
            return (ListBuffer)events$1.$plus$eq((Object)removedEvent);
        });
    }

    public static final /* synthetic */ boolean $anonfun$jobsTable$1(JobData x$6) {
        return x$6.jobGroup().isDefined();
    }

    public AllJobsPage(JobsTab parent, AppStatusStore store) {
        this.parent = parent;
        this.store = store;
        super("");
        this.TIMELINE_ENABLED = BoxesRunTime.unboxToBoolean((Object)parent.conf().get(UI$.MODULE$.UI_TIMELINE_ENABLED()));
        this.MAX_TIMELINE_JOBS = BoxesRunTime.unboxToInt((Object)parent.conf().get(UI$.MODULE$.UI_TIMELINE_JOBS_MAXIMUM()));
        this.MAX_TIMELINE_EXECUTORS = BoxesRunTime.unboxToInt((Object)parent.conf().get(UI$.MODULE$.UI_TIMELINE_EXECUTORS_MAXIMUM()));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("height", (Seq)new Text("85px"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("width", (Seq)new Text("150px"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("y", (Seq)new Text("5px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("succeeded-job-legend"), (MetaData)$md3);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("y", (Seq)new Text("17px"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md4);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Succeeded"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf3.toVector()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("y", (Seq)new Text("30px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("failed-job-legend"), (MetaData)$md5);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("y", (Seq)new Text("42px"), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md6);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Failed"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf4.toVector()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("y", (Seq)new Text("55px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("running-job-legend"), (MetaData)$md7);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("y", (Seq)new Text("67px"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md8);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Running"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf5.toVector()));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "svg", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf2.toVector()));
        this.JOBS_LEGEND = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf.toVector()).toString()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$JOBS_LEGEND$1(BoxesRunTime.unboxToChar((Object)x$1))));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md9);
        NodeBuffer $buf6 = new NodeBuffer();
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("height", (Seq)new Text("55px"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("width", (Seq)new Text("150px"), (MetaData)$md10);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("y", (Seq)new Text("5px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("class", (Seq)new Text("executor-added-legend"), (MetaData)$md11);
        $buf7.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("y", (Seq)new Text("17px"), (MetaData)$md12);
        $md12 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md12);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Added"));
        $buf7.$amp$plus((Object)new Elem(null, "text", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf8.toVector()));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("y", (Seq)new Text("30px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("class", (Seq)new Text("executor-removed-legend"), (MetaData)$md13);
        $buf7.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("y", (Seq)new Text("42px"), (MetaData)$md14);
        $md14 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md14);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Removed"));
        $buf7.$amp$plus((Object)new Elem(null, "text", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf9.toVector()));
        $buf7.$amp$plus((Object)new Text("\n    "));
        $buf6.$amp$plus((Object)new Elem(null, "svg", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf7.toVector()));
        this.EXECUTORS_LEGEND = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(new Elem(null, "div", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)$buf6.toVector()).toString()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AllJobsPage.$anonfun$EXECUTORS_LEGEND$1(BoxesRunTime.unboxToChar((Object)x$2))));
    }
}

