/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.client;

import java.util.concurrent.CompletableFuture;
import org.sparkproject.jetty.client.Connection;
import org.sparkproject.jetty.client.ContentResponse;
import org.sparkproject.jetty.client.Destination;
import org.sparkproject.jetty.client.Request;
import org.sparkproject.jetty.client.Result;
import org.sparkproject.jetty.client.RetainingResponseListener;
import org.sparkproject.jetty.client.internal.HttpContentResponse;

public class CompletableResponseListener
extends RetainingResponseListener {
    private final CompletableFuture<ContentResponse> completable = new CompletableFuture();
    private final Request request;

    public CompletableResponseListener(Request request) {
        this(request, 0x200000);
    }

    public CompletableResponseListener(Request request, int maxLength) {
        super(maxLength);
        this.request = request;
        this.completable.whenComplete(this::handleExternalFailure);
    }

    public Request getRequest() {
        return this.request;
    }

    private void handleExternalFailure(ContentResponse response, Throwable failure) {
        if (failure != null) {
            this.request.abort(failure);
        }
    }

    public CompletableFuture<ContentResponse> send() {
        this.request.send(this);
        return this.completable;
    }

    public CompletableFuture<ContentResponse> send(Destination destination) {
        destination.send(this.request, this);
        return this.completable;
    }

    public CompletableFuture<ContentResponse> send(Connection connection) {
        connection.send(this.request, this);
        return this.completable;
    }

    @Override
    public void onComplete(Result result) {
        if (result.isFailed()) {
            this.completable.completeExceptionally(result.getFailure());
        } else {
            this.completable.complete(new HttpContentResponse(result.getResponse(), this.getContent(), this.getMediaType(), this.getEncoding()));
        }
    }
}

