/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.server;

import org.sparkproject.jetty.http.HostPortHttpField;
import org.sparkproject.jetty.http.HttpFields;
import org.sparkproject.jetty.http.HttpHeader;
import org.sparkproject.jetty.http.HttpURI;
import org.sparkproject.jetty.http.HttpVersion;
import org.sparkproject.jetty.server.HttpConfiguration;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.util.URIUtil;

public class HostHeaderCustomizer
implements HttpConfiguration.Customizer {
    private final String serverName;
    private final int serverPort;

    public HostHeaderCustomizer() {
        this(null, 0);
    }

    public HostHeaderCustomizer(String serverName) {
        this(serverName, 0);
    }

    public HostHeaderCustomizer(String serverName, int serverPort) {
        this.serverName = serverName;
        this.serverPort = serverPort;
    }

    @Override
    public Request customize(Request request, HttpFields.Mutable responseHeaders) {
        if (request.getConnectionMetaData().getHttpVersion() == HttpVersion.HTTP_1_1 || request.getHeaders().contains(HttpHeader.HOST)) {
            return request;
        }
        String host = this.serverName == null ? Request.getServerName(request) : this.serverName;
        int port = URIUtil.normalizePortForScheme(request.getHttpURI().getScheme(), this.serverPort == 0 ? Request.getServerPort(request) : this.serverPort);
        final HttpURI uri = this.serverName != null || this.serverPort > 0 ? HttpURI.build(request.getHttpURI()).authority(host, port).asImmutable() : request.getHttpURI();
        HttpFields original = request.getHeaders();
        HttpFields.Mutable builder = HttpFields.build(original.size() + 1);
        builder.add(new HostPortHttpField(host, port));
        builder.add(request.getHeaders());
        final HttpFields headers = builder.asImmutable();
        return new Request.Wrapper(this, request){
            final /* synthetic */ HostHeaderCustomizer this$0;
            {
                this.this$0 = this$0;
                super(wrapped);
            }

            @Override
            public HttpURI getHttpURI() {
                return uri;
            }

            @Override
            public HttpFields getHeaders() {
                return headers;
            }
        };
    }
}

