/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.util.component;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.sparkproject.jetty.util.Attributes;
import org.sparkproject.jetty.util.TypeUtil;
import org.sparkproject.jetty.util.component.ClassLoaderDump;
import org.sparkproject.jetty.util.component.Dumpable;
import org.sparkproject.jetty.util.component.DumpableCollection;
import org.sparkproject.jetty.util.component.Environment;

class NamedEnvironment
extends Attributes.Mapped
implements Environment,
Dumpable {
    static final Map<String, Environment> ENVIRONMENTS = new ConcurrentSkipListMap<String, Environment>(String.CASE_INSENSITIVE_ORDER);
    static final ClassLoader DEFAULT_CLASSLOADER = NamedEnvironment.class.getClassLoader();
    private final String _name;
    private final ClassLoader _classLoader;

    NamedEnvironment(String name, ClassLoader classLoader) {
        this._name = name;
        this._classLoader = classLoader == null ? DEFAULT_CLASSLOADER : classLoader;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, new ClassLoaderDump(this.getClassLoader()), new DumpableCollection("Attributes " + this._name, this.asAttributeMap().entrySet()));
    }

    @Override
    public int hashCode() {
        return this._name.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public String toString() {
        return "%s@%x{%s}".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this._name);
    }
}

