/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.batch.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.batch.v1beta1.CronJobSpec;
import io.fabric8.kubernetes.api.model.batch.v1beta1.JobTemplateSpec;
import io.fabric8.kubernetes.api.model.batch.v1beta1.JobTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.batch.v1beta1.JobTemplateSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CronJobSpecFluent<A extends CronJobSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String concurrencyPolicy;
    private Integer failedJobsHistoryLimit;
    private JobTemplateSpecBuilder jobTemplate;
    private String schedule;
    private Long startingDeadlineSeconds;
    private Integer successfulJobsHistoryLimit;
    private Boolean suspend;

    public CronJobSpecFluent() {
    }

    public CronJobSpecFluent(CronJobSpec instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public JobTemplateSpec buildJobTemplate() {
        return this.jobTemplate != null ? this.jobTemplate.build() : null;
    }

    protected void copyInstance(CronJobSpec instance) {
        CronJobSpec cronJobSpec = instance = instance != null ? instance : new CronJobSpec();
        if (instance != null) {
            this.withConcurrencyPolicy(instance.getConcurrencyPolicy());
            this.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit());
            this.withJobTemplate(instance.getJobTemplate());
            this.withSchedule(instance.getSchedule());
            this.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds());
            this.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit());
            this.withSuspend(instance.getSuspend());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public JobTemplateNested<A> editJobTemplate() {
        return this.withNewJobTemplateLike(Optional.ofNullable(this.buildJobTemplate()).orElse(null));
    }

    public JobTemplateNested<A> editOrNewJobTemplate() {
        return this.withNewJobTemplateLike(Optional.ofNullable(this.buildJobTemplate()).orElse(new JobTemplateSpecBuilder().build()));
    }

    public JobTemplateNested<A> editOrNewJobTemplateLike(JobTemplateSpec item) {
        return this.withNewJobTemplateLike(Optional.ofNullable(this.buildJobTemplate()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CronJobSpecFluent that = (CronJobSpecFluent)((Object)o);
        if (!Objects.equals(this.concurrencyPolicy, that.concurrencyPolicy)) {
            return false;
        }
        if (!Objects.equals(this.failedJobsHistoryLimit, that.failedJobsHistoryLimit)) {
            return false;
        }
        if (!Objects.equals((Object)this.jobTemplate, (Object)that.jobTemplate)) {
            return false;
        }
        if (!Objects.equals(this.schedule, that.schedule)) {
            return false;
        }
        if (!Objects.equals(this.startingDeadlineSeconds, that.startingDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.successfulJobsHistoryLimit, that.successfulJobsHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.suspend, that.suspend)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getConcurrencyPolicy() {
        return this.concurrencyPolicy;
    }

    public Integer getFailedJobsHistoryLimit() {
        return this.failedJobsHistoryLimit;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public Long getStartingDeadlineSeconds() {
        return this.startingDeadlineSeconds;
    }

    public Integer getSuccessfulJobsHistoryLimit() {
        return this.successfulJobsHistoryLimit;
    }

    public Boolean getSuspend() {
        return this.suspend;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasConcurrencyPolicy() {
        return this.concurrencyPolicy != null;
    }

    public boolean hasFailedJobsHistoryLimit() {
        return this.failedJobsHistoryLimit != null;
    }

    public boolean hasJobTemplate() {
        return this.jobTemplate != null;
    }

    public boolean hasSchedule() {
        return this.schedule != null;
    }

    public boolean hasStartingDeadlineSeconds() {
        return this.startingDeadlineSeconds != null;
    }

    public boolean hasSuccessfulJobsHistoryLimit() {
        return this.successfulJobsHistoryLimit != null;
    }

    public boolean hasSuspend() {
        return this.suspend != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.concurrencyPolicy, this.failedJobsHistoryLimit, this.jobTemplate, this.schedule, this.startingDeadlineSeconds, this.successfulJobsHistoryLimit, this.suspend, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.concurrencyPolicy != null) {
            sb.append("concurrencyPolicy:");
            sb.append(this.concurrencyPolicy);
            sb.append(",");
        }
        if (this.failedJobsHistoryLimit != null) {
            sb.append("failedJobsHistoryLimit:");
            sb.append(this.failedJobsHistoryLimit);
            sb.append(",");
        }
        if (this.jobTemplate != null) {
            sb.append("jobTemplate:");
            sb.append((Object)this.jobTemplate);
            sb.append(",");
        }
        if (this.schedule != null) {
            sb.append("schedule:");
            sb.append(this.schedule);
            sb.append(",");
        }
        if (this.startingDeadlineSeconds != null) {
            sb.append("startingDeadlineSeconds:");
            sb.append(this.startingDeadlineSeconds);
            sb.append(",");
        }
        if (this.successfulJobsHistoryLimit != null) {
            sb.append("successfulJobsHistoryLimit:");
            sb.append(this.successfulJobsHistoryLimit);
            sb.append(",");
        }
        if (this.suspend != null) {
            sb.append("suspend:");
            sb.append(this.suspend);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withConcurrencyPolicy(String concurrencyPolicy) {
        this.concurrencyPolicy = concurrencyPolicy;
        return (A)((Object)this);
    }

    public A withFailedJobsHistoryLimit(Integer failedJobsHistoryLimit) {
        this.failedJobsHistoryLimit = failedJobsHistoryLimit;
        return (A)((Object)this);
    }

    public A withJobTemplate(JobTemplateSpec jobTemplate) {
        this._visitables.remove((Object)"jobTemplate");
        if (jobTemplate != null) {
            this.jobTemplate = new JobTemplateSpecBuilder(jobTemplate);
            this._visitables.get((Object)"jobTemplate").add(this.jobTemplate);
        } else {
            this.jobTemplate = null;
            this._visitables.get((Object)"jobTemplate").remove((Object)this.jobTemplate);
        }
        return (A)((Object)this);
    }

    public JobTemplateNested<A> withNewJobTemplate() {
        return new JobTemplateNested(null);
    }

    public JobTemplateNested<A> withNewJobTemplateLike(JobTemplateSpec item) {
        return new JobTemplateNested(item);
    }

    public A withSchedule(String schedule) {
        this.schedule = schedule;
        return (A)((Object)this);
    }

    public A withStartingDeadlineSeconds(Long startingDeadlineSeconds) {
        this.startingDeadlineSeconds = startingDeadlineSeconds;
        return (A)((Object)this);
    }

    public A withSuccessfulJobsHistoryLimit(Integer successfulJobsHistoryLimit) {
        this.successfulJobsHistoryLimit = successfulJobsHistoryLimit;
        return (A)((Object)this);
    }

    public A withSuspend() {
        return this.withSuspend(true);
    }

    public A withSuspend(Boolean suspend) {
        this.suspend = suspend;
        return (A)((Object)this);
    }

    public class JobTemplateNested<N>
    extends JobTemplateSpecFluent<JobTemplateNested<N>>
    implements Nested<N> {
        JobTemplateSpecBuilder builder;

        JobTemplateNested(JobTemplateSpec item) {
            this.builder = new JobTemplateSpecBuilder(this, item);
        }

        public N and() {
            return (N)CronJobSpecFluent.this.withJobTemplate(this.builder.build());
        }

        public N endJobTemplate() {
            return this.and();
        }
    }
}

