/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.org.apache.arrow.vector.complex.impl;

import org.sparkproject.org.apache.arrow.vector.TimeMicroVector;
import org.sparkproject.org.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import org.sparkproject.org.apache.arrow.vector.holders.NullableTimeMicroHolder;
import org.sparkproject.org.apache.arrow.vector.holders.TimeMicroHolder;
import org.sparkproject.org.apache.arrow.vector.types.pojo.Field;

public class TimeMicroWriterImpl
extends AbstractFieldWriter {
    final TimeMicroVector vector;

    public TimeMicroWriterImpl(TimeMicroVector vector) {
        this.vector = vector;
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(TimeMicroHolder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    public void write(NullableTimeMicroHolder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeTimeMicro(long value) {
        this.vector.setSafe(this.idx(), 1, value);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.vector.setNull(this.idx());
        this.vector.setValueCount(this.idx() + 1);
    }
}

