/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.Add$;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NondeterministicUnaryRDG;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) uniformly distributed values in [0, 1).", examples="\n    Examples:\n      > SELECT _FUNC_();\n       0.9629742951434543\n      > SELECT _FUNC_(0);\n       0.7604953758285915\n      > SELECT _FUNC_(null);\n       0.7604953758285915\n  ", note="\n    The function is non-deterministic in general case.\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001\u0002\u0012$\u0001BB\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0013\"AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005S\u0001\tE\t\u0015!\u0003P\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015\u0019\u0006\u0001\"\u0001Y\u0011\u0015\u0019\u0006\u0001\"\u0001Z\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u00151\u0007\u0001\"\u0015h\u0011\u0015\t\b\u0001\"\u0011s\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aa\u0001\u000b\u0001\u0005B\u0005E\u0001bBA\u0012\u0001\u0011E\u0013Q\u0005\u0005\n\u0003W\u0001\u0011\u0011!C\u0001\u0003[A\u0011\"a\r\u0001#\u0003%\t!!\u000e\t\u0013\u0005-\u0003!%A\u0005\u0002\u00055\u0003\"CA)\u0001\u0005\u0005I\u0011IA*\u0011%\t\u0019\u0007AA\u0001\n\u0003\t)\u0007C\u0005\u0002n\u0001\t\t\u0011\"\u0001\u0002p!I\u0011Q\u000f\u0001\u0002\u0002\u0013\u0005\u0013q\u000f\u0005\n\u0003\u0007\u0003\u0011\u0011!C\u0001\u0003\u000bC\u0011\"!#\u0001\u0003\u0003%\t%a#\t\u0013\u0005=\u0005!!A\u0005B\u0005EuaBA^G!\u0005\u0011Q\u0018\u0004\u0007E\rB\t!a0\t\rMSB\u0011AAi\u0011\u001d\t\u0019N\u0007C\u0001\u0003+D\u0011\"a5\u001b\u0003\u0003%\t)!7\t\u0013\u0005}'$%A\u0005\u0002\u00055\u0003\"CAq5\u0005\u0005I\u0011QAr\u0011%\t)PGI\u0001\n\u0003\ti\u0005C\u0005\u0002xj\t\t\u0011\"\u0003\u0002z\n!!+\u00198e\u0015\t!S%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0014(\u0003!\u0019\u0017\r^1msN$(B\u0001\u0015*\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003U-\nQa\u001d9be.T!\u0001L\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0013aA8sO\u000e\u00011\u0003\u0002\u00012km\u0002\"AM\u001a\u000e\u0003\rJ!\u0001N\u0012\u000319{g\u000eZ3uKJl\u0017N\\5ti&\u001cWK\\1ssJ#u\t\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtGA\u0004Qe>$Wo\u0019;\u0011\u0005q\"eBA\u001fC\u001d\tq\u0014)D\u0001@\u0015\t\u0001u&\u0001\u0004=e>|GOP\u0005\u0002q%\u00111iN\u0001\ba\u0006\u001c7.Y4f\u0013\t)eI\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Do\u0005)1\r[5mIV\t\u0011\n\u0005\u00023\u0015&\u00111j\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0005iS\u0012,7+Z3e+\u0005y\u0005C\u0001\u001cQ\u0013\t\tvGA\u0004C_>dW-\u00198\u0002\u0013!LG-Z*fK\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0002V-^\u0003\"A\r\u0001\t\u000b\u001d+\u0001\u0019A%\t\u000f5+\u0001\u0013!a\u0001\u001fR\tQ\u000b\u0006\u0002V5\")qi\u0002a\u0001\u0013\u0006Yq/\u001b;i\u001d\u0016<8+Z3e)\t)V\fC\u0003_\u0011\u0001\u0007q,\u0001\u0003tK\u0016$\u0007C\u0001\u001ca\u0013\t\twG\u0001\u0003M_:<\u0017aD<ji\"\u001c\u0006.\u001b4uK\u0012\u001cV-\u001a3\u0015\u0005U#\u0007\"B3\n\u0001\u0004y\u0016!B:iS\u001a$\u0018\u0001D3wC2Le\u000e^3s]\u0006dGC\u00015l!\t1\u0014.\u0003\u0002ko\t1Ai\\;cY\u0016DQ\u0001\u001c\u0006A\u00025\fQ!\u001b8qkR\u0004\"A\\8\u000e\u0003\u0015J!\u0001]\u0013\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$2a]=\u007f!\t!x/D\u0001v\u0015\t18%A\u0004d_\u0012,w-\u001a8\n\u0005a,(\u0001C#yaJ\u001cu\u000eZ3\t\u000bi\\\u0001\u0019A>\u0002\u0007\r$\b\u0010\u0005\u0002uy&\u0011Q0\u001e\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015y8\u00021\u0001t\u0003\t)g/A\u0007gY\u0006$\u0018I]4v[\u0016tGo]\u000b\u0003\u0003\u000b\u0001R\u0001PA\u0004\u0003\u0017I1!!\u0003G\u0005!IE/\u001a:bi>\u0014\bc\u0001\u001c\u0002\u000e%\u0019\u0011qB\u001c\u0003\u0007\u0005s\u00170\u0006\u0002\u0002\u0014A!\u0011QCA\u000f\u001d\u0011\t9\"!\u0007\u0011\u0005y:\u0014bAA\u000eo\u00051\u0001K]3eK\u001aLA!a\b\u0002\"\t11\u000b\u001e:j]\u001eT1!a\u00078\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019Q+a\n\t\r\u0005%b\u00021\u0001J\u0003!qWm^\"iS2$\u0017\u0001B2paf$R!VA\u0018\u0003cAqaR\b\u0011\u0002\u0003\u0007\u0011\nC\u0004N\u001fA\u0005\t\u0019A(\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0007\u0016\u0004\u0013\u0006e2FAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015s'\u0001\u0006b]:|G/\u0019;j_:LA!!\u0013\u0002@\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\n\u0016\u0004\u001f\u0006e\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002VA!\u0011qKA1\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013\u0001\u00027b]\u001eT!!a\u0018\u0002\t)\fg/Y\u0005\u0005\u0003?\tI&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002hA\u0019a'!\u001b\n\u0007\u0005-tGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\f\u0005E\u0004\"CA:)\u0005\u0005\t\u0019AA4\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0010\t\u0007\u0003w\n\t)a\u0003\u000e\u0005\u0005u$bAA@o\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u0011QP\u0001\tG\u0006tW)];bYR\u0019q*a\"\t\u0013\u0005Md#!AA\u0002\u0005-\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\u0016\u0002\u000e\"I\u00111O\f\u0002\u0002\u0003\u0007\u0011qM\u0001\u0007KF,\u0018\r\\:\u0015\u0007=\u000b\u0019\nC\u0005\u0002ta\t\t\u00111\u0001\u0002\f!:\u0002!a&\u0002\u001e\u0006}\u00151UAS\u0003S\u000bY+a,\u00022\u0006U\u0016q\u0017\t\u0004e\u0005e\u0015bAANG\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAQ\u0003\u0005-qLR+O\u0007~C3l]3fIvK\u0003%\f\u0011SKR,(O\\:!C\u0002\u0012\u0018M\u001c3p[\u00022\u0018\r\\;fA]LG\u000f\u001b\u0011j]\u0012,\u0007/\u001a8eK:$\b%\u00198eA%$WM\u001c;jG\u0006dG.\u001f\u0011eSN$(/\u001b2vi\u0016$\u0007\u0005K5/S:\"g&\u000b\u0011v]&4wN]7ms\u0002\"\u0017n\u001d;sS\n,H/\u001a3!m\u0006dW/Z:!S:\u00043\f\r\u0017!c%r\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u001d\u0016!a\u0018\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\r\u0018:mIJt\u0007\u000e\u001a:kE\"4\u0007N\u001b5g)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0003'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a9:d\u0007\r\u001b:kM:T\u0007\u000f\u001a9ke\nTG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015ok2d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00111]]2\u0004\u0007N\u001d6g]*\u0004H\r\u001d6sE*$\u0002\t\u0011\u0002\t9|G/Z\u0011\u0003\u0003[\u000b!H\u0003\u0011!A\u0001\"\u0006.\u001a\u0011gk:\u001cG/[8oA%\u001c\bE\\8o[\u0011,G/\u001a:nS:L7\u000f^5dA%t\u0007eZ3oKJ\fG\u000eI2bg\u0016t#\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005M\u0016!B\u0019/k9\u0002\u0014!B4s_V\u0004\u0018EAA]\u0003)i\u0017\r\u001e5`MVt7m]\u0001\u0005%\u0006tG\r\u0005\u000235M)!$!1\u0002HB\u0019a'a1\n\u0007\u0005\u0015wG\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003\u0013\fy-\u0004\u0002\u0002L*!\u0011QZA/\u0003\tIw.C\u0002F\u0003\u0017$\"!!0\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007U\u000b9\u000eC\u0003_9\u0001\u0007q\fF\u0003V\u00037\fi\u000eC\u0003H;\u0001\u0007\u0011\nC\u0004N;A\u0005\t\u0019A(\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002f\u0006E\b#\u0002\u001c\u0002h\u0006-\u0018bAAuo\t1q\n\u001d;j_:\u0004RANAw\u0013>K1!a<8\u0005\u0019!V\u000f\u001d7fe!A\u00111_\u0010\u0002\u0002\u0003\u0007Q+A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAA~!\u0011\t9&!@\n\t\u0005}\u0018\u0011\f\u0002\u0007\u001f\nTWm\u0019;")
public class Rand
extends NondeterministicUnaryRDG
implements Serializable {
    private final Expression child;
    private final boolean hideSeed;

    public static boolean $lessinit$greater$default$2() {
        return Rand$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Rand x$0) {
        return Rand$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return Rand$.MODULE$.apply$default$2();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    @Override
    public Rand withNewSeed(long seed) {
        return new Rand(new Literal(BoxesRunTime.boxToLong((long)seed), (DataType)LongType$.MODULE$), this.hideSeed());
    }

    @Override
    public Rand withShiftedSeed(long shift) {
        return new Rand(Add$.MODULE$.apply(this.child(), (Expression)Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)shift)), EvalMode$.MODULE$.LEGACY()), this.hideSeed());
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextDouble();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(rngTerm + " = new " + className + "(" + this.seed() + "L + partitionIndex);");
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextDouble();"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), rngTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public String sql() {
        return "rand(" + (this.hideSeed() ? "" : this.child().sql()) + ")";
    }

    @Override
    public Rand withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Rand copy(Expression child, boolean hideSeed) {
        return new Rand(child, hideSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.hideSeed();
    }

    @Override
    public String productPrefix() {
        return "Rand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Rand;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "hideSeed";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Rand)) return false;
        boolean bl = true;
        if (!bl) return false;
        Rand rand = (Rand)x$1;
        if (this.hideSeed() != rand.hideSeed()) return false;
        Expression expression = this.child();
        Expression expression2 = rand.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!rand.canEqual(this)) return false;
        return true;
    }

    public Rand(Expression child, boolean hideSeed) {
        this.child = child;
        this.hideSeed = hideSeed;
    }

    public Rand() {
        this(UnresolvedSeed$.MODULE$, true);
    }

    public Rand(Expression child) {
        this(child, false);
    }
}

