/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.ExpressionBuilder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TupleUnionInteger;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.catalyst.plans.logical.InputParameter;
import org.apache.spark.sql.catalyst.plans.logical.InputParameter$;
import org.apache.spark.sql.catalyst.util.TupleSummaryMode$Sum$;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

@ExpressionDescription(usage="\n    _FUNC_(tupleSketch1, tupleSketch2, lgNomEntries, mode) - Merges two binary representations of Datasketches\n    TupleSketch objects with integer summary data type using a TupleSketch Union object. Users can\n    set lgNomEntries to a value between 4 and 26 (defaults to 12) and mode to 'sum', 'min', 'max',\n    or 'alwaysone' (defaults to 'sum'). ", examples="\n    Examples:\n      > SELECT tuple_sketch_estimate_integer(_FUNC_(tuple_sketch_agg_integer(col1, val1), tuple_sketch_agg_integer(col2, val2))) FROM VALUES (1, 1, 4, 4), (2, 2, 5, 5), (3, 3, 6, 6) tab(col1, val1, col2, val2);\n       6.0\n  ", group="sketch_funcs", since="4.2.0")
public final class TupleUnionIntegerExpressionBuilder$
implements ExpressionBuilder {
    public static final TupleUnionIntegerExpressionBuilder$ MODULE$ = new TupleUnionIntegerExpressionBuilder$();
    private static final FunctionSignature defaultFunctionSignature;

    static {
        FunctionBuilderBase.$init$(MODULE$);
        defaultFunctionSignature = new FunctionSignature((Seq<InputParameter>)new .colon.colon((Object)new InputParameter("first", InputParameter$.MODULE$.apply$default$2()), (List)new .colon.colon((Object)new InputParameter("second", InputParameter$.MODULE$.apply$default$2()), (List)new .colon.colon((Object)new InputParameter("lgNomEntries", (Option<Expression>)new Some((Object)Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)12)))), (List)new .colon.colon((Object)new InputParameter("mode", (Option<Expression>)new Some((Object)Literal$.MODULE$.apply(TupleSummaryMode$Sum$.MODULE$.toString()))), (List)Nil$.MODULE$)))));
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName, resolver);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    public final FunctionSignature defaultFunctionSignature() {
        return defaultFunctionSignature;
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return new Some((Object)this.defaultFunctionSignature());
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        Predef$.MODULE$.assert(expressions.size() == 4);
        return new TupleUnionInteger((Expression)expressions.apply(0), (Expression)expressions.apply(1), (Expression)expressions.apply(2), (Expression)expressions.apply(3));
    }

    private TupleUnionIntegerExpressionBuilder$() {
    }
}

