/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function0;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.api.java.function.VoidFunction2;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.examples.streaming.JavaDroppedWordsCounter;
import org.apache.spark.examples.streaming.JavaWordExcludeList;
import org.apache.spark.streaming.Durations;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.util.LongAccumulator;
import scala.Tuple2;

public final class JavaRecoverableNetworkWordCount {
    private static final Pattern SPACE = Pattern.compile(" ");

    private static JavaStreamingContext createContext(String ip, int port, String checkpointDirectory, String outputPath) {
        System.out.println("Creating new context");
        File outputFile = new File(outputPath);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        SparkConf sparkConf = new SparkConf().setAppName("JavaRecoverableNetworkWordCount");
        JavaStreamingContext ssc = new JavaStreamingContext(sparkConf, Durations.seconds((long)1L));
        ssc.checkpoint(checkpointDirectory);
        JavaReceiverInputDStream lines = ssc.socketTextStream(ip, port);
        JavaDStream words = lines.flatMap((FlatMapFunction & Serializable)x -> Arrays.asList(SPACE.split((CharSequence)x)).iterator());
        JavaPairDStream wordCounts = words.mapToPair((PairFunction & Serializable)s -> new Tuple2(s, (Object)1)).reduceByKey((Function2 & Serializable)(i1, i2) -> i1 + i2);
        wordCounts.foreachRDD((VoidFunction2 & Serializable)(rdd, time) -> {
            Broadcast<List<String>> excludeList = JavaWordExcludeList.getInstance(new JavaSparkContext(rdd.context()));
            LongAccumulator droppedWordsCounter = JavaDroppedWordsCounter.getInstance(new JavaSparkContext(rdd.context()));
            String counts = rdd.filter((Function & Serializable)wordCount -> {
                if (((List)excludeList.value()).contains(wordCount._1())) {
                    droppedWordsCounter.add((long)((Integer)wordCount._2()).intValue());
                    return false;
                }
                return true;
            }).collect().toString();
            String output = "Counts at time " + String.valueOf(time) + " " + counts;
            System.out.println(output);
            System.out.println("Dropped " + droppedWordsCounter.value() + " word(s) totally");
            System.out.println("Appending to " + outputFile.getAbsolutePath());
            Files.writeString(outputFile.toPath(), (CharSequence)(output + "\n"), StandardOpenOption.APPEND);
        });
        return ssc;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.err.println("You arguments were " + String.valueOf(Arrays.asList(args)));
            System.err.println("Usage: JavaRecoverableNetworkWordCount <hostname> <port> <checkpoint-directory>\n     <output-file>. <hostname> and <port> describe the TCP server that Spark\n     Streaming would connect to receive data. <checkpoint-directory> directory to\n     HDFS-compatible file system which checkpoint data <output-file> file to which\n     the word counts will be appended\n\nIn local mode, <master> should be 'local[n]' with n > 1\nBoth <checkpoint-directory> and <output-file> must be absolute paths");
            System.exit(1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String checkpointDirectory = args[2];
        String outputPath = args[3];
        Function0 & Serializable createContextFunc = (Function0 & Serializable)() -> JavaRecoverableNetworkWordCount.createContext(ip, port, checkpointDirectory, outputPath);
        JavaStreamingContext ssc = JavaStreamingContext.getOrCreate((String)checkpointDirectory, (Function0)createContextFunc);
        ssc.start();
        ssc.awaitTermination();
    }
}

