/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.runtime.checkpoint.Checkpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.util.function.RunnableWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CheckpointsCleaner
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointsCleaner.class);
    private static final long serialVersionUID = 2545865801947537790L;
    private final AtomicInteger numberOfCheckpointsToClean = new AtomicInteger(0);

    int getNumberOfCheckpointsToClean() {
        return this.numberOfCheckpointsToClean.get();
    }

    public void cleanCheckpoint(Checkpoint checkpoint, boolean shouldDiscard, Runnable postCleanAction, Executor executor) {
        this.cleanup(checkpoint, () -> {
            if (shouldDiscard) {
                checkpoint.discard();
            }
        }, postCleanAction, executor);
    }

    public void cleanCheckpointOnFailedStoring(CompletedCheckpoint completedCheckpoint, Executor executor) {
        this.cleanup(completedCheckpoint, completedCheckpoint::discardOnFailedStoring, () -> {}, executor);
    }

    private void cleanup(Checkpoint checkpoint, RunnableWithException cleanupAction, Runnable postCleanupAction, Executor executor) {
        this.numberOfCheckpointsToClean.incrementAndGet();
        executor.execute(() -> {
            try {
                cleanupAction.run();
            }
            catch (Exception e) {
                LOG.warn("Could not properly discard completed checkpoint {}.", (Object)checkpoint.getCheckpointID(), (Object)e);
            }
            finally {
                this.numberOfCheckpointsToClean.decrementAndGet();
                postCleanupAction.run();
            }
        });
    }
}

