/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.compression.BlockCompressionFactory;
import org.apache.flink.runtime.io.compression.BlockDecompressor;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.buffer.ReadOnlySlicedNetworkBuffer;
import org.apache.flink.util.Preconditions;

public class BufferDecompressor {
    private final BlockDecompressor blockDecompressor;
    private final NetworkBuffer internalBuffer;

    public BufferDecompressor(int bufferSize, String factoryName) {
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)factoryName);
        byte[] heapBuffer = new byte[bufferSize];
        this.internalBuffer = new NetworkBuffer(MemorySegmentFactory.wrap((byte[])heapBuffer), FreeingBufferRecycler.INSTANCE);
        this.blockDecompressor = BlockCompressionFactory.createBlockCompressionFactory(factoryName).getDecompressor();
    }

    public Buffer decompressToIntermediateBuffer(Buffer buffer) {
        int decompressedLen = this.decompress(buffer);
        this.internalBuffer.setSize(decompressedLen);
        return this.internalBuffer.retainBuffer();
    }

    @VisibleForTesting
    public Buffer decompressToOriginalBuffer(Buffer buffer) {
        int decompressedLen = this.decompress(buffer);
        int memorySegmentOffset = buffer.getMemorySegmentOffset();
        MemorySegment segment = buffer.getMemorySegment();
        segment.put(memorySegmentOffset, this.internalBuffer.array(), 0, decompressedLen);
        return new ReadOnlySlicedNetworkBuffer(buffer.asByteBuf(), 0, decompressedLen, memorySegmentOffset, false);
    }

    private int decompress(Buffer buffer) {
        Preconditions.checkArgument((buffer != null ? 1 : 0) != 0, (Object)"The input buffer must not be null.");
        Preconditions.checkArgument((boolean)buffer.isBuffer(), (Object)"Event can not be decompressed.");
        Preconditions.checkArgument((boolean)buffer.isCompressed(), (Object)"Buffer not compressed.");
        Preconditions.checkArgument((buffer.getReaderIndex() == 0 ? 1 : 0) != 0, (Object)"Reader index of the input buffer must be 0.");
        Preconditions.checkArgument((buffer.readableBytes() > 0 ? 1 : 0) != 0, (Object)"No data to be decompressed.");
        Preconditions.checkState((this.internalBuffer.refCnt() == 1 ? 1 : 0) != 0, (Object)"Illegal reference count, buffer need to be released.");
        int length = buffer.getSize();
        return this.blockDecompressor.decompress(buffer.getNioBuffer(0, length), 0, length, this.internalBuffer.getNioBuffer(0, this.internalBuffer.capacity()), 0);
    }
}

