/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.operators.sort.InMemorySorter;
import org.apache.flink.util.TraversableOnceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CombineValueIterator<E>
implements Iterator<E>,
Iterable<E> {
    private static final Logger LOG = LoggerFactory.getLogger(CombineValueIterator.class);
    private final InMemorySorter<E> buffer;
    private final E recordReuse;
    private final boolean objectReuseEnabled;
    private int last;
    private int position;
    private boolean iteratorAvailable;

    public CombineValueIterator(InMemorySorter<E> buffer, E instance, boolean objectReuseEnabled) {
        this.buffer = buffer;
        this.recordReuse = instance;
        this.objectReuseEnabled = objectReuseEnabled;
    }

    public void set(int first, int last) {
        this.last = last;
        this.position = first;
        this.iteratorAvailable = true;
    }

    @Override
    public boolean hasNext() {
        return this.position <= this.last;
    }

    @Override
    public E next() {
        if (this.position <= this.last) {
            try {
                E record = this.objectReuseEnabled ? this.buffer.getRecord(this.recordReuse, this.position) : this.buffer.getRecord(this.position);
                ++this.position;
                return record;
            }
            catch (IOException ioex) {
                LOG.error("Error retrieving a value from a buffer.", (Throwable)ioex);
                throw new RuntimeException("Could not load the next value: " + ioex.getMessage(), ioex);
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        if (this.iteratorAvailable) {
            this.iteratorAvailable = false;
            return this;
        }
        throw new TraversableOnceException();
    }
}

