/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.runtime.operators.sort.CircularElement;
import org.apache.flink.runtime.operators.sort.InMemorySorter;
import org.apache.flink.runtime.operators.sort.LargeRecordHandler;
import org.apache.flink.runtime.operators.sort.StageRunner;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SorterInputGateway<E> {
    private static final Logger LOG = LoggerFactory.getLogger(SorterInputGateway.class);
    private final LargeRecordHandler<E> largeRecords;
    private final StageRunner.StageMessageDispatcher<E> dispatcher;
    private long bytesUntilSpilling;
    private CircularElement<E> currentBuffer;

    SorterInputGateway(StageRunner.StageMessageDispatcher<E> dispatcher, @Nullable LargeRecordHandler<E> largeRecordsHandler, long startSpillingBytes) {
        this.bytesUntilSpilling = startSpillingBytes;
        this.largeRecords = largeRecordsHandler;
        this.dispatcher = (StageRunner.StageMessageDispatcher)Preconditions.checkNotNull(dispatcher);
        if (this.bytesUntilSpilling < 1L) {
            this.dispatcher.send(StageRunner.SortStage.SORT, CircularElement.spillingMarker());
        }
    }

    public void writeRecord(E record) throws IOException, InterruptedException {
        if (this.currentBuffer == null) {
            this.currentBuffer = this.dispatcher.take(StageRunner.SortStage.READ);
            if (!this.currentBuffer.getBuffer().isEmpty()) {
                throw new IOException("New buffer is not empty.");
            }
        }
        InMemorySorter<E> sorter = this.currentBuffer.getBuffer();
        long occupancyPreWrite = sorter.getOccupancy();
        if (!sorter.write(record)) {
            boolean isLarge;
            long recordSize = sorter.getCapacity() - occupancyPreWrite;
            this.signalSpillingIfNecessary(recordSize);
            boolean bl = isLarge = occupancyPreWrite == 0L;
            if (isLarge) {
                this.writeLarge(record, sorter);
                this.currentBuffer.getBuffer().reset();
            } else {
                this.dispatcher.send(StageRunner.SortStage.SORT, this.currentBuffer);
                this.currentBuffer = null;
                this.writeRecord(record);
            }
        } else {
            long recordSize = sorter.getOccupancy() - occupancyPreWrite;
            this.signalSpillingIfNecessary(recordSize);
        }
    }

    public void finishReading() {
        if (this.currentBuffer != null && !this.currentBuffer.getBuffer().isEmpty()) {
            this.dispatcher.send(StageRunner.SortStage.SORT, this.currentBuffer);
        }
        CircularElement EOF_MARKER = CircularElement.endMarker();
        this.dispatcher.send(StageRunner.SortStage.SORT, EOF_MARKER);
        LOG.debug("Reading thread done.");
    }

    private void writeLarge(E record, InMemorySorter<E> sorter) throws IOException {
        if (this.largeRecords == null) {
            throw new IOException("The record exceeds the maximum size of a sort buffer (current maximum: " + sorter.getCapacity() + " bytes).");
        }
        LOG.debug("Large record did not fit into a fresh sort buffer. Putting into large record store.");
        this.largeRecords.addRecord(record);
    }

    private void signalSpillingIfNecessary(long writtenSize) {
        if (this.bytesUntilSpilling <= 0L) {
            return;
        }
        this.bytesUntilSpilling -= writtenSize;
        if (this.bytesUntilSpilling < 1L) {
            this.dispatcher.send(StageRunner.SortStage.SORT, CircularElement.spillingMarker());
            this.bytesUntilSpilling = 0L;
        }
    }
}

