/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.adapter.DefaultExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ConsumerVertexGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.scheduler.strategy.SchedulingResultPartition;
import org.apache.flink.util.IterableUtils;
import org.apache.flink.util.Preconditions;

class DefaultResultPartition
implements SchedulingResultPartition {
    private final IntermediateResultPartitionID resultPartitionId;
    private final IntermediateDataSetID intermediateDataSetId;
    private final ResultPartitionType partitionType;
    private final Supplier<ResultPartitionState> resultPartitionStateSupplier;
    private DefaultExecutionVertex producer;
    private final List<ConsumerVertexGroup> consumerVertexGroups;
    private final Function<ExecutionVertexID, DefaultExecutionVertex> executionVertexRetriever;
    private final Supplier<List<ConsumedPartitionGroup>> consumerPartitionGroupSupplier;

    DefaultResultPartition(IntermediateResultPartitionID partitionId, IntermediateDataSetID intermediateDataSetId, ResultPartitionType partitionType, Supplier<ResultPartitionState> resultPartitionStateSupplier, List<ConsumerVertexGroup> consumerVertexGroups, Function<ExecutionVertexID, DefaultExecutionVertex> executionVertexRetriever, Supplier<List<ConsumedPartitionGroup>> consumerPartitionGroupSupplier) {
        this.resultPartitionId = (IntermediateResultPartitionID)Preconditions.checkNotNull((Object)partitionId);
        this.intermediateDataSetId = (IntermediateDataSetID)Preconditions.checkNotNull((Object)intermediateDataSetId);
        this.partitionType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)partitionType)));
        this.resultPartitionStateSupplier = (Supplier)Preconditions.checkNotNull(resultPartitionStateSupplier);
        this.consumerVertexGroups = consumerVertexGroups;
        this.executionVertexRetriever = executionVertexRetriever;
        this.consumerPartitionGroupSupplier = consumerPartitionGroupSupplier;
    }

    @VisibleForTesting
    DefaultResultPartition(IntermediateResultPartitionID partitionId, IntermediateDataSetID intermediateDataSetId, ResultPartitionType partitionType, Supplier<ResultPartitionState> resultPartitionStateSupplier) {
        this(partitionId, intermediateDataSetId, partitionType, resultPartitionStateSupplier, null, null, null);
    }

    @Override
    public IntermediateResultPartitionID getId() {
        return this.resultPartitionId;
    }

    @Override
    public IntermediateDataSetID getResultId() {
        return this.intermediateDataSetId;
    }

    @Override
    public ResultPartitionType getResultType() {
        return this.partitionType;
    }

    @Override
    public ResultPartitionState getState() {
        return this.resultPartitionStateSupplier.get();
    }

    @Override
    public DefaultExecutionVertex getProducer() {
        return this.producer;
    }

    @Override
    public Iterable<DefaultExecutionVertex> getConsumers() {
        return IterableUtils.flatMap(this.consumerVertexGroups, this.executionVertexRetriever);
    }

    @Override
    public List<ConsumerVertexGroup> getConsumerVertexGroups() {
        return this.consumerVertexGroups;
    }

    @Override
    public List<ConsumedPartitionGroup> getConsumedPartitionGroups() {
        return this.consumerPartitionGroupSupplier.get();
    }

    void setProducer(DefaultExecutionVertex vertex) {
        this.producer = (DefaultExecutionVertex)Preconditions.checkNotNull((Object)vertex);
    }
}

