/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.changelog;

import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.changelog.ChangelogStateHandle;
import org.apache.flink.shaded.guava30.com.google.common.io.Closer;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

@Internal
public interface ChangelogStateBackendHandle
extends KeyedStateHandle {
    public List<KeyedStateHandle> getMaterializedStateHandles();

    public List<ChangelogStateHandle> getNonMaterializedStateHandles();

    public static class ChangelogStateBackendHandleImpl
    implements ChangelogStateBackendHandle {
        private static final long serialVersionUID = 1L;
        private final List<KeyedStateHandle> materialized;
        private final List<ChangelogStateHandle> nonMaterialized;
        private final KeyGroupRange keyGroupRange;

        public ChangelogStateBackendHandleImpl(List<KeyedStateHandle> materialized, List<ChangelogStateHandle> nonMaterialized, KeyGroupRange keyGroupRange) {
            this.materialized = Collections.unmodifiableList(materialized);
            this.nonMaterialized = Collections.unmodifiableList(nonMaterialized);
            this.keyGroupRange = keyGroupRange;
            Preconditions.checkArgument((keyGroupRange.getNumberOfKeyGroups() > 0 ? 1 : 0) != 0);
        }

        @Override
        public void registerSharedStates(SharedStateRegistry stateRegistry) {
            stateRegistry.registerAll(this.materialized);
            stateRegistry.registerAll(this.nonMaterialized);
        }

        @Override
        public void discardState() throws Exception {
            try (Closer closer = Closer.create();){
                this.materialized.forEach(h -> closer.register(ChangelogStateBackendHandleImpl.asCloseable(h)));
                this.nonMaterialized.forEach(h -> closer.register(ChangelogStateBackendHandleImpl.asCloseable(h)));
            }
        }

        @Override
        public KeyGroupRange getKeyGroupRange() {
            return this.keyGroupRange;
        }

        @Override
        @Nullable
        public KeyedStateHandle getIntersection(KeyGroupRange keyGroupRange) {
            KeyGroupRange intersection = this.keyGroupRange.getIntersection(keyGroupRange);
            if (intersection.getNumberOfKeyGroups() == 0) {
                return null;
            }
            List<KeyedStateHandle> basePart = this.materialized.stream().map(handle -> handle.getIntersection(keyGroupRange)).filter(Objects::nonNull).collect(Collectors.toList());
            List<ChangelogStateHandle> deltaPart = this.nonMaterialized.stream().map(handle -> (ChangelogStateHandle)handle.getIntersection(keyGroupRange)).filter(Objects::nonNull).collect(Collectors.toList());
            return new ChangelogStateBackendHandleImpl(basePart, deltaPart, intersection);
        }

        @Override
        public long getStateSize() {
            return this.materialized.stream().mapToLong(StateObject::getStateSize).sum() + this.nonMaterialized.stream().mapToLong(StateObject::getStateSize).sum();
        }

        @Override
        public List<KeyedStateHandle> getMaterializedStateHandles() {
            return this.materialized;
        }

        @Override
        public List<ChangelogStateHandle> getNonMaterializedStateHandles() {
            return this.nonMaterialized;
        }

        public String toString() {
            return String.format("keyGroupRange=%s, basePartSize=%d, deltaPartSize=%d", this.keyGroupRange, this.materialized.size(), this.nonMaterialized.size());
        }

        private static Closeable asCloseable(KeyedStateHandle h) {
            return () -> {
                try {
                    h.discardState();
                }
                catch (Exception e) {
                    ExceptionUtils.rethrowIOException((Throwable)e);
                }
            };
        }
    }
}

