/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.apache.flink.streaming.runtime.operators.sink.CommitterHandler;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;

abstract class AbstractCommitterHandler<InputT, OutputT, RecoverT>
implements CommitterHandler<InputT, OutputT> {
    private final Deque<InputT> committables = new ArrayDeque<InputT>();
    private final List<RecoverT> recoveredCommittables = new ArrayList<RecoverT>();

    AbstractCommitterHandler() {
    }

    protected void recoveredCommittables(List<RecoverT> recovered) throws IOException {
        this.recoveredCommittables.addAll((Collection)Preconditions.checkNotNull(recovered));
    }

    protected List<RecoverT> prependRecoveredCommittables(List<RecoverT> committables) {
        if (this.recoveredCommittables.isEmpty()) {
            return committables;
        }
        ArrayList<RecoverT> all = new ArrayList<RecoverT>(this.recoveredCommittables.size() + committables.size());
        all.addAll(this.recoveredCommittables);
        all.addAll(committables);
        this.recoveredCommittables.clear();
        return all;
    }

    @Override
    public boolean needsRetry() {
        return !this.recoveredCommittables.isEmpty();
    }

    @Override
    public void retry() throws IOException, InterruptedException {
        this.retry(this.prependRecoveredCommittables(Collections.emptyList()));
    }

    protected abstract void retry(List<RecoverT> var1) throws IOException, InterruptedException;

    @Override
    public List<OutputT> processCommittables(SupplierWithException<List<InputT>, Exception> committableSupplier) throws Exception {
        this.committables.addAll((Collection)committableSupplier.get());
        return Collections.emptyList();
    }

    protected List<InputT> pollCommittables() {
        ArrayList<InputT> committables = new ArrayList<InputT>(this.committables);
        this.committables.clear();
        return committables;
    }

    @Override
    public void close() throws Exception {
        this.committables.clear();
    }
}

