/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.Serializable;
import java.util.Set;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.RedisClient$;
import org.apache.streampark.common.util.RedisEndpoint;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Transaction;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class RedisUtils$
implements Logger {
    public static RedisUtils$ MODULE$;
    private transient org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new RedisUtils$();
    }

    @Override
    public String logName() {
        return Logger.logName$(this);
    }

    @Override
    public org.slf4j.Logger logger() {
        return Logger.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger.logInfo$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger.logDebug$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger.logTrace$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger.logWarn$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logger.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public boolean exists(String key, RedisEndpoint endpoint) {
        return BoxesRunTime.unboxToBoolean(this.doRedis((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x$1.exists(key))), this.doRedis$default$2(), endpoint));
    }

    public boolean hexists(String key, String field, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return BoxesRunTime.unboxToBoolean(this.doRedis((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x$2.hexists(key, field))), func, endpoint));
    }

    public Function0<BoxedUnit> hexists$default$3() {
        return null;
    }

    public String get(String key, RedisEndpoint endpoint) {
        return (String)this.doRedis((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get(key), this.doRedis$default$2(), endpoint);
    }

    public String hget(String key, String field, RedisEndpoint endpoint) {
        return (String)this.doRedis((Function1 & Serializable & scala.Serializable)x$4 -> x$4.hget(key, field), this.doRedis$default$2(), endpoint);
    }

    public String setex(String key, String value, Integer ttl, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return (String)this.doRedis((Function1 & Serializable & scala.Serializable)x$5 -> x$5.setex(key, Predef$.MODULE$.Integer2int(ttl), value), func, endpoint);
    }

    public long setnx(String key, String value, Integer ttl, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return BoxesRunTime.unboxToLong(this.doRedis((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToLong((long)RedisUtils$.$anonfun$setnx$1(key, value, ttl, r)), func, endpoint));
    }

    public long hsetnx(String key, String field, String value, Integer ttl, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return BoxesRunTime.unboxToLong(this.doRedis((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToLong((long)RedisUtils$.$anonfun$hsetnx$1(key, field, value, ttl, r)), func, endpoint));
    }

    public String[] mget(String[] keys, RedisEndpoint endpoint) {
        return (String[])this.doRedis((Function1 & Serializable & scala.Serializable)x$6 -> (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$6.mget(keys)).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)), this.doRedis$default$2(), endpoint);
    }

    public long del(String key, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return BoxesRunTime.unboxToLong(this.doRedis((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x$7.del(key))), func, endpoint));
    }

    public Function0<BoxedUnit> del$default$2() {
        return null;
    }

    public String set(String key, String value, Integer ttl, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return (String)this.doRedis((Function1 & Serializable & scala.Serializable)r -> {
            String s = r.set(key, value);
            Object object = ttl != null ? r.expire(key, Predef$.MODULE$.Integer2int(ttl)) : BoxedUnit.UNIT;
            return s;
        }, func, endpoint);
    }

    public Integer setex$default$3() {
        return null;
    }

    public Function0<BoxedUnit> setex$default$4() {
        return null;
    }

    public Integer setnx$default$3() {
        return null;
    }

    public Function0<BoxedUnit> setnx$default$4() {
        return null;
    }

    public Integer set$default$3() {
        return null;
    }

    public Function0<BoxedUnit> set$default$4() {
        return null;
    }

    public long hset(String key, String field, String value, Integer ttl, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return BoxesRunTime.unboxToLong(this.doRedis((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToLong((long)RedisUtils$.$anonfun$hset$1(key, field, value, ttl, r)), func, endpoint));
    }

    public Integer hsetnx$default$4() {
        return null;
    }

    public Function0<BoxedUnit> hsetnx$default$5() {
        return null;
    }

    public Integer hset$default$4() {
        return null;
    }

    public Function0<BoxedUnit> hset$default$5() {
        return null;
    }

    public String hmset(String key, scala.collection.immutable.Map<String, String> hash, Integer ttl, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return (String)this.doRedis((Function1 & Serializable & scala.Serializable)r -> {
            String s = r.hmset(key, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)hash).asJava());
            Object object = ttl != null ? r.expire(key, Predef$.MODULE$.Integer2int(ttl)) : BoxedUnit.UNIT;
            return s;
        }, func, endpoint);
    }

    public Integer hmset$default$3() {
        return null;
    }

    public Function0<BoxedUnit> hmset$default$4() {
        return null;
    }

    public List<String> hmget(String key, Seq<String> fields, RedisEndpoint endpoint) {
        return (List)this.doRedis((Function1 & Serializable & scala.Serializable)x$8 -> JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(x$8.hmget(key, (String[])fields.toArray(ClassTag$.MODULE$.apply(String.class)))).toList(), this.doRedis$default$2(), endpoint);
    }

    public scala.collection.immutable.Map<String, String> hgetAll(String key, RedisEndpoint endpoint) {
        return (scala.collection.immutable.Map)this.doRedis((Function1 & Serializable & scala.Serializable)x$9 -> JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(x$9.hgetAll(key)).toMap(Predef$.MODULE$.$conforms()), this.doRedis$default$2(), endpoint);
    }

    public long hdel(String key, List<String> fields, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return key == null || fields == null || fields.isEmpty() ? 0L : BoxesRunTime.unboxToLong(this.doRedis((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x$10.hdel(key, (String[])fields.toArray(ClassTag$.MODULE$.apply(String.class))))), func, endpoint));
    }

    public Function0<BoxedUnit> hdel$default$3() {
        return null;
    }

    public long sadd(String key, List<String> members, Integer ttl, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return BoxesRunTime.unboxToLong(this.doRedis((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToLong((long)RedisUtils$.$anonfun$sadd$1(key, members, ttl, r)), func, endpoint));
    }

    public Integer sadd$default$3() {
        return null;
    }

    public Function0<BoxedUnit> sadd$default$4() {
        return null;
    }

    public Set<String> smembers(String key, RedisEndpoint endpoint) {
        return (Set)this.doRedis((Function1 & Serializable & scala.Serializable)x$11 -> x$11.smembers(key), this.doRedis$default$2(), endpoint);
    }

    public long srem(String key, List<String> members, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return BoxesRunTime.unboxToLong(this.doRedis((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x$12.srem(key, (String[])members.toArray(ClassTag$.MODULE$.apply(String.class))))), func, endpoint));
    }

    public Function0<BoxedUnit> srem$default$3() {
        return null;
    }

    public String getOrElseHset(String key, String field, String value, Integer ttl, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return (String)this.doRedis((Function1 & Serializable & scala.Serializable)x -> {
            Object object;
            String v = x.hget(key, field);
            if (v == null) {
                x.hset(key, field, value);
                object = ttl != null ? x.expire(key, Predef$.MODULE$.Integer2int(ttl)) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            return v;
        }, func, endpoint);
    }

    public Integer getOrElseHset$default$4() {
        return null;
    }

    public Function0<BoxedUnit> getOrElseHset$default$5() {
        return null;
    }

    public String getOrElseSet(String key, String value, Integer ttl, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return (String)this.doRedis((Function1 & Serializable & scala.Serializable)x -> {
            Object object;
            String v = x.get(key);
            if (v == null) {
                x.set(key, value);
                object = ttl != null ? x.expire(key, Predef$.MODULE$.Integer2int(ttl)) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            return v;
        }, func, endpoint);
    }

    public Integer getOrElseSet$default$3() {
        return null;
    }

    public Function0<BoxedUnit> getOrElseSet$default$4() {
        return null;
    }

    public long hincrBy(String key, String field, long value, Integer ttl, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return BoxesRunTime.unboxToLong(this.doRedis((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)RedisUtils$.$anonfun$hincrBy$1(key, field, value, ttl, x)), func, endpoint));
    }

    public Integer hincrBy$default$4() {
        return null;
    }

    public Function0<BoxedUnit> hincrBy$default$5() {
        return null;
    }

    public double hincrByFloat(String key, String field, double value, Integer ttl, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return BoxesRunTime.unboxToDouble(this.doRedis((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)RedisUtils$.$anonfun$hincrByFloat$1(key, field, value, ttl, x)), func, endpoint));
    }

    public Integer hincrByFloat$default$4() {
        return null;
    }

    public Function0<BoxedUnit> hincrByFloat$default$5() {
        return null;
    }

    public long incrBy(String key, long value, Integer ttl, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return BoxesRunTime.unboxToLong(this.doRedis((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)RedisUtils$.$anonfun$incrBy$1(key, value, ttl, x)), func, endpoint));
    }

    public Integer incrBy$default$3() {
        return null;
    }

    public Function0<BoxedUnit> incrBy$default$4() {
        return null;
    }

    public double incrByFloat(String key, double value, Integer ttl, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return BoxesRunTime.unboxToDouble(this.doRedis((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)RedisUtils$.$anonfun$incrByFloat$1(key, value, ttl, x)), func, endpoint));
    }

    public Integer incrByFloat$default$3() {
        return null;
    }

    public Function0<BoxedUnit> incrByFloat$default$4() {
        return null;
    }

    public long mSets(Seq<Tuple2<String, String>> kvs, Integer ttl, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return BoxesRunTime.unboxToLong(this.doRedis((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)RedisUtils$.$anonfun$mSets$1(kvs, ttl, x)), func, endpoint));
    }

    public Integer mSets$default$2() {
        return null;
    }

    public Function0<BoxedUnit> mSets$default$3() {
        return null;
    }

    public long mSetex(Seq<Tuple2<String, String>> kvs, Integer ttl, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return BoxesRunTime.unboxToLong(this.doRedis((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToLong((long)RedisUtils$.$anonfun$mSetex$1(kvs, ttl, x)), func, endpoint));
    }

    public Integer mSetex$default$2() {
        return null;
    }

    public Function0<BoxedUnit> mSetex$default$3() {
        return null;
    }

    public long expire(String key, int s, RedisEndpoint endpoint) {
        return BoxesRunTime.unboxToLong(this.doRedis((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x$13.expire(key, s))), this.doRedis$default$2(), endpoint));
    }

    public Object delByPattern(String key, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        return this.doRedis((Function1 & Serializable & scala.Serializable)r -> {
            RedisUtils$.$anonfun$delByPattern$1(key, r);
            return BoxedUnit.UNIT;
        }, func, endpoint);
    }

    public Function0<BoxedUnit> delByPattern$default$2() {
        return null;
    }

    public long hlen(String key, RedisEndpoint endpoint) {
        return BoxesRunTime.unboxToLong(this.doRedis((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x$14.hlen(key))), this.doRedis$default$2(), endpoint));
    }

    public <R> R doRedis(Function1<Jedis, R> f, Function0<BoxedUnit> func, RedisEndpoint endpoint) {
        Object object;
        Jedis redis = RedisClient$.MODULE$.connect(endpoint);
        Function0<BoxedUnit> function0 = func;
        if (function0 == null) {
            object = f.apply((Object)redis);
        } else {
            Transaction transaction = redis.multi();
            Object r = f.apply((Object)redis);
            func.apply$mcV$sp();
            transaction.exec();
            transaction.close();
            object = r;
        }
        Object result = object;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> redis.close());
        if (try_ instanceof Success) {
            this.logger().debug("jedis.close successful.");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            this.logger().error("jedis.close failed.");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
        return (R)result;
    }

    public <R> Function0<BoxedUnit> doRedis$default$2() {
        return null;
    }

    public <R> R doCluster(Function1<JedisCluster, R> f, Seq<RedisEndpoint> endpoint) {
        JedisCluster cluster = RedisClient$.MODULE$.connectCluster(endpoint);
        Object result = f.apply((Object)cluster);
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cluster.close());
        if (try_ instanceof Success) {
            this.logger().debug("cluster.close successful.");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            this.logger().error("cluster.close failed.");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
        return (R)result;
    }

    public <R> R doPipeline(Function1<Pipeline, R> f, RedisEndpoint endpoint) {
        Jedis redis = RedisClient$.MODULE$.connect(endpoint);
        Pipeline pipe = redis.pipelined();
        Object result = f.apply((Object)pipe);
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            pipe.sync();
            pipe.close();
            redis.close();
        });
        if (try_ instanceof Success) {
            this.logger().debug("pipe.close successful.");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            this.logger().error("pipe.close failed.");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
        return (R)result;
    }

    public static final /* synthetic */ long $anonfun$setnx$1(String key$6, String value$2, Integer ttl$2, Jedis r) {
        Long x = r.setnx(key$6, value$2);
        Object object = BoxesRunTime.equalsNumObject((Number)x, (Object)BoxesRunTime.boxToInteger((int)1)) && ttl$2 != null ? r.expire(key$6, Predef$.MODULE$.Integer2int(ttl$2)) : BoxedUnit.UNIT;
        return Predef$.MODULE$.Long2long(x);
    }

    public static final /* synthetic */ long $anonfun$hsetnx$1(String key$7, String field$3, String value$3, Integer ttl$3, Jedis r) {
        Long x = r.hsetnx(key$7, field$3, value$3);
        Object object = BoxesRunTime.equalsNumObject((Number)x, (Object)BoxesRunTime.boxToInteger((int)1)) && ttl$3 != null ? r.expire(key$7, Predef$.MODULE$.Integer2int(ttl$3)) : BoxedUnit.UNIT;
        return Predef$.MODULE$.Long2long(x);
    }

    public static final /* synthetic */ long $anonfun$hset$1(String key$10, String field$4, String value$5, Integer ttl$5, Jedis r) {
        Long s = r.hset(key$10, field$4, value$5);
        Object object = ttl$5 != null ? r.expire(key$10, Predef$.MODULE$.Integer2int(ttl$5)) : BoxedUnit.UNIT;
        return Predef$.MODULE$.Long2long(s);
    }

    public static final /* synthetic */ long $anonfun$sadd$1(String key$15, List members$1, Integer ttl$7, Jedis r) {
        Long res = r.sadd(key$15, (String[])members$1.toArray(ClassTag$.MODULE$.apply(String.class)));
        Object object = ttl$7 != null ? r.expire(key$15, Predef$.MODULE$.Integer2int(ttl$7)) : BoxedUnit.UNIT;
        return Predef$.MODULE$.Long2long(res);
    }

    public static final /* synthetic */ long $anonfun$hincrBy$1(String key$20, String field$6, long value$8, Integer ttl$10, Jedis x) {
        Long reply = x.hincrBy(key$20, field$6, value$8);
        Object object = ttl$10 != null ? x.expire(key$20, Predef$.MODULE$.Integer2int(ttl$10)) : BoxedUnit.UNIT;
        return Predef$.MODULE$.Long2long(reply);
    }

    public static final /* synthetic */ double $anonfun$hincrByFloat$1(String key$21, String field$7, double value$9, Integer ttl$11, Jedis x) {
        Double reply = x.hincrByFloat(key$21, field$7, value$9);
        Object object = ttl$11 != null ? x.expire(key$21, Predef$.MODULE$.Integer2int(ttl$11)) : BoxedUnit.UNIT;
        return Predef$.MODULE$.Double2double(reply);
    }

    public static final /* synthetic */ long $anonfun$incrBy$1(String key$22, long value$10, Integer ttl$12, Jedis x) {
        Long reply = x.incrBy(key$22, value$10);
        Object object = ttl$12 != null ? x.expire(key$22, Predef$.MODULE$.Integer2int(ttl$12)) : BoxedUnit.UNIT;
        return Predef$.MODULE$.Long2long(reply);
    }

    public static final /* synthetic */ double $anonfun$incrByFloat$1(String key$23, double value$11, Integer ttl$13, Jedis x) {
        Double reply = x.incrByFloat(key$23, value$11);
        Object object = ttl$13 != null ? x.expire(key$23, Predef$.MODULE$.Integer2int(ttl$13)) : BoxedUnit.UNIT;
        return Predef$.MODULE$.Double2double(reply);
    }

    public static final /* synthetic */ long $anonfun$mSets$1(Seq kvs$1, Integer ttl$14, Jedis x) {
        long start = System.currentTimeMillis();
        Pipeline pipe = x.pipelined();
        kvs$1.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            pipe.mset(new String[]{k, v});
            BoxedUnit boxedUnit = ttl$14 != null ? pipe.expire(k, Predef$.MODULE$.Integer2int(ttl$14)) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        pipe.sync();
        return System.currentTimeMillis() - start;
    }

    public static final /* synthetic */ long $anonfun$mSetex$1(Seq kvs$2, Integer ttl$15, Jedis x) {
        long start = System.currentTimeMillis();
        Pipeline pipe = x.pipelined();
        kvs$2.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            pipe.setnx(k, v);
            BoxedUnit boxedUnit = ttl$15 != null ? pipe.expire(k, Predef$.MODULE$.Integer2int(ttl$15)) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        pipe.sync();
        return System.currentTimeMillis() - start;
    }

    public static final /* synthetic */ void $anonfun$delByPattern$1(String key$25, Jedis r) {
        String string;
        String string2;
        ScanParams scanParams = new ScanParams();
        scanParams.match(key$25);
        scanParams.count(Predef$.MODULE$.int2Integer(10000));
        String cursor = ScanParams.SCAN_POINTER_START;
        do {
            ScanResult scanResult = r.scan(cursor, scanParams);
            cursor = scanResult.getCursor();
            List keys = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(scanResult.getResult()).toList();
            Object object = keys.nonEmpty() ? r.del((String[])keys.toArray(ClassTag$.MODULE$.apply(String.class))) : BoxedUnit.UNIT;
            string2 = cursor;
            string = "0";
        } while (string2 == null ? string != null : !string2.equals(string));
    }

    private RedisUtils$() {
        MODULE$ = this;
        Logger.$init$(this);
    }
}

