/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import net.sf.jsqlparser.util.validation.validator.LimitValidator;
import net.sf.jsqlparser.util.validation.validator.SelectValidator;

public class UpdateValidator
extends AbstractValidator<Update> {
    @Override
    public void validate(Update update) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.update);
            this.validateOptionalFeature(c, update.getFromItem(), Feature.updateFrom);
            this.validateOptionalFeature(c, update.getStartJoins(), Feature.updateJoins);
            this.validateFeature(c, update.isUseSelect(), Feature.updateUseSelect);
            this.validateOptionalFeature(c, update.getOrderByElements(), Feature.updateOrderBy);
            this.validateOptionalFeature(c, update.getLimit(), Feature.updateLimit);
            if (!this.isNotEmpty(update.getReturningExpressionList()) && !update.isReturningAllColumns()) continue;
            this.validateFeature(c, Feature.updateReturning);
        }
        this.validateOptionalFromItem(update.getTable());
        this.validateOptional(update.getStartJoins(), j -> this.getValidator(SelectValidator.class).validateOptionalJoins((List<Join>)j));
        if (update.isUseSelect()) {
            this.validateOptionalExpressions(update.getColumns());
            this.validateOptional(update.getSelect(), e -> e.getSelectBody().accept(this.getValidator(SelectValidator.class)));
        } else {
            this.validateOptionalExpressions(update.getColumns());
            this.validateOptionalExpressions(update.getExpressions());
        }
        if (update.getFromItem() != null) {
            this.validateOptionalFromItem(update.getFromItem());
            this.validateOptional(update.getJoins(), j -> this.getValidator(SelectValidator.class).validateOptionalJoins((List<Join>)j));
        }
        this.validateOptionalExpression(update.getWhere());
        this.validateOptionalOrderByElements(update.getOrderByElements());
        if (update.getLimit() != null) {
            this.getValidator(LimitValidator.class).validate(update.getLimit());
        }
        if (update.getReturningExpressionList() != null) {
            this.validateOptionalExpressions(update.getReturningExpressionList().stream().map(SelectExpressionItem::getExpression).collect(Collectors.toList()));
        }
    }
}

