/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.util;

import java.util.Random;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.apache.shiro.util.ByteSource;

public final class ShaHashUtils {
    public static final int DEFAULT_SALT_LENGTH = 26;

    private ShaHashUtils() {
    }

    public static String encrypt(String salt, String password) {
        return new Sha256Hash((Object)password, (Object)ByteSource.Util.bytes((String)salt), 1024).toHex();
    }

    public static String getRandomSalt() {
        return ShaHashUtils.getRandomSalt(26);
    }

    public static String getRandomSalt(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            builder.append(base.charAt(number));
        }
        return builder.toString();
    }
}

