/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.system.entity.Role;
import org.apache.streampark.console.system.entity.RoleMenu;
import org.apache.streampark.console.system.service.RoleMenuServie;
import org.apache.streampark.console.system.service.RoleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"role"})
public class RoleController {
    private static final Logger log = LoggerFactory.getLogger(RoleController.class);
    @Autowired
    private RoleService roleService;
    @Autowired
    private RoleMenuServie roleMenuServie;

    @PostMapping(value={"list"})
    @RequiresPermissions(value={"role:view"})
    public RestResponse roleList(RestRequest restRequest, Role role) {
        IPage<Role> roleList = this.roleService.findRoles(role, restRequest);
        return RestResponse.success(roleList);
    }

    @PostMapping(value={"check/name"})
    public RestResponse checkRoleName(@NotBlank(message="{required}") @NotBlank(message="{required}") String roleName) {
        Role result = this.roleService.findByName(roleName);
        return RestResponse.success(result == null);
    }

    @PostMapping(value={"menu"})
    public RestResponse getRoleMenus(@NotBlank(message="{required}") @NotBlank(message="{required}") String roleId) {
        List<RoleMenu> list = this.roleMenuServie.getByRoleId(roleId);
        List roleMenus = list.stream().map(roleMenu -> String.valueOf(roleMenu.getMenuId())).collect(Collectors.toList());
        return RestResponse.success(roleMenus);
    }

    @PostMapping(value={"post"})
    @RequiresPermissions(value={"role:add"})
    public RestResponse addRole(@Valid Role role) {
        this.roleService.createRole(role);
        return RestResponse.success();
    }

    @DeleteMapping(value={"delete"})
    @RequiresPermissions(value={"role:delete"})
    public RestResponse deleteRole(Long roleId) {
        this.roleService.deleteRole(roleId);
        return RestResponse.success();
    }

    @PutMapping(value={"update"})
    @RequiresPermissions(value={"role:update"})
    public RestResponse updateRole(Role role) throws Exception {
        this.roleService.updateRole(role);
        return RestResponse.success();
    }
}

