/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.bash;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.cli.Options;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.entrypoint.ClusterConfigurationParserFactory;
import org.apache.flink.runtime.util.ConfigurationParserUtils;
import org.apache.flink.runtime.util.bash.BashJavaUtils;
import org.apache.flink.util.FlinkException;

public class FlinkConfigLoader {
    private static final Options CMD_OPTIONS = ClusterConfigurationParserFactory.options();

    public static Configuration loadConfiguration(String[] args) throws FlinkException {
        return ConfigurationParserUtils.loadCommonConfiguration(FlinkConfigLoader.filterCmdArgs(args), BashJavaUtils.class.getSimpleName());
    }

    private static String[] filterCmdArgs(String[] args) {
        ArrayList<String> filteredArgs = new ArrayList<String>();
        Iterator<String> iter = Arrays.asList(args).iterator();
        while (iter.hasNext()) {
            String token = iter.next();
            if (CMD_OPTIONS.hasOption(token)) {
                filteredArgs.add(token);
                if (!CMD_OPTIONS.getOption(token).hasArg() || !iter.hasNext()) continue;
                filteredArgs.add(iter.next());
                continue;
            }
            if (!token.startsWith("-D")) continue;
            filteredArgs.add(token);
        }
        return filteredArgs.toArray(new String[0]);
    }

    private FlinkConfigLoader() {
    }
}

