/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.ansi.AnsiPropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class ResourceBanner
implements Banner {
    private static final Log logger = LogFactory.getLog(ResourceBanner.class);
    private final Resource resource;

    public ResourceBanner(Resource resource) {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        Assert.isTrue((boolean)resource.exists(), (String)"Resource must exist");
        this.resource = resource;
    }

    @Override
    public void printBanner(Environment environment, Class<?> sourceClass, PrintStream out) {
        try {
            String banner = StreamUtils.copyToString((InputStream)this.resource.getInputStream(), (Charset)((Charset)environment.getProperty("spring.banner.charset", Charset.class, (Object)StandardCharsets.UTF_8)));
            for (PropertyResolver resolver : this.getPropertyResolvers(environment, sourceClass)) {
                banner = resolver.resolvePlaceholders(banner);
            }
            out.println(banner);
        }
        catch (Exception ex) {
            logger.warn((Object)LogMessage.format((String)"Banner not printable: %s (%s: '%s')", (Object)this.resource, ex.getClass(), (Object)ex.getMessage()), (Throwable)ex);
        }
    }

    protected List<PropertyResolver> getPropertyResolvers(Environment environment, Class<?> sourceClass) {
        MutablePropertySources propertySources = new MutablePropertySources();
        if (environment instanceof ConfigurableEnvironment) {
            ((ConfigurableEnvironment)environment).getPropertySources().forEach(arg_0 -> ((MutablePropertySources)propertySources).addLast(arg_0));
        }
        propertySources.addLast((PropertySource)this.getTitleSource(sourceClass));
        propertySources.addLast((PropertySource)this.getAnsiSource());
        propertySources.addLast((PropertySource)this.getVersionSource(sourceClass));
        return Collections.singletonList(new PropertySourcesPropertyResolver((PropertySources)propertySources));
    }

    private MapPropertySource getVersionSource(Class<?> sourceClass) {
        return new MapPropertySource("version", this.getVersionsMap(sourceClass));
    }

    private Map<String, Object> getVersionsMap(Class<?> sourceClass) {
        String appVersion = this.getApplicationVersion(sourceClass);
        String bootVersion = this.getBootVersion();
        HashMap<String, Object> versions = new HashMap<String, Object>();
        versions.put("application.version", this.getVersionString(appVersion, false));
        versions.put("spring-boot.version", this.getVersionString(bootVersion, false));
        versions.put("application.formatted-version", this.getVersionString(appVersion, true));
        versions.put("spring-boot.formatted-version", this.getVersionString(bootVersion, true));
        return versions;
    }

    protected String getApplicationVersion(Class<?> sourceClass) {
        Package sourcePackage = sourceClass != null ? sourceClass.getPackage() : null;
        return sourcePackage != null ? sourcePackage.getImplementationVersion() : null;
    }

    protected String getBootVersion() {
        return SpringBootVersion.getVersion();
    }

    private String getVersionString(String version, boolean format) {
        if (version == null) {
            return "";
        }
        return format ? " (v" + version + ")" : version;
    }

    private AnsiPropertySource getAnsiSource() {
        return new AnsiPropertySource("ansi", true);
    }

    private MapPropertySource getTitleSource(Class<?> sourceClass) {
        String applicationTitle = this.getApplicationTitle(sourceClass);
        Map<String, String> titleMap = Collections.singletonMap("application.title", applicationTitle != null ? applicationTitle : "");
        return new MapPropertySource("title", titleMap);
    }

    protected String getApplicationTitle(Class<?> sourceClass) {
        Package sourcePackage = sourceClass != null ? sourceClass.getPackage() : null;
        return sourcePackage != null ? sourcePackage.getImplementationTitle() : null;
    }
}

