/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha.embedded;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.EmbeddedCompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.PerJobCheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedHaServices;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedLeaderService;
import org.apache.flink.runtime.highavailability.nonha.embedded.HaLeadershipControl;

public class EmbeddedHaServicesWithLeadershipControl
extends EmbeddedHaServices
implements HaLeadershipControl {
    private final CheckpointRecoveryFactory checkpointRecoveryFactory;

    public EmbeddedHaServicesWithLeadershipControl(Executor executor) {
        this(executor, new PerJobCheckpointRecoveryFactory<EmbeddedCompletedCheckpointStore>((maxCheckpoints, previous) -> {
            if (previous != null) {
                if (!previous.getShutdownStatus().isPresent()) {
                    throw new IllegalStateException("Completed checkpoint store from previous run has not yet shutdown.");
                }
                return new EmbeddedCompletedCheckpointStore((int)maxCheckpoints, (Collection<CompletedCheckpoint>)previous.getAllCheckpoints());
            }
            return new EmbeddedCompletedCheckpointStore((int)maxCheckpoints);
        }));
    }

    public EmbeddedHaServicesWithLeadershipControl(Executor executor, CheckpointRecoveryFactory checkpointRecoveryFactory) {
        super(executor);
        this.checkpointRecoveryFactory = checkpointRecoveryFactory;
    }

    @Override
    public CompletableFuture<Void> revokeDispatcherLeadership() {
        EmbeddedLeaderService dispatcherLeaderService = this.getDispatcherLeaderService();
        return dispatcherLeaderService.revokeLeadership();
    }

    @Override
    public CompletableFuture<Void> grantDispatcherLeadership() {
        EmbeddedLeaderService dispatcherLeaderService = this.getDispatcherLeaderService();
        return dispatcherLeaderService.grantLeadership();
    }

    @Override
    public CompletableFuture<Void> revokeJobMasterLeadership(JobID jobId) {
        EmbeddedLeaderService jobMasterLeaderService = this.getJobManagerLeaderService(jobId);
        return jobMasterLeaderService.revokeLeadership();
    }

    @Override
    public CompletableFuture<Void> grantJobMasterLeadership(JobID jobId) {
        EmbeddedLeaderService jobMasterLeaderService = this.getJobManagerLeaderService(jobId);
        return jobMasterLeaderService.grantLeadership();
    }

    @Override
    public CompletableFuture<Void> revokeResourceManagerLeadership() {
        EmbeddedLeaderService resourceManagerLeaderService = this.getResourceManagerLeaderService();
        return resourceManagerLeaderService.revokeLeadership();
    }

    @Override
    public CompletableFuture<Void> grantResourceManagerLeadership() {
        EmbeddedLeaderService resourceManagerLeaderService = this.getResourceManagerLeaderService();
        return resourceManagerLeaderService.grantLeadership();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckpointRecoveryFactory getCheckpointRecoveryFactory() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return this.checkpointRecoveryFactory;
        }
    }
}

